/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist.function;

import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.Handle;
import jas2.hist.HasHandles;
import jas2.hist.InvalidFunctionParameter;
import jas2.util.ArbitraryNameGenerator;

abstract class AbstractPolynomialFunction
extends Fittable1DFunction
implements HasHandles {
    protected double[] p;
    protected int order;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    AbstractPolynomialFunction() {
    }

    @Override
    public final double valueAt(double x) {
        double answer = this.p[this.order];
        for (int i = 0; i < this.order; ++i) {
            answer += Math.pow(x, this.order - i) * this.p[i];
        }
        return answer;
    }

    @Override
    public final double valueAt(double x, double[] a) {
        double answer = a[this.order];
        for (int i = 0; i < this.order; ++i) {
            answer += Math.pow(x, this.order - i) * a[i];
        }
        return answer;
    }

    @Override
    public final String[] getParameterNames() {
        String[] s = new String[this.order + 1];
        new ArbitraryNameGenerator().fillArray(s);
        return s;
    }

    @Override
    public final double[] getParameterValues() {
        return this.p;
    }

    @Override
    public final void setParameter(int index, double value) throws InvalidFunctionParameter {
        try {
            this.p[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid index to setParameter");
        }
        this.clearFit();
        this.setChanged();
    }

    @Override
    public final void setFit(Fitter fit, double[] value) throws InvalidFunctionParameter {
        if (value.length != this.p.length) {
            throw new IllegalArgumentException("Argument to setParameters is of wrong length");
        }
        this.p = value;
        this.setFit(fit);
        this.setChanged();
    }

    @Override
    public String getTitle() {
        return "Polynomial (order " + this.order + ")";
    }

    @Override
    public final Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        this.xmin = xLow;
        this.xmax = xHigh;
        this.ymin = yLow;
        this.ymax = yHigh;
        Handle[] result = this.order == 2 ? new Handle[]{new Handle(){

            @Override
            public void moveTo(double x, double y) {
                AbstractPolynomialFunction.this.p[1] = -2.0 * AbstractPolynomialFunction.this.p[0] * x;
                AbstractPolynomialFunction.this.p[2] = y - AbstractPolynomialFunction.this.p[0] * x * x - AbstractPolynomialFunction.this.p[1] * x;
                AbstractPolynomialFunction.this.clearFit();
                AbstractPolynomialFunction.this.setChanged();
            }

            @Override
            public double getX() {
                return -AbstractPolynomialFunction.this.p[1] / (2.0 * AbstractPolynomialFunction.this.p[0]);
            }

            @Override
            public double getY() {
                return AbstractPolynomialFunction.this.valueAt(this.getX());
            }
        }, new Handle(){

            @Override
            public void moveTo(double x, double y) {
                double xVertex = -AbstractPolynomialFunction.this.p[1] / (2.0 * AbstractPolynomialFunction.this.p[0]);
                double yVertex = AbstractPolynomialFunction.this.valueAt(xVertex);
                AbstractPolynomialFunction.this.p[0] = (y - yVertex) / Math.pow(x - xVertex, 2.0);
                AbstractPolynomialFunction.this.p[1] = -2.0 * AbstractPolynomialFunction.this.p[0] * xVertex;
                AbstractPolynomialFunction.this.p[2] = y - AbstractPolynomialFunction.this.p[0] * x * x - AbstractPolynomialFunction.this.p[1] * x;
                AbstractPolynomialFunction.this.clearFit();
                AbstractPolynomialFunction.this.setChanged();
            }

            @Override
            public double getY() {
                return AbstractPolynomialFunction.this.valueAt(this.getX());
            }

            @Override
            public double getX() {
                double xVertex = -AbstractPolynomialFunction.this.p[1] / (2.0 * AbstractPolynomialFunction.this.p[0]);
                double xMiddle = (AbstractPolynomialFunction.this.xmax - AbstractPolynomialFunction.this.xmin) / 2.0;
                if (xVertex > xMiddle && xVertex < AbstractPolynomialFunction.this.xmax) {
                    return (xVertex - AbstractPolynomialFunction.this.xmin) / 2.0 + AbstractPolynomialFunction.this.xmin;
                }
                if (xVertex <= xMiddle && xVertex > AbstractPolynomialFunction.this.xmin) {
                    return AbstractPolynomialFunction.this.xmax - (AbstractPolynomialFunction.this.xmax - xVertex) / 2.0;
                }
                return xMiddle;
            }
        }} : new Handle[]{new Handle(){

            @Override
            public void moveTo(double x, double y) {
                AbstractPolynomialFunction.this.p[AbstractPolynomialFunction.this.order] = 0.0;
                AbstractPolynomialFunction.this.p[AbstractPolynomialFunction.this.order] = y - AbstractPolynomialFunction.this.valueAt(x);
                AbstractPolynomialFunction.this.clearFit();
                AbstractPolynomialFunction.this.setChanged();
            }

            @Override
            public double getY() {
                return AbstractPolynomialFunction.this.valueAt(this.getX());
            }

            @Override
            public double getX() {
                return (AbstractPolynomialFunction.this.xmax - AbstractPolynomialFunction.this.xmin) / 2.0;
            }
        }};
        return result;
    }
}

