/*
 * Decompiled with CFR 0.152.
 */
package jasext.hist;

import jas2.hist.Fittable1DFunction;
import jas2.hist.FitterRegistry;
import jas2.hist.FunctionRegistry;
import jas2.plugin.ExtensionPlugin;
import jas2.plugin.IPluginInfo;
import jasext.hist.fitter.LeastSquaresFit;
import jasext.hist.function.CubicFunction;
import jasext.hist.function.ExponentialFunction;
import jasext.hist.function.GaussianFunction;
import jasext.hist.function.LandauFunction;
import jasext.hist.function.LorentzianFunction;
import jasext.hist.function.PolynomialFunction;
import jasext.hist.function.PowerLawFunction;
import jasext.hist.function.QuadraticFunction;
import jasext.hist.function.SplineFactory;
import jasext.hist.function.StraightLineFunction;
import jasext.hist.function.SumFunctionFactory;

public class Register
extends ExtensionPlugin
implements IPluginInfo {
    private FunctionRegistry func;

    @Override
    public void init() {
        this.func = FunctionRegistry.instance();
        this.func.registerFunction(StraightLineFunction.class, "Straight Line");
        this.func.registerFunction(QuadraticFunction.class, "Quadratic");
        this.func.registerFunction(CubicFunction.class, "Cubic");
        this.func.registerFunction(PolynomialFunction.class, "Polynomial");
        this.func.registerFunction(GaussianFunction.class, "Gaussian");
        this.func.registerFunction(ExponentialFunction.class, "Exponential");
        this.func.registerFunction(PowerLawFunction.class, "Power-law");
        this.func.registerFunction(LorentzianFunction.class, "Lorentzian (Breit-Wigner)");
        this.func.registerFunction(LandauFunction.class, "Landau");
        this.func.registerFunction(new SumFunctionFactory());
        this.func.registerFunction(new SplineFactory());
        FitterRegistry fit = FitterRegistry.instance();
        fit.registerFitter(LeastSquaresFit.class, "Least Squares");
    }

    public void addFunction(Fittable1DFunction ff) {
        this.func.registerFunction(ff.getClass(), ff.getTitle());
    }

    @Override
    public String getName() {
        return "Fitter";
    }

    @Override
    public String getVersion() {
        return "2.0.1";
    }
}

