/*
 * Decompiled with CFR 0.152.
 */
package jasext.flatfileserver;

import jas2.hist.Statistics;
import jasext.flatfileserver.DataColumn;
import jasext.flatfileserver.StringDataColumn;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

class DateDataColumn
extends DataColumn {
    private Date min = null;
    private Date max = null;
    private Date[] data;

    DateDataColumn(StringDataColumn source, DateFormat df) {
        super(source);
        this.data = new Date[source.getSize()];
        try {
            for (int i = 0; i < this.data.length; ++i) {
                String s = source.getString(i);
                if (s == null) {
                    this.data[i] = null;
                    continue;
                }
                Date d = df.parse(s);
                if (this.min == null) {
                    this.min = this.max = d;
                } else {
                    if (d.after(this.max)) {
                        this.max = d;
                    }
                    if (d.before(this.min)) {
                        this.min = d;
                    }
                }
                this.data[i] = d;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public int getSize() {
        return this.data.length;
    }

    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        double[] hist = new double[bins];
        double Xmin = this.getMin();
        double binWidth = (this.getMax() - Xmin) / (double)bins;
        for (int j = 0; j < bins; ++j) {
            hist[j] = 0.0;
        }
        for (int i = 0; i < this.data.length; ++i) {
            int bin;
            if (this.data[i] == null || (bin = (int)(((double)this.data[i].getTime() / 1000.0 - Xmin) / binWidth)) < 0 || bin >= bins) continue;
            int n = bin;
            hist[n] = hist[n] + 1.0;
        }
        double[][] result = new double[][]{hist};
        return result;
    }

    @Override
    public String[] getAxisLabels() {
        return null;
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    @Override
    public int getAxisType() {
        return 3;
    }

    @Override
    public double getMin() {
        return (double)this.min.getTime() / 1000.0;
    }

    @Override
    public double getMax() {
        return (double)this.max.getTime() / 1000.0;
    }

    @Override
    public int getBins() {
        return 40;
    }

    @Override
    Date getDate(int n) {
        return this.data[n];
    }

    @Override
    String getType() {
        return "time";
    }

    public Statistics getStatistics() {
        return null;
    }
}

