/*
 * Decompiled with CFR 0.152.
 */
package jas2main;

import jas2.hist.JASHist;
import jas2.hist.XMLHistBuilder;
import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class XMLHistViewer
extends JFrame {
    public static final Class[] noArgc = new Class[0];
    public static final Object[] noArgs = new Object[0];
    private XMLHistBuilder xhb;

    public XMLHistViewer(String str, String fileName) {
        super(str);
        this.getContentPane().add(new JLabel("Reading " + fileName + "..."));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    void load(String fileName) {
        try {
            this.xhb = new XMLHistBuilder(new BufferedReader(new FileReader(fileName)), fileName);
            JASHist hist = this.xhb.getSoloPlot();
            if (hist == null) {
                throw new RuntimeException("No Histogram found");
            }
            final JPanel p = new JPanel(new BorderLayout());
            p.add("Center", hist);
            JButton export = new JButton("Save As...");
            p.add("South", export);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XMLHistViewer.this.setContentPane(p);
                    XMLHistViewer.this.pack();
                }
            });
        }
        catch (Throwable t) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XMLHistViewer.this.dispose();
                    JOptionPane.showMessageDialog(null, t.getMessage(), "Error", 0);
                    System.exit(0);
                }
            });
        }
    }

    public static void main(String[] args) {
        XMLHistViewer xhv = new XMLHistViewer("XMLHistViewer", args[0]);
        try {
            Class<?> c = Class.forName("jasext.hist.Register");
            Method m = c.getMethod("init", noArgc);
            Object reg = c.newInstance();
            m.invoke(reg, noArgs);
        }
        catch (Throwable t) {
            System.err.println("Unable to register functions/fitters");
            t.printStackTrace();
        }
        xhv.pack();
        xhv.show();
        xhv.load(args[0]);
    }
}

