/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.tree;

import jas2.util.tree.SimpleNodeListener;
import jas2.util.tree.TreeItem;
import jas2.util.tree.TreeObjectSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class SimpleNode {
    private Vector listener;
    private int flags;
    private String name;
    private String type;
    private SimpleNode parent;
    protected FlashVector children;
    protected Object object;
    protected static final Enumeration nullEnumeration = new Vector().elements();

    public SimpleNode() {
        this.flags = 0;
        this.type = null;
        this.parent = null;
        this.name = null;
    }

    public SimpleNode(String name, String type, int flags, Object object) {
        this.parent = null;
        this.name = name;
        this.type = type;
        this.flags = flags;
        this.object = object;
    }

    public SimpleNode(SimpleNode parent, String name, String type, int flags, Object object) {
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.flags = flags;
        this.object = object;
        parent.addChild(this);
    }

    protected SimpleNode createNode(SimpleNode parent, String name, String type, int flags, Object object) {
        return new SimpleNode(parent, name, type, flags, object);
    }

    protected void addChild(SimpleNode child) {
        if (this.children == null) {
            this.children = new FlashVector();
        }
        this.children.put(child);
        child.treeChanged(0);
    }

    protected void removeChild(SimpleNode child) {
        child.treeChanged(2);
        this.children.remove(child);
    }

    protected void renameChild(SimpleNode child, String newName) {
        child.treeChanged(2);
        this.children.remove(child);
        child.name = newName;
        this.children.put(child);
        child.treeChanged(0);
    }

    protected void treeChanged(int extraFlags) {
        SimpleNode n = this.parent;
        int depth = 1;
        while (n != null) {
            if (n.listener != null) {
                String[] path = new String[depth];
                SimpleNode c = this;
                for (int j = depth - 1; j >= 0; --j) {
                    path[j] = c.name;
                    c = c.parent;
                }
                n.fireTreeChanged(new TreeItem(path, this.type, this.flags | extraFlags));
            }
            n = n.parent;
            ++depth;
        }
    }

    public TreeItem getTreeItem(SimpleNode base) {
        SimpleNode n = this;
        int depth = 0;
        while (n != base) {
            n = n.parent;
            ++depth;
        }
        String[] path = new String[depth];
        n = this;
        for (int j = depth - 1; j >= 0; --j) {
            path[j] = n.name;
            n = n.parent;
        }
        return new TreeItem(path, this.type, this.flags);
    }

    public SimpleNode findChild(String name) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(name);
    }

    public void destroy() {
        this.parent.removeChild(this);
        this.children = null;
    }

    public SimpleNode add(TreeItem item) {
        return this.add(item, null);
    }

    public SimpleNode add(TreeItem item, Object object) {
        SimpleNode parent = this;
        int l = item.path.length;
        for (int i = 0; i < l; ++i) {
            String element = item.path[i];
            SimpleNode child = parent.findChild(element);
            if (child == null) {
                if (i == l - 1) {
                    parent = this.createNode(parent, element, item.type, item.flags, object);
                    continue;
                }
                parent = this.createNode(parent, element, "folder", 4, null);
                continue;
            }
            parent = child;
            if (i != l - 1) continue;
            parent.flags = item.flags;
        }
        return parent;
    }

    public void remove(TreeItem item) {
        SimpleNode child = this.find(item);
        if (child != null) {
            child.destroy();
        }
    }

    public SimpleNode find(TreeItem item) {
        SimpleNode parent = this;
        int l = item.path.length;
        for (int i = 0; i < l && parent != null; parent = parent.findChild(item.path[i]), ++i) {
        }
        return parent;
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public SimpleNode getChild(int index) {
        return this.children.elementAt(index);
    }

    public int getIndexOfChild(Object child) {
        return this.children.indexOf((SimpleNode)child);
    }

    public Enumeration children() {
        if (this.children == null) {
            return nullEnumeration;
        }
        return Collections.enumeration(this.children.elements());
    }

    public Enumeration elements() {
        return new Enumeration(){
            private Iterator iter;
            {
                this.iter = SimpleNode.this.children.elements().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return ((SimpleNode)this.iter.next()).object;
            }
        };
    }

    public Object getObject() {
        if (this.object == null) {
            SimpleNode n = this.parent;
            int depth = 1;
            while (n != null) {
                if (n.object instanceof TreeObjectSource) {
                    TreeObjectSource tos = (TreeObjectSource)n.object;
                    String[] path = new String[depth];
                    SimpleNode c = this;
                    for (int j = depth - 1; j >= 0; --j) {
                        path[j] = c.name;
                        c = c.parent;
                    }
                    TreeItem item = new TreeItem(path, this.type, this.flags);
                    this.object = tos.getItem(new TreeItem(path, this.type, this.flags));
                    break;
                }
                n = n.parent;
                ++depth;
            }
        }
        return this.object;
    }

    public void setFlags(int mask) {
        int newFlags = this.flags | mask;
        if (newFlags != this.flags) {
            this.flags = newFlags;
            this.treeChanged(0);
        }
    }

    public void clearFlags(int mask) {
        int newFlags = this.flags & ~mask;
        if (newFlags != this.flags) {
            this.flags = newFlags;
            this.treeChanged(0);
        }
    }

    public boolean isAncestorOf(SimpleNode root) {
        SimpleNode search = this;
        while (search != null) {
            if (search == root) {
                return true;
            }
            search = search.parent;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public SimpleNode getParent() {
        return this.parent;
    }

    public void addNodeListener(SimpleNodeListener l) {
        if (this.listener == null) {
            this.listener = new Vector();
        }
        this.listener.addElement(l);
    }

    public void removeNodeListener(SimpleNodeListener l) {
        if (this.listener != null) {
            this.listener.removeElement(l);
        }
    }

    private void fireTreeChanged(TreeItem item) {
        Enumeration e = this.listener.elements();
        while (e.hasMoreElements()) {
            SimpleNodeListener l = (SimpleNodeListener)e.nextElement();
            l.treeChanged(item);
        }
    }

    public String toString() {
        return this.name;
    }

    static class FlashVector {
        private ArrayList vector = new ArrayList();
        private Flash flash;

        FlashVector() {
        }

        void put(SimpleNode node) {
            this.vector.add(node);
            if (this.flash != null) {
                this.flash.put(node.name, this.vector.size() - 1);
            }
        }

        void remove(SimpleNode node) {
            if (this.flash != null) {
                this.vector.remove(this.flash.get(node.name));
            } else {
                this.vector.remove(node);
            }
            this.flash = null;
        }

        SimpleNode get(String name) {
            int index;
            if (this.flash == null) {
                this.fillFlash();
            }
            return (index = this.flash.get(name)) < 0 ? null : (SimpleNode)this.vector.get(index);
        }

        SimpleNode elementAt(int index) {
            return (SimpleNode)this.vector.get(index);
        }

        int indexOf(SimpleNode node) {
            if (this.flash == null) {
                this.fillFlash();
            }
            return this.flash.get(node.name);
        }

        int size() {
            return this.vector.size();
        }

        Collection elements() {
            return Collections.unmodifiableCollection(this.vector);
        }

        private void fillFlash() {
            int s = this.vector.size();
            this.flash = new Flash(s);
            for (int i = 0; i < s; ++i) {
                this.flash.put(((SimpleNode)this.vector.get(i)).name, i);
            }
        }

        private class Flash {
            private int[] array;
            private int nentry;
            private int threshold;

            Flash(int size) {
                this.array = new int[Math.max(11, 137 * size / 50)];
                this.nentry = 0;
                this.threshold = this.array.length / 2;
            }

            void put(String name, int index) {
                if (this.nentry++ > this.threshold) {
                    this.rehash();
                }
                int hash = Math.abs(name.hashCode()) % this.array.length;
                while (this.array[hash] != 0) {
                    hash = (hash + 1) % this.array.length;
                }
                this.array[hash] = index + 1;
            }

            private void rehash() {
                int newLength = this.array.length * 2 + 1;
                int[] newArray = new int[newLength];
                this.threshold = newLength / 2;
                for (int i = 0; i < this.array.length; ++i) {
                    int index = this.array[i] - 1;
                    if (index < 0) continue;
                    int hash = Math.abs(((SimpleNode)FlashVector.this.vector.get(index)).name.hashCode()) % newLength;
                    while (newArray[hash] != 0) {
                        hash = (hash + 1) % newLength;
                    }
                    newArray[hash] = index + 1;
                }
                this.array = newArray;
            }

            int get(String name) {
                int hash = Math.abs(name.hashCode());
                int index;
                while ((index = this.array[hash %= this.array.length] - 1) >= 0) {
                    SimpleNode node = (SimpleNode)FlashVector.this.vector.get(index);
                    if (node.name.equals(name)) {
                        return index;
                    }
                    ++hash;
                }
                return -1;
            }
        }
    }
}

