/*
 * Decompiled with CFR 0.152.
 */
package jas2.util.tree;

import jas2.util.tree.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OrderedNode
extends SimpleNode {
    private List orderedList;
    private Comparator comp;
    public static final Comparator DEFAULT_ORDER = new Comparator(){

        public boolean equals() {
            return false;
        }

        public int compare(Object o1, Object o2) {
            return 0;
        }
    };

    public OrderedNode() {
    }

    public OrderedNode(String name, String type, int flags, Object object) {
        super(name, type, flags, object);
    }

    public OrderedNode(SimpleNode parent, String name, String type, int flags, Object object) {
        super(parent, name, type, flags, object);
    }

    @Override
    protected SimpleNode createNode(SimpleNode parent, String name, String type, int flags, Object object) {
        return new OrderedNode(parent, name, type, flags, object);
    }

    @Override
    protected void addChild(SimpleNode child) {
        if (this.getEffectiveOrder() != null) {
            if (this.orderedList == null) {
                this.orderedList = this.createOrderedList(Collections.singleton(child));
            } else {
                int ip = Collections.binarySearch(this.orderedList, child, this.getEffectiveOrder());
                System.out.println("ip=" + ip);
                if (ip < 0) {
                    ip = -ip - 1;
                }
                this.orderedList.add(ip, child);
            }
        }
        super.addChild(child);
    }

    @Override
    protected void removeChild(SimpleNode child) {
        super.removeChild(child);
        if (this.orderedList != null) {
            this.orderedList.remove(child);
        }
    }

    @Override
    public SimpleNode getChild(int index) {
        if (this.orderedList != null) {
            return (SimpleNode)this.orderedList.get(index);
        }
        return super.getChild(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        if (this.orderedList != null) {
            return Collections.binarySearch(this.orderedList, child, this.getEffectiveOrder());
        }
        return super.getIndexOfChild(child);
    }

    public int getNaturalIndex() {
        return this.getParent().children.indexOf(this);
    }

    protected List createOrderedList(Collection c) {
        return new ArrayList(c);
    }

    public void setOrder(Comparator comp) {
        if (this.comp != comp) {
            this.comp = comp;
            this.notifyOrderChanged();
        }
    }

    public void clearOrder() {
        this.setOrder(null);
    }

    private void notifyOrderChanged() {
        this.orderChanged();
        this.treeChanged(8);
    }

    private void orderChanged() {
        Comparator comp = this.getEffectiveOrder();
        if (comp == null) {
            this.orderedList = null;
        } else {
            this.orderedList = this.createOrderedList(this.children == null ? Collections.EMPTY_LIST : this.children.elements());
            Collections.sort(this.orderedList, comp);
        }
        if (this.children != null) {
            for (Object o : this.children.elements()) {
                if (!(o instanceof OrderedNode)) continue;
                OrderedNode on = (OrderedNode)o;
                if (on.comp != null) continue;
                on.orderChanged();
            }
        }
    }

    public Comparator getOrder() {
        return this.comp;
    }

    private Comparator getEffectiveOrder() {
        if (this.comp != null) {
            return this.comp;
        }
        if (this.comp == DEFAULT_ORDER) {
            return null;
        }
        SimpleNode parent = this.getParent();
        if (parent instanceof OrderedNode) {
            return ((OrderedNode)parent).getEffectiveOrder();
        }
        return null;
    }
}

