/*
 * Decompiled with CFR 0.152.
 */
package jas2.tuple;

import jas2.tuple.ComboCellEditor;
import jas2.tuple.ComboCellRenderer;
import jas2.tuple.TupleColumn;
import java.util.BitSet;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

abstract class TupleModel
extends AbstractTableModel {
    private String[] rowLabels;
    private String[] col = new String[]{"Parameter", "Value"};
    private Integer[] values;
    private TupleColumn[] tupleColumns;
    private String[] labels;

    TupleModel(String[] rowLabels, int[] rowValues, TupleColumn[] tupleColumns) {
        int i;
        this.rowLabels = rowLabels;
        this.tupleColumns = tupleColumns;
        this.values = new Integer[rowValues.length];
        for (i = 0; i < this.values.length; ++i) {
            this.values[i] = new Integer(rowValues[i]);
        }
        this.labels = new String[tupleColumns.length + 1];
        this.labels[0] = "1.0";
        for (i = 0; i < tupleColumns.length; ++i) {
            this.labels[i + 1] = tupleColumns[i].toString();
        }
    }

    @Override
    public int getRowCount() {
        return this.rowLabels.length;
    }

    @Override
    public int getColumnCount() {
        return this.col.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.rowLabels[row];
        }
        return this.values[row];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public String getColumnName(int column) {
        return this.col[column];
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        System.out.println("value=" + value + " row=" + row + " col=" + column);
        if (column == 1) {
            this.values[row] = (Integer)value;
        }
    }

    int getValue(int index) {
        return this.values[index];
    }

    TupleColumn getColumn(int index) {
        return this.tupleColumns[this.getValue(index)];
    }

    void setRenderers(TableColumnModel m) {
        ComboCellEditor XXeditor = new ComboCellEditor(this.labels);
        ComboCellRenderer XXrenderer = new ComboCellRenderer(this.labels);
        m.getColumn(1).setCellEditor(XXeditor);
        m.getColumn(1).setCellRenderer(XXrenderer);
    }

    BitSet getBits(int row, int column) {
        BitSet bits = new BitSet();
        for (int i = 0; i < this.labels.length; ++i) {
            bits.set(i);
        }
        return bits;
    }
}

