/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio.adaptor;

import hepjas.analysis.NamedObject;
import jas2.hist.JASHist;
import jas2.job.PlotAccess;
import jas2.swingstudio.JASException;
import jas2.swingstudio.JASPage;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.TreeAdaptor;
import jas2.util.JASMenuItem;
import jas2.util.JASState;
import jas2.util.OnScreenPopupMenu;
import javax.swing.JPopupMenu;

public class PlotTreeAdaptor
extends TreeAdaptor {
    private static JPopupMenu menu;
    private PlotAccess m_plot;

    @Override
    protected void init() {
        this.m_plot = (PlotAccess)this.getAssociatedObject();
    }

    @Override
    protected void updateNode(int flags) {
        if ((flags & 0x80000) != 0) {
            this.onShow();
        }
    }

    public void onShowInNewPlot() {
        JASPage page = JavaAnalysisStudio.getApp().getCurrentPage();
        page.addPlot();
        JASHist hist = page.getCurrentPlot();
        int n = this.m_plot.getNDataSources();
        for (int i = 0; i < n; ++i) {
            hist.addData(this.m_plot.getData(i)).show(true);
        }
        JASPage.calculateTitlesAndLabels(hist);
        page.currentPlotUpdated();
    }

    public void enableShowInNewPlot(JASState state) {
        state.setEnabled(JavaAnalysisStudio.getApp().getCurrentPage() != null);
    }

    public void onShowOnNewPage() {
        JASPage page = JavaAnalysisStudio.getApp().createNewPage();
        JASHist hist = page.getCurrentPlot();
        int n = this.m_plot.getNDataSources();
        for (int i = 0; i < n; ++i) {
            hist.addData(this.m_plot.getData(i)).show(true);
        }
        JASPage.calculateTitlesAndLabels(hist);
        page.currentPlotUpdated();
    }

    public void onDoubleClick() throws JASException {
        this.onShow();
    }

    public void onShow() {
        JASPage page = JavaAnalysisStudio.getApp().createCurrentPage();
        if (page != null) {
            JASHist hist = page.getCurrentPlot();
            hist.removeAllData();
            int n = this.m_plot.getNDataSources();
            for (int i = 0; i < n; ++i) {
                hist.addData(this.m_plot.getData(i)).show(true);
            }
            JASPage.calculateTitlesAndLabels(hist);
            page.currentPlotUpdated();
        }
    }

    public void onDelete() {
        this.m_plot.delete();
    }

    public void onRename() {
        this.startEditing();
    }

    @Override
    public boolean stopEditing(String newName) {
        try {
            this.m_plot.rename(newName);
            return true;
        }
        catch (NamedObject.RenameException x) {
            JavaAnalysisStudio.getApp().error("Illegal name", x);
            return false;
        }
    }

    @Override
    protected boolean isEditable() {
        return true;
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = new OnScreenPopupMenu();
            menu.add(new JASMenuItem("Show", 'S'));
            menu.add(new JASMenuItem("Show In New Plot", 'P'));
            menu.add(new JASMenuItem("Show On New Page", 'N'));
            menu.add(new JASMenuItem("Rename", 'R'));
            menu.add(new JASMenuItem("Delete", 'D'));
        }
        return menu;
    }
}

