/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio.adaptor;

import jas2.hist.DataSource;
import jas2.hist.JASHist;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.Rebinnable2DHistogramData;
import jas2.swingstudio.JASPage;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.TreeAdaptor;
import jas2.swingstudio.adaptor.OneDTreeData;
import jas2.swingstudio.adaptor.ScatterTreeData;
import jas2.util.JASMenuItem;
import jas2.util.JASState;
import jas2.util.OnScreenPopupMenu;
import javax.swing.JPopupMenu;

public class HistogramTreeAdaptor
extends TreeAdaptor {
    private static JPopupMenu menu;
    private DataSource m_data;

    @Override
    protected void init() {
        DataSource ds = (DataSource)this.getAssociatedObject();
        if (ds instanceof Rebinnable1DHistogramData) {
            this.m_data = new OneDTreeData(this.getTreeItem(), (Rebinnable1DHistogramData)ds);
        } else if (ds instanceof Rebinnable2DHistogramData) {
            this.m_data = new ScatterTreeData(this.getTreeItem(), (Rebinnable2DHistogramData)ds);
        }
    }

    public void onShowInNewPlot() {
        JASPage page = JavaAnalysisStudio.getApp().getCurrentPage();
        page.addPlot();
        JASHist plot = page.getCurrentPlot();
        plot.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(plot);
        page.currentPlotUpdated();
    }

    public void enableShowInNewPlot(JASState state) {
        state.setEnabled(JavaAnalysisStudio.getApp().getCurrentPage() != null);
    }

    public void onShowOnNewPage() {
        JASPage page = JavaAnalysisStudio.getApp().createNewPage();
        JASHist plot = page.getCurrentPlot();
        plot.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(plot);
        page.currentPlotUpdated();
    }

    public void onShow() {
        JASPage page = JavaAnalysisStudio.getApp().createCurrentPage();
        if (page != null) {
            JASHist plot = page.getCurrentPlot();
            plot.removeAllData();
            plot.addData(this.m_data).show(true);
            JASPage.calculateTitlesAndLabels(plot);
            page.currentPlotUpdated();
        }
    }

    public void onOverlay() {
        JASPage page = JavaAnalysisStudio.getApp().getCurrentPage();
        JASHist plot = page.getCurrentPlot();
        plot.addData(this.m_data).show(true);
        JASPage.calculateTitlesAndLabels(plot);
        page.currentPlotUpdated();
    }

    public void enableOverlay(JASState state) {
        JASPage page = JavaAnalysisStudio.getApp().getCurrentPage();
        if (page != null) {
            JASHist plot = page.getCurrentPlot();
            state.setEnabled(plot.getNumberOfDataSources() > 0);
        } else {
            state.setEnabled(false);
        }
    }

    public void onDoubleClick() {
        this.onShow();
    }

    public void onSelect() {
        JavaAnalysisStudio.getApp().setMessage(this.m_data.toString());
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = new OnScreenPopupMenu();
            menu.add(new JASMenuItem("Show", 'S'));
            menu.add(new JASMenuItem("Overlay", 'O'));
            menu.add(new JASMenuItem("Show In New Plot", 'P'));
            menu.add(new JASMenuItem("Show On New Page", 'N'));
        }
        return menu;
    }
}

