/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio.adaptor;

import hepjas.analysis.NamedObject;
import jas2.job.HistogramAccess;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.adaptor.FolderTreeAdaptor;
import jas2.util.JASCheckboxMenuItem;
import jas2.util.JASCheckboxState;
import jas2.util.JASMenuItem;
import javax.swing.JPopupMenu;

public class HistogramFolderTreeAdaptor
extends FolderTreeAdaptor {
    private static JPopupMenu menu;
    private HistogramAccess folder;

    @Override
    public void init() {
        super.init();
        this.folder = (HistogramAccess)this.getAssociatedObject();
    }

    public void onDelete() {
        this.folder.delete();
    }

    public void onRename() {
        this.startEditing();
    }

    @Override
    public boolean stopEditing(String newName) {
        try {
            this.folder.rename(newName);
            return true;
        }
        catch (NamedObject.RenameException x) {
            JavaAnalysisStudio.getApp().error("Illegal name", x);
            return false;
        }
    }

    public void enableClearOnRewind(JASCheckboxState state) {
        state.setEnabled(this.folder.canSetClearOnRewind());
        state.setCheckbox(this.folder.isClearOnRewind());
    }

    public void onClearOnRewind(boolean value) {
        this.folder.setClearOnRewind(value);
    }

    public void onClear() {
        this.folder.clear();
    }

    @Override
    protected boolean isEditable() {
        return true;
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = super.getPopupMenu();
            menu.insert(new JASMenuItem("Clear", 'C'), 0);
            menu.insert(new JASCheckboxMenuItem("Clear On Rewind", 'W'), 1);
            menu.insert(new JASMenuItem("Rename", 'R'), 2);
            menu.insert(new JASMenuItem("Delete", 'D'), 3);
        }
        return menu;
    }
}

