/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RebinSlider
extends JToolBar
implements ChangeListener,
ActionListener {
    private JSlider slider = new JSlider();
    private JTextField text;
    private JComboBox xy;
    private BoundedRangeModel m_model;
    private BoundedRangeModel xModel;
    private BoundedRangeModel yModel;

    public RebinSlider() {
        this.slider.setOrientation(0);
        this.slider.setToolTipText("Rebin Slider");
        this.text = new JTextField(4);
        this.text.setToolTipText("Bins");
        this.text.addActionListener(this);
        this.xy = new JComboBox<String>(new String[]{"X", "Y"});
        this.xy.setToolTipText("Axis Selector");
        this.xy.addActionListener(this);
        this.setState(false);
        this.xy.setEnabled(false);
        this.add(this.slider);
        this.add(this.text);
        this.add(this.xy);
    }

    public void setModel(BoundedRangeModel xModel, BoundedRangeModel yModel) {
        this.xModel = xModel;
        this.yModel = yModel;
        if (xModel != null) {
            this.setModel(xModel);
            this.xy.setSelectedIndex(0);
        } else if (yModel != null) {
            this.setModel(yModel);
            this.xy.setSelectedIndex(1);
        }
        this.xy.setEnabled(xModel != null && yModel != null);
        this.setState(xModel != null || yModel != null);
    }

    private void setModel(BoundedRangeModel model) {
        if (model != null) {
            this.slider.setModel(model);
            this.text.setText(String.valueOf(model.getValue()));
        }
        if (this.m_model != null) {
            this.m_model.removeChangeListener(this);
        }
        this.m_model = model;
        if (this.m_model != null) {
            this.m_model.addChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.text.setText(String.valueOf(this.m_model.getValue()));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.text) {
            try {
                this.m_model.setValue(Integer.parseInt(this.text.getText()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (source == this.xy) {
            int index = this.xy.getSelectedIndex();
            if (index == 0) {
                this.setModel(this.xModel);
            } else {
                this.setModel(this.yModel);
            }
        }
    }

    private void setState(boolean state) {
        this.slider.setEnabled(state);
        this.text.setEnabled(state);
    }
}

