/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.jds.module.LocalDIM;
import jas2.jds.module.NoSetupLocalDIM;
import jas2.swingstudio.JASLocalJobBuilder;
import jas2.swingstudio.JASRegistry;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.Finishable;
import jas2.util.HasHelpPage;
import jas2.util.HasNextPages;
import jas2.util.JASWizardPage;
import jas2.util.UserProperties;
import jas2.util.WrappingTextArea;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

final class LocalJobPage
extends JASWizardPage
implements HasNextPages,
HasHelpPage,
Finishable,
ItemListener {
    private JASWizardPage[] m_nextPages;
    private JComboBox m_DIMs = new JComboBox();
    private JASLocalJobBuilder m_ljb;
    private final String m_lastLocalDIM_Key = "LastLocalDIM";
    private JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private final UserProperties m_prop = this.m_app.getUserProperties();

    LocalJobPage() {
        super(new BorderLayout());
        JPanel dimPanel = new JPanel(new FlowLayout());
        dimPanel.add(new JLabel("Select a Data Interface Module (DIM): "));
        dimPanel.add(this.m_DIMs);
        this.add("North", dimPanel);
        WrappingTextArea ta = new WrappingTextArea("All Data Interface Modules (DIM) registered in the Local DIM registry are available as choices above.  To add or remove classes from the Local DIM registry, open the \"Option\" dialog from the \"View\" menu or from the popup menu, and select the \"Local DIM Registry\" tab.", false, this.getBackground(), new Dimension(400, 75));
        JPanel p = new JPanel();
        p.add(ta);
        this.add("Center", p);
    }

    LocalJobPage(JASLocalJobBuilder ljb) {
        this();
        this.setJobBuilder(ljb);
    }

    @Override
    public void beforeShowing() {
        this.m_DIMs.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.doEnable();
    }

    @Override
    public JASWizardPage[] getNextWizardPages() {
        LocalDIM[] dimArray = JASRegistry.getDIMs();
        this.m_nextPages = new JASWizardPage[dimArray.length];
        for (int i = 0; i < dimArray.length; ++i) {
            LocalDIM dim = dimArray[i];
            this.m_nextPages[i] = dim.getSetupPage();
            this.m_DIMs.addItem(dim.toString());
        }
        try {
            String lastDIM = this.m_prop.getString("LastLocalDIM", null);
            this.m_DIMs.setSelectedItem(lastDIM);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_nextPages;
    }

    @Override
    public JASWizardPage getNext() {
        int index = this.m_DIMs.getSelectedIndex();
        this.m_prop.setString("LastLocalDIM", (String)this.m_DIMs.getSelectedItem());
        JASWizardPage next = this.m_nextPages[index];
        LocalDIM dim = JASRegistry.getDIM(index);
        dim.setLocalJobBuilder(this.m_ljb);
        this.m_ljb.setDIM(dim);
        return next;
    }

    @Override
    public void onFinish() {
        int index = this.m_DIMs.getSelectedIndex();
        this.m_prop.setString("LastLocalDIM", (String)this.m_DIMs.getSelectedItem());
        LocalDIM dim = JASRegistry.getDIM(index);
        dim.setLocalJobBuilder(this.m_ljb);
        this.m_ljb.setDIM(dim);
        ((NoSetupLocalDIM)dim).finish();
        this.dispose();
    }

    void setJobBuilder(JASLocalJobBuilder ljb) {
        this.m_ljb = ljb;
    }

    @Override
    protected boolean getNextEnabled() {
        if (this.m_DIMs.getSelectedIndex() < 0) {
            return false;
        }
        return this.m_nextPages[this.m_DIMs.getSelectedIndex()] != null;
    }

    @Override
    protected boolean getFinishEnabled() {
        if (this.m_DIMs.getSelectedIndex() < 0) {
            return false;
        }
        return this.m_nextPages[this.m_DIMs.getSelectedIndex()] == null;
    }

    @Override
    public String getHelpTopic() {
        return "userInterface.newJobWizard.selectingALocalDataInterfaceModule";
    }
}

