/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.NamedObject;
import jas2.jds.interfaces.RemotePageAccess;
import jas2.job.PageAccess;
import jas2.job.PlotAccess;
import jas2.swingstudio.JASPlotAccessAdaptor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;

class JASPageAccessAdaptor
implements PageAccess {
    private RMIEventDelivery m_ed;
    private RemotePageAccess m_remote;
    private JavaAnalysisStudio app = JavaAnalysisStudio.getApp();

    public JASPageAccessAdaptor(RemotePageAccess remote, RMIEventDelivery ed) {
        this.m_remote = remote;
        this.m_ed = ed;
    }

    @Override
    public void delete() {
        try {
            this.m_remote.delete();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
        }
    }

    @Override
    public void rename(String newName) throws NamedObject.RenameException {
        try {
            this.m_remote.rename(newName);
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
        }
    }

    @Override
    public int getNPlots() {
        try {
            return this.m_remote.getNPlots();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return 0;
        }
    }

    @Override
    public PlotAccess getPlot(int index) {
        try {
            RMIDestination dest = this.m_ed.getRMIDestination();
            return new JASPlotAccessAdaptor(this.m_remote.getPlot(index, dest), this.m_ed);
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return null;
        }
    }
}

