/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.NamedObject;
import jas2.hist.DataSource;
import jas2.jds.interfaces.RemoteHistogramAccess;
import jas2.job.HistogramAccess;
import jas2.swingstudio.JASRebinAdaptor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;

class JASHistogramAccessAdaptor
implements HistogramAccess {
    private RMIEventDelivery m_ed;
    private RemoteHistogramAccess m_remote;
    private JavaAnalysisStudio app = JavaAnalysisStudio.getApp();

    public JASHistogramAccessAdaptor(RemoteHistogramAccess remote, RMIEventDelivery ed) {
        this.m_remote = remote;
        this.m_ed = ed;
    }

    @Override
    public void delete() {
        try {
            this.m_remote.delete();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
        }
    }

    @Override
    public void rename(String newName) throws NamedObject.RenameException {
        try {
            this.m_remote.rename(newName);
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
        }
    }

    @Override
    public void clear() {
        try {
            this.m_remote.clear();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
        }
    }

    @Override
    public boolean isClearOnRewind() {
        try {
            return this.m_remote.isClearOnRewind();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return false;
        }
    }

    @Override
    public boolean canSetClearOnRewind() {
        try {
            return this.m_remote.canSetClearOnRewind();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return false;
        }
    }

    @Override
    public void setClearOnRewind(boolean value) {
        try {
            this.m_remote.setClearOnRewind(value);
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
        }
    }

    @Override
    public String getDescription() {
        try {
            return this.m_remote.getDescription();
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return "";
        }
    }

    @Override
    public DataSource getData() {
        try {
            RMIDestination dest = this.m_ed.getRMIDestination();
            return JASRebinAdaptor.getAdaptor(this.m_remote.getData(dest), this.m_ed, dest);
        }
        catch (RemoteException x) {
            this.app.error("Network Error", x);
            return null;
        }
    }
}

