/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.hist.ExtendedStatistics;
import jas2.hist.HasSlices;
import jas2.hist.HasStatistics;
import jas2.hist.HasStyle;
import jas2.hist.HistogramUpdate;
import jas2.hist.JASHistStyle;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.Rebinnable2DHistogramData;
import jas2.hist.SliceParameters;
import jas2.hist.Statistics;
import jas2.jds.interfaces.Remote2DHistogramInfo;
import jas2.jds.interfaces.RemoteRebinnable2DHistogramData;
import jas2.swingstudio.JASRebinAdaptor;
import jas2.swingstudio.JASSliceAdaptor;
import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;
import java.rmi.ServerRuntimeException;
import java.util.Observable;
import java.util.Observer;

public class JAS2DRebinAdaptor
extends Observable
implements Rebinnable2DHistogramData,
Observer,
HasSlices,
HasStyle,
HasStatistics,
ExtendedStatistics {
    private double[][][] cacheData;
    private boolean cacheErrors;
    private AxisCache xAxisCache = new AxisCache();
    private AxisCache yAxisCache = new AxisCache();
    protected Remote2DHistogramInfo info;
    private Statistics cacheStats;
    private String[] xAxisLabels;
    private String[] yAxisLabels;
    private RemoteRebinnable2DHistogramData m_remote;
    private RMIEventDelivery m_ed;
    private static final boolean debug = System.getProperty("debugCache") != null;

    public JAS2DRebinAdaptor(RemoteRebinnable2DHistogramData source, RMIDestination obs, RMIEventDelivery ed) {
        obs.addObserver(this);
        this.m_remote = source;
        this.m_ed = ed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable obs, Object arg) {
        HistogramUpdate hu = (HistogramUpdate)arg;
        this.setChanged();
        JAS2DRebinAdaptor jAS2DRebinAdaptor = this;
        synchronized (jAS2DRebinAdaptor) {
            if (hu.isDataUpdate()) {
                this.cacheStats = null;
                this.cacheData = null;
            }
            if (hu.isRangeUpdate()) {
                this.info = null;
                this.xAxisLabels = null;
                this.yAxisLabels = null;
            }
            if (hu.isTitleUpdate()) {
                this.info = null;
            }
            if (hu.isReset()) {
                this.info = null;
                this.cacheStats = null;
                this.cacheData = null;
                this.xAxisLabels = null;
                this.yAxisLabels = null;
            }
        }
        this.notifyObservers(hu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][][] rebin(int xbins, double xmin, double xmax, int ybins, double ymin, double ymax, boolean wantErrors, boolean hurry, boolean overflow) {
        double[][][] result;
        if (this.cacheData != null && (!this.xAxisCache.equals(xbins, xmin, xmax) || !this.yAxisCache.equals(ybins, ymin, ymax) || wantErrors && !this.cacheErrors)) {
            this.cacheData = null;
        }
        if ((result = this.cacheData) == null) {
            try {
                JAS2DRebinAdaptor jAS2DRebinAdaptor = this;
                synchronized (jAS2DRebinAdaptor) {
                    this.cacheData = result = this.m_remote.remoteRebin(xbins, xmin, xmax, ybins, ymin, ymax, wantErrors, hurry, overflow);
                }
                if (hurry) {
                    return result;
                }
                this.xAxisCache.setCache(xbins, xmin, xmax);
                this.yAxisCache.setCache(ybins, ymin, ymax);
                this.cacheErrors = wantErrors;
            }
            catch (ServerRuntimeException e) {
                System.out.println("Server Runtime exception!!");
                e.detail.printStackTrace();
            }
            catch (RemoteException e) {
                System.out.println("Terrible problem during remote rebin!!");
                e.printStackTrace();
            }
        } else if (debug) {
            System.out.println("2D Data found in cache");
        }
        return result;
    }

    @Override
    public double getXMin() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_xAxis.m_min;
    }

    @Override
    public double getXMax() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_xAxis.m_max;
    }

    @Override
    public double getYMin() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_yAxis.m_min;
    }

    @Override
    public double getYMax() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_yAxis.m_max;
    }

    @Override
    public int getXBins() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_xAxis.m_bins;
    }

    @Override
    public int getYBins() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_yAxis.m_bins;
    }

    @Override
    public int getXAxisType() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_xAxis.m_axisType;
    }

    @Override
    public int getYAxisType() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_yAxis.m_axisType;
    }

    @Override
    public String[] getXAxisLabels() {
        String[] myAxisLabels = this.xAxisLabels;
        if (myAxisLabels == null) {
            myAxisLabels = this.getRemoteXAxisLabels();
        }
        return myAxisLabels;
    }

    @Override
    public String[] getYAxisLabels() {
        String[] myAxisLabels = this.yAxisLabels;
        if (myAxisLabels == null) {
            myAxisLabels = this.getRemoteYAxisLabels();
        }
        return myAxisLabels;
    }

    @Override
    public boolean isRebinnable() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_isRebinnable;
    }

    @Override
    public String getTitle() {
        Remote2DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_title;
    }

    private String[] getRemoteXAxisLabels() {
        String[] myAxisLabels;
        try {
            myAxisLabels = this.m_remote.getRemoteXAxisLabels();
            this.xAxisLabels = myAxisLabels;
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
        return myAxisLabels;
    }

    private String[] getRemoteYAxisLabels() {
        String[] myAxisLabels;
        try {
            myAxisLabels = this.m_remote.getRemoteYAxisLabels();
            this.yAxisLabels = myAxisLabels;
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
        return myAxisLabels;
    }

    protected Remote2DHistogramInfo setInfo() {
        Remote2DHistogramInfo myinfo;
        try {
            this.info = myinfo = this.m_remote.getRemoteInfo();
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
        return myinfo;
    }

    public String toString() {
        try {
            return this.m_remote.getDescription();
        }
        catch (RemoteException e) {
            return super.toString();
        }
    }

    @Override
    public Statistics getStatistics() {
        Statistics stats = this.cacheStats;
        if (stats == null) {
            stats = this.getStats();
        }
        return stats == null ? null : this;
    }

    @Override
    public String[] getStatisticNames() {
        Statistics stats = this.cacheStats;
        if (stats == null) {
            stats = this.getStats();
        }
        return stats.getStatisticNames();
    }

    @Override
    public double getStatistic(String name) {
        Statistics stats = this.cacheStats;
        if (stats == null) {
            stats = this.getStats();
        }
        return stats.getStatistic(name);
    }

    @Override
    public Object getExtendedStatistic(String name) {
        Statistics stats = this.cacheStats;
        if (stats == null) {
            stats = this.getStats();
        }
        if (stats instanceof ExtendedStatistics) {
            return ((ExtendedStatistics)stats).getExtendedStatistic(name);
        }
        return null;
    }

    private Statistics getStats() {
        try {
            Statistics stats;
            this.cacheStats = stats = this.m_remote.getStatistics();
            return stats;
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
    }

    @Override
    public JASHistStyle getStyle() {
        try {
            return this.m_remote.getStyle();
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
    }

    @Override
    public int getNSlices() {
        try {
            return this.m_remote.getNSlices();
        }
        catch (RemoteException x) {
            System.err.println(x);
            return 0;
        }
    }

    @Override
    public SliceParameters getSliceParameters(int n) {
        try {
            return new JASSliceAdaptor(this.m_remote.getSliceParameters(n));
        }
        catch (RemoteException x) {
            System.err.println(x);
            return null;
        }
    }

    @Override
    public Rebinnable1DHistogramData getSlice(int n) {
        try {
            RMIDestination dest = this.m_ed.getRMIDestination();
            return new JASRebinAdaptor(this.m_remote.getSlice(n, dest), dest);
        }
        catch (RemoteException x) {
            System.err.println(x);
            return null;
        }
    }

    @Override
    public boolean canAddRemoveSlices() {
        try {
            return this.m_remote.canAddRemoveSlices();
        }
        catch (RemoteException x) {
            System.err.println(x);
            return false;
        }
    }

    @Override
    public int addSlice(double x, double y, double width, double height, double phi) {
        try {
            return this.m_remote.addSlice(x, y, width, height, phi);
        }
        catch (RemoteException e) {
            System.err.println(e);
            return 0;
        }
    }

    @Override
    public void removeSlice(int n) {
        try {
            this.m_remote.removeSlice(n);
        }
        catch (RemoteException x) {
            System.err.println(x);
        }
    }

    private class AxisCache {
        int m_bins;
        double m_min;
        double m_max;

        private AxisCache() {
        }

        void setCache(int bins, double min, double max) {
            this.m_bins = bins;
            this.m_min = min;
            this.m_max = max;
        }

        boolean equals(int bins, double min, double max) {
            return bins == this.m_bins && min == this.m_min && max == this.m_max;
        }
    }
}

