/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.jds.interfaces.CutInterface;
import jas2.jds.interfaces.CutProperties;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.Job;
import jas2.util.Application;
import jas2.util.JASDialog;
import jas2.util.JASState;
import java.awt.Frame;

abstract class CutDialog
extends JASDialog {
    private String m_name = null;
    private String m_constructor = null;
    private String m_description = null;
    private boolean m_isAdjustment;
    private CutInterface m_peer;
    private CutProperties m_initialProperties;

    CutDialog(boolean isAdjustment) {
        super((Frame)Application.getApplication().getFrame(), "Cut parameters", true, isAdjustment ? 15 : 13);
        if (isAdjustment) {
            this.setApplyLabel("Apply and run");
        }
        this.m_isAdjustment = isAdjustment;
    }

    protected abstract CutProperties getProperties();

    @Override
    protected final void onApply() {
        if (this.setProperties()) {
            Job job = JavaAnalysisStudio.getApp().getJob().getJob();
            job.rewind();
            job.go(0);
        }
    }

    @Override
    protected final void enableApply(JASState state) {
        JASJob job = JavaAnalysisStudio.getApp().getJob();
        state.setEnabled(job != null && job.getJob().isRunnable());
    }

    @Override
    protected final void onOK() {
        if (this.m_isAdjustment) {
            this.setProperties();
        } else {
            this.m_constructor = this.createConstructor(this.m_name);
            if (this.m_constructor == null) {
                return;
            }
            this.m_description = this.createDescription(this.m_name);
            if (this.m_description == null) {
                return;
            }
            super.onOK();
        }
    }

    private boolean setProperties() {
        CutProperties prop = this.getProperties();
        if (prop != null) {
            if (!prop.equals(this.m_initialProperties)) {
                this.m_peer.setProperties(prop);
            }
            super.onOK();
            return true;
        }
        return false;
    }

    void init(CutInterface peer, CutProperties initialProperties) {
        this.m_initialProperties = initialProperties;
        this.m_peer = peer;
    }

    void init(String name) {
        this.m_name = name;
    }

    String getConstructor() {
        return this.m_constructor;
    }

    String getDescription() {
        return this.m_description;
    }

    protected abstract String createConstructor(String var1);

    protected abstract String createDescription(String var1);
}

