/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JASException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class BuiltInCompiler {
    private OutputStream out;
    private String classPath;
    private Class compilerClass;
    private boolean jdk14;

    BuiltInCompiler(PrintStream out) throws JASException {
        this.out = out;
        try {
            this.compilerClass = Class.forName("sun.tools.javac.Main");
            this.jdk14 = false;
        }
        catch (ClassNotFoundException x) {
            try {
                this.compilerClass = Class.forName("org.freehep.util.java.Compiler");
                this.jdk14 = true;
            }
            catch (ClassNotFoundException xx) {
                throw new JASException("No built in compiler found", x);
            }
        }
    }

    void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    boolean compile(String file) throws JASException {
        try {
            if (this.jdk14) {
                Object compiler = this.compilerClass.newInstance();
                Class[] ptypes = new Class[]{String.class, PrintStream.class, String.class};
                Method compile = this.compilerClass.getMethod("compile", ptypes);
                Object[] pargs = new Object[]{file, this.out, this.classPath};
                Boolean rc = (Boolean)compile.invoke(compiler, pargs);
                return rc;
            }
            String[] args = new String[]{"-classpath", this.classPath, file};
            Class[] ptypes = new Class[]{OutputStream.class, String.class};
            Constructor c = this.compilerClass.getConstructor(ptypes);
            Object[] pargs = new Object[]{this.out, "javac"};
            Object compilerObject = c.newInstance(pargs);
            Class[] ptypes2 = new Class[]{args.getClass()};
            Method m = this.compilerClass.getMethod("compile", ptypes2);
            Object[] pargs2 = new Object[]{args};
            Boolean rc = (Boolean)m.invoke(compilerObject, pargs2);
            return rc;
        }
        catch (Throwable t) {
            throw new JASException("Error during compile", t);
        }
    }
}

