/*
 * Decompiled with CFR 0.152.
 */
package jas2.plot.java2;

import jas2.plot.PrintHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintHelper12
extends PrintHelper
implements Printable {
    private int orientation = 0;
    private boolean scaleUp = false;
    private Component target;

    @Override
    public void printTarget(Component target) throws Exception {
        if (debugPrinting) {
            System.out.println("PrintHelper12 printing " + target.getClass().getName());
        }
        this.target = target;
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        boolean pj = printJob.printDialog();
        if (pj) {
            RepaintManager pm = RepaintManager.currentManager(target);
            boolean save = pm.isDoubleBufferingEnabled();
            try {
                pm.setDoubleBufferingEnabled(false);
                this.setPrintingThread(Thread.currentThread());
                printJob.print();
            }
            catch (Exception x) {
                if (debugPrinting) {
                    System.out.println("Exception during printing " + x);
                }
                throw x;
            }
            finally {
                pm.setDoubleBufferingEnabled(save);
                this.setPrintingThread(null);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        boolean useLandscape;
        if (pi >= 1) {
            return 1;
        }
        if (debugPrinting) {
            System.out.println("PrintHelper12 printing page" + pi);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        Dimension size = this.target.getSize();
        double pageWidth = pf.getImageableWidth();
        double pageHeight = pf.getImageableHeight();
        double portraiteRatio = Math.min(pageWidth / (double)size.width, pageHeight / (double)size.height);
        double landscapeRatio = Math.min(pageWidth / (double)size.height, pageHeight / (double)size.width);
        if (debugPrinting) {
            System.out.println("portraiteRatio=" + portraiteRatio + " landscapeRatio=" + landscapeRatio);
        }
        if (!this.scaleUp) {
            portraiteRatio = Math.min(portraiteRatio, 1.0);
            landscapeRatio = Math.min(landscapeRatio, 1.0);
        }
        if (debugPrinting) {
            System.out.println("portraiteRatio=" + portraiteRatio + " landscapeRatio=" + landscapeRatio);
        }
        boolean bl = this.orientation == 0 ? landscapeRatio > portraiteRatio : (useLandscape = this.orientation == 2);
        if (debugPrinting) {
            System.out.println("portraiteRatio=" + portraiteRatio + " landscapeRatio=" + landscapeRatio + " useLandscape=" + useLandscape);
        }
        if (useLandscape) {
            g2.rotate(1.5707963267948966);
            g2.translate(0.0, -pageWidth);
            g2.scale(landscapeRatio, landscapeRatio);
        } else {
            g2.scale(portraiteRatio, portraiteRatio);
        }
        this.target.paint(g2);
        return 0;
    }

    @Override
    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    @Override
    public void setScaleUp(boolean scaleUp) {
        this.scaleUp = scaleUp;
    }
}

