/*
 * Decompiled with CFR 0.152.
 */
package jas2.plot;

import jas2.plot.java1.PrintHelper11;
import java.awt.Component;

public abstract class PrintHelper {
    public static final int ORIENTATION_BEST_FIT = 0;
    public static final int ORIENTATION_PORTRAITE = 1;
    public static final int ORIENTATION_LANDSCAPE = 2;
    private static Thread printingThread;
    protected static final boolean debugPrinting;

    public abstract void printTarget(Component var1) throws Exception;

    public static PrintHelper instance() {
        PrintHelper result;
        try {
            Class<?> c = Class.forName("jas2.plot.java2.PrintHelper12");
            result = (PrintHelper)c.newInstance();
        }
        catch (Throwable x) {
            result = new PrintHelper11();
        }
        if (debugPrinting) {
            System.out.println("PrintHelper created a " + result.getClass().getName());
        }
        return result;
    }

    public abstract void setOrientation(int var1);

    public abstract void setScaleUp(boolean var1);

    public static boolean isPrinting() {
        return Thread.currentThread() == printingThread;
    }

    public void setPrintingThread(Thread thread) {
        if (debugPrinting) {
            System.out.println("Printing thread=" + thread);
        }
        printingThread = thread;
    }

    public Thread printingThread() {
        return printingThread;
    }

    static {
        boolean result;
        try {
            result = System.getProperty("debugPrinting") != null;
        }
        catch (SecurityException x) {
            result = false;
        }
        debugPrinting = result;
    }
}

