/*
 * Decompiled with CFR 0.152.
 */
package jas2.job;

import hepjas.analysis.NamedObject;
import hepjas.analysis.Page;
import hepjas.analysis.Plot;
import hepjas.analysis.peer.PagePeer;
import jas2.hep.PartitionAdapter;
import jas2.hist.DataSource;
import jas2.job.JobFolder;
import jas2.job.PageAccess;
import jas2.job.PlotAccess;
import jas2.util.tree.SimpleNode;
import java.util.Enumeration;

final class JobPage
extends SimpleNode
implements PagePeer,
PageAccess {
    private Page m_page;

    public JobPage(Page page, JobFolder parent) {
        super(parent, page.getName(), "page", 0, null);
        this.m_page = page;
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public void show() {
        this.treeChanged(524288);
    }

    @Override
    public void addNotify(Plot h) {
    }

    @Override
    public void removeNotify(Plot h) {
    }

    @Override
    public void clearNotify() {
    }

    @Override
    public void delete() {
        this.m_page.delete();
    }

    @Override
    public void rename(String newName) throws NamedObject.RenameException {
        this.m_page.rename(newName);
    }

    @Override
    public int getNPlots() {
        return this.m_page.getNPlots();
    }

    @Override
    public PlotAccess getPlot(int index) {
        Enumeration e = this.m_page.plots();
        for (int i = 0; i < index; ++i) {
            e.nextElement();
        }
        return new PagePlotAccess(e.nextElement());
    }

    private class PagePlotAccess
    implements PlotAccess {
        private Plot plot;
        private Page.ConstrainedPlot constrainedPlot;

        PagePlotAccess(Object o) {
            if (o instanceof Page.ConstrainedPlot) {
                this.constrainedPlot = (Page.ConstrainedPlot)o;
                this.plot = this.constrainedPlot.getPlot();
            } else {
                this.plot = (Plot)o;
            }
        }

        @Override
        public void delete() {
            this.plot.delete();
        }

        @Override
        public void rename(String newName) throws NamedObject.RenameException {
            this.plot.rename(newName);
        }

        @Override
        public int getNDataSources() {
            return this.plot.getNHistograms();
        }

        @Override
        public DataSource getData(int index) {
            return PartitionAdapter.create(this.plot.getHistogram(index));
        }

        @Override
        public boolean isConstrained() {
            return this.constrainedPlot != null;
        }

        @Override
        public double getX() {
            return this.constrainedPlot.getX();
        }

        @Override
        public double getY() {
            return this.constrainedPlot.getY();
        }

        @Override
        public double getWidth() {
            return this.constrainedPlot.getWidth();
        }

        @Override
        public double getHeight() {
            return this.constrainedPlot.getHeight();
        }
    }
}

