/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.BinnedDataAxisAttributesNodeTraverser;
import jas2.hist.Bins2DNodeTraverser;
import jas2.hist.HasStatistics;
import jas2.hist.Rebinnable2DHistogramData;
import jas2.hist.Statistics;
import jas2.util.xml.XMLNodeTraverser;

class XML2DHistDataSource
implements Rebinnable2DHistogramData,
HasStatistics {
    private BinnedDataAxisAttributesNodeTraverser xba;
    private BinnedDataAxisAttributesNodeTraverser yba;
    private Bins2DNodeTraverser b2d;
    private Statistics stats;

    XML2DHistDataSource(Bins2DNodeTraverser b2d, BinnedDataAxisAttributesNodeTraverser xba, BinnedDataAxisAttributesNodeTraverser yba, Statistics stats) throws XMLNodeTraverser.BadXMLException {
        this.xba = xba;
        this.yba = yba;
        this.b2d = b2d;
        this.stats = stats;
    }

    @Override
    public double[][][] rebin(int xbins, double xmin, double xmax, int ybins, double ymin, double ymax, boolean wantErrors, boolean hurry, boolean xxx) {
        return this.b2d.getData();
    }

    @Override
    public double getXMin() {
        return this.xba.getMin();
    }

    @Override
    public double getXMax() {
        return this.xba.getMax();
    }

    @Override
    public double getYMin() {
        return this.yba.getMin();
    }

    @Override
    public double getYMax() {
        return this.yba.getMax();
    }

    @Override
    public int getXBins() {
        return this.b2d.getData()[0].length;
    }

    @Override
    public int getYBins() {
        return this.b2d.getData()[0][0].length;
    }

    @Override
    public boolean isRebinnable() {
        return false;
    }

    @Override
    public int getXAxisType() {
        return this.xba.getType();
    }

    @Override
    public int getYAxisType() {
        return this.yba.getType();
    }

    @Override
    public String[] getXAxisLabels() {
        return null;
    }

    @Override
    public String[] getYAxisLabels() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.b2d.getTitle();
    }

    @Override
    public Statistics getStatistics() {
        return this.stats;
    }
}

