/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DefaultFitterFactory;
import jas2.hist.Fitter;
import jas2.hist.FitterFactory;
import jas2.hist.FitterFactoryError;
import jas2.util.NestedRuntimeException;
import java.util.Enumeration;
import java.util.Vector;

public class FitterRegistry {
    private Vector m_fitters = new Vector();
    private static FitterRegistry theFitterRegistry = new FitterRegistry();
    private FitterFactory defaultFitterFactory;

    private FitterRegistry() {
    }

    public static FitterRegistry instance() {
        return theFitterRegistry;
    }

    public void registerFitter(Class c, String name) {
        this.registerFitter(this.createFitterFactory(c, name));
    }

    public FitterFactory createFitterFactory(Class c, String name) {
        try {
            return new DefaultFitterFactory(c, name);
        }
        catch (FitterFactoryError e) {
            throw new NestedRuntimeException(e);
        }
    }

    public void registerFitter(FitterFactory f) {
        this.m_fitters.addElement(f);
        if (this.defaultFitterFactory == null) {
            this.defaultFitterFactory = f;
        }
    }

    public void removeFitterFactory(FitterFactory f) {
        this.m_fitters.removeElement(f);
    }

    public void removeAllFitters() {
        this.m_fitters.removeAllElements();
    }

    public Enumeration elements() {
        return this.m_fitters.elements();
    }

    public int size() {
        return this.m_fitters.size();
    }

    public FitterFactory getDefaultFitterFactory() {
        return this.defaultFitterFactory;
    }

    public void setDefaultFitterFactory(FitterFactory f) {
        this.defaultFitterFactory = f;
    }

    public Fitter getDefaultFitter() {
        return this.defaultFitterFactory == null ? null : this.defaultFitterFactory.createFitter();
    }

    public void setContents(Vector v) {
        this.m_fitters = v;
    }
}

