/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.BinnedDataManager;
import jas2.hist.DataManagerException;
import jas2.hist.DataSource;
import jas2.hist.JASHist;
import jas2.hist.JASHistData;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.StatisticsBlock;
import jas2.hist.XYDataSource;
import jas2.plot.DataArea;
import jas2.plot.DateAxis;
import jas2.plot.DoubleAxis;
import jas2.plot.Legend;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TimeZone;

final class DateDataManager
extends BinnedDataManager {
    private DateAxis xAxis = new DateAxis();

    DateDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats, int bins) {
        super(plot, da, l, stats, bins);
        DoubleAxis yAxis = new DoubleAxis();
        yAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, false, yAxis);
        new BinnedDataManager.DateAxisListener(this.xm);
        this.xm.setBins(bins);
    }

    @Override
    JASHistData add(DataSource data) {
        JASHistData jhd;
        TimeZone tz;
        DataSource d;
        if (data instanceof Rebinnable1DHistogramData) {
            d = (Rebinnable1DHistogramData)data;
            if (d.getAxisType() != 3) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        } else {
            d = (XYDataSource)data;
            if (d.getAxisType() != 3) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        }
        if ((tz = (jhd = super.add(data)).getStyle().getTimeZone()) != null) {
            this.xAxis.setTimeZone(tz);
        }
        return jhd;
    }

    @Override
    void styleUpdate(JASHistData data) {
        TimeZone tz = data.getStyle().getTimeZone();
        if (tz != null) {
            this.xAxis.setTimeZone(tz);
        }
        super.styleUpdate(data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        new BinnedDataManager.DateAxisListener(this.xm);
    }

    @Override
    protected void calcMinMaxBins(double x1, double x2) {
        long iLow = (long)(x1 * 1000.0);
        long iHigh = (long)(x2 * 1000.0);
        long oldXMin = this.xAxis.getAxisMin();
        long oldXMax = this.xAxis.getAxisMax();
        if (iLow != oldXMin || iHigh != oldXMax) {
            this.xAxis.setMin(iLow);
            this.xAxis.setMax(iHigh);
            this.xAxis.getAxis().invalidate();
        }
    }
}

