/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DataSource;
import jas2.hist.HistogramUpdate;
import jas2.hist.JASHist;
import jas2.hist.JASHistAxis;
import jas2.hist.JASHistData;
import jas2.hist.ManagedAxis;
import jas2.plot.Axis;
import jas2.plot.DataArea;
import jas2.plot.DoubleAxis;
import jas2.plot.EditableLabel;
import java.awt.Component;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.JPopupMenu;

abstract class DataManager {
    protected static final Enumeration nullEnumeration = new NullEnumeration();
    protected ManagedAxis xm;
    protected ManagedAxis[] ym = new ManagedAxis[2];
    protected final JASHist plot;
    protected final DataArea da;

    DataManager(JASHist plot, DataArea da) {
        this.plot = plot;
        this.da = da;
        da.setSpecialComponent(null);
        this.xm = (ManagedAxis)da.getXAxis();
        this.ym[0] = (ManagedAxis)da.getYAxis();
    }

    JASHist getPlot() {
        return this.plot;
    }

    abstract void init();

    abstract JASHistData add(DataSource var1);

    abstract void remove(JASHistData var1);

    abstract void requestShow(JASHistData var1);

    abstract void requestHide(JASHistData var1);

    abstract void invalidate();

    abstract boolean isRealized();

    abstract void setRealized(boolean var1);

    abstract void XAxisUpdated();

    abstract void computeYAxisRange();

    abstract void computeXAxisRange();

    abstract void update(HistogramUpdate var1, JASHistData var2);

    abstract int numberOfDataSources();

    abstract Enumeration getDataSources();

    abstract void destroy();

    abstract void modifyPopupMenu(JPopupMenu var1, Component var2);

    protected abstract void showLegend();

    abstract void styleUpdate(JASHistData var1);

    abstract void axisChanged(JASHistData var1);

    public EditableLabel getLabel(Axis m) {
        return this.da.getLabel(m);
    }

    public void setLabel(Axis m, EditableLabel l) {
        this.da.setLabel(m, l);
    }

    JASHistAxis getXAxis() {
        return this.xm;
    }

    JASHistAxis[] getYAxes() {
        return this.ym;
    }

    JASHistAxis getYAxis(int index) {
        if (index >= this.ym.length) {
            throw new IllegalArgumentException("Y axis index out of range");
        }
        if (this.ym[index] == null) {
            this.createYAxis(index);
        }
        return this.ym[index];
    }

    protected void createYAxis(int index) {
        this.ym[index] = new ManagedAxis(this, 1, true);
        DoubleAxis a = (DoubleAxis)this.ym[index].getType();
        a.setUseSuggestedRange(true);
        this.ym[index].setOnLeftSide(false);
        this.da.add(this.ym[index], (Object)"yr");
        this.da.revalidate();
    }

    protected void destroyYAxis(int index) {
        if (this.ym[index] != null) {
            this.da.remove(this.ym[index]);
        }
        this.da.revalidate();
    }

    private static final class NullEnumeration
    implements Enumeration {
        private NullEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

