/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.AxisNodeTraverser;
import jas2.hist.ComponentNodeTraverser;
import jas2.hist.Data1DTraverser;
import jas2.hist.Data2DTraverser;
import jas2.hist.DataSource;
import jas2.hist.FitFailed;
import jas2.hist.Fittable1DFunction;
import jas2.hist.Fitter;
import jas2.hist.FitterRegistry;
import jas2.hist.Function1DTraverser;
import jas2.hist.JASHist;
import jas2.hist.JASHistAxis;
import jas2.hist.JASHistData;
import jas2.hist.JASHistStyle;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.XYDataSource;
import jas2.hist.normalization.Normalizer;
import jas2.plot.DataArea;
import jas2.util.xml.XMLNodeTraverser;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DataAreaNodeTraverser
extends ComponentNodeTraverser {
    private Hashtable map = new Hashtable();
    private DataArea da;
    private JASHist plot;
    private static AxisNodeTraverser at = new AxisNodeTraverser();

    DataAreaNodeTraverser() {
    }

    void traverse(Node node, DataArea da, JASHist plot) throws XMLNodeTraverser.BadXMLException {
        this.da = da;
        this.plot = plot;
        super.traverse(node, da);
    }

    @Override
    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("axis")) {
            JASHistAxis theAxis;
            NamedNodeMap nnm = node.getAttributes();
            String position = nnm.getNamedItem("location").getNodeValue();
            if (position.equals("x0")) {
                theAxis = this.plot.getXAxis();
            } else if (position.equals("y0")) {
                theAxis = this.plot.getYAxis();
            } else if (position.equals("y1")) {
                theAxis = this.plot.getYAxis(1);
            } else {
                throw new XMLNodeTraverser.BadXMLException("Illegal axis position" + position);
            }
            at.traverse(node, theAxis);
        } else if (name.equals("data1d")) {
            Normalizer norm;
            Data1DTraverser d1d = new Data1DTraverser(node);
            DataSource ds = d1d.getDataSource();
            if (ds == null) {
                return;
            }
            String refName = d1d.getRefName();
            if (refName != null) {
                this.map.put(refName, ds);
            }
            JASHistData data = this.plot.addData(ds);
            data.setYAxis(d1d.getYAxis());
            JASHistStyle style = d1d.getStyle();
            if (style != null) {
                data.setStyle(style);
            }
            if ((norm = d1d.getNormalizer(ds, this.map)) != null) {
                data.setNormalization(norm);
            }
            data.show(true);
        } else if (name.equals("data2d")) {
            Data2DTraverser d2d = new Data2DTraverser(node);
            DataSource ds = d2d.getDataSource();
            if (ds == null) {
                return;
            }
            String refName = d2d.getRefName();
            if (refName != null) {
                this.map.put(refName, ds);
            }
            JASHistData data = this.plot.addData(ds);
            JASHistStyle style = d2d.getStyle();
            if (style != null) {
                data.setStyle(style);
            }
            data.show(true);
        } else if (name.equals("function1d")) {
            Function1DTraverser f1d = new Function1DTraverser(node, this.plot);
            DataSource ds = f1d.getDataSource();
            if (ds != null) {
                Object data;
                String fitRef;
                String refName = f1d.getRefName();
                if (refName != null) {
                    this.map.put(refName, ds);
                }
                if ((fitRef = f1d.getFitRef()) != null) {
                    data = (DataSource)this.map.get(fitRef);
                    if (data == null) {
                        throw new XMLNodeTraverser.BadXMLException("Cannot resolve reference " + fitRef);
                    }
                    if (!(data instanceof Rebinnable1DHistogramData)) {
                        throw new XMLNodeTraverser.BadXMLException("Cannot fit 2D data");
                    }
                    if (!(ds instanceof Fittable1DFunction)) {
                        throw new XMLNodeTraverser.BadXMLException("Function is not fittable");
                    }
                    Fitter fitter = FitterRegistry.instance().getDefaultFitter();
                    fitter.setData((XYDataSource)data);
                    fitter.setFunction((Fittable1DFunction)ds);
                    try {
                        fitter.fit();
                    }
                    catch (FitFailed x) {
                        x.printStackTrace();
                    }
                }
                data = this.plot.addData(ds);
                JASHistStyle style = f1d.getStyle();
                if (style != null) {
                    ((JASHistData)data).setStyle(style);
                }
                ((JASHistData)data).show(f1d.isVisible());
            }
        } else {
            super.handleElement(node, name);
        }
    }
}

