/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.util.xml.XMLNodeTraverser;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class Bins2DNodeTraverser
extends XMLNodeTraverser {
    private String title;
    private double[][][] data;
    private int xSize;
    private int ySize;

    Bins2DNodeTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("title")) {
            this.title = value;
        } else if (name.equals("xSize")) {
            this.xSize = this.toInt(value);
        } else if (name.equals("ySize")) {
            this.ySize = this.toInt(value);
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    @Override
    protected void handleTextNode(Text node, String name) throws XMLNodeTraverser.BadXMLException {
        StringTokenizer lineTokens = new StringTokenizer(node.getData(), "\n\r");
        int lines = lineTokens.countTokens();
        if (lines < this.xSize * this.ySize || lines > this.xSize * this.ySize + 1) {
            throw new XMLNodeTraverser.BadXMLException("Inconsistent data length for bins2d (lines=" + lines + ")");
        }
        int x = 0;
        int y = 0;
        for (int l = 0; l < this.xSize * this.ySize; ++l) {
            StringTokenizer valueTokens = new StringTokenizer(lineTokens.nextToken().trim(), ",");
            int n = valueTokens.countTokens();
            if (this.data == null) {
                this.data = new double[n][this.xSize][this.ySize];
            } else if (n != this.data.length) {
                throw new XMLNodeTraverser.BadXMLException("Inconsistent number of entries in bins2d data at line " + l);
            }
            for (int i = 0; i < n; ++i) {
                this.data[i][x][y] = this.toDouble(valueTokens.nextToken());
            }
            if (++y != this.ySize) continue;
            y = 0;
            ++x;
        }
    }

    String getTitle() {
        return this.title;
    }

    double[][][] getData() {
        return this.data;
    }
}

