/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;

public class Statistics
implements Serializable {
    private final Vector m_stats;
    private final Vector m_values;
    static final long serialVersionUID = -9061569144762379833L;

    public Statistics(int nEntries) {
        this.m_stats = new Vector(nEntries);
        this.m_values = new Vector(nEntries);
    }

    public final void setStatistic(String name, double value) {
        this.setStatistic(name, new Double(value));
    }

    public final void setStatistic(String name, Object value) {
        this.m_stats.addElement(name);
        this.m_values.addElement(value);
    }

    public final Enumeration elements() {
        return this.m_stats.elements();
    }

    public final String[] getStatisticNames() {
        Object[] result = new String[this.m_stats.size()];
        this.m_stats.copyInto(result);
        return result;
    }

    public final Object getStatisticObject(String name) {
        int i = this.m_stats.indexOf(name);
        if (i < 0) {
            throw new IllegalArgumentException("Statistic " + name + " not found.");
        }
        return this.m_values.elementAt(i);
    }

    public final double getStatistic(String name) {
        int i = this.m_stats.indexOf(name);
        if (i < 0) {
            throw new IllegalArgumentException("Statistic " + name + " not found.");
        }
        return (Double)this.m_values.elementAt(i);
    }

    public final double getStatistic(String name, double defaultValue) {
        int i = this.m_stats.indexOf(name);
        if (i < 0) {
            return defaultValue;
        }
        return (Double)this.m_values.elementAt(i);
    }

    public final void clear() {
        this.m_stats.removeAllElements();
    }

    public String toString() {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(1);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.m_stats.size()) {
            String name = (String)this.m_stats.elementAt(i);
            Object value = this.m_values.elementAt(i);
            if (value instanceof Double) {
                double dvalue = (Double)this.m_values.elementAt(i);
                result.append(name + "=" + format.format(dvalue));
            } else {
                result.append(name + "=" + value.toString());
            }
            if (++i == this.m_stats.size()) break;
            result.append(" , ");
        }
        return result.toString();
    }
}

