/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.AbstractTwoDFillable;
import hepjas.analysis.partition.PartitionEnumeration;
import hepjas.analysis.partition.PartitionVector;
import hepjas.analysis.partition.TwoDFillable;
import hepjas.analysis.partition.TwoDStorer;

public class SimpleTwoDStorer
extends AbstractTwoDFillable
implements TwoDStorer {
    private PartitionVector m_simple = new PartitionVector(2);
    private PartitionVector m_weighted = new PartitionVector(3);
    private double[] m_currentSimple;
    private double[] m_currentWeighted;
    private int m_countSimple;
    private int m_countWeighted;
    private int m_simpleEntriesFilled;
    private int m_weightedEntriesFilled;
    static final long serialVersionUID = -6804277295912816740L;

    public SimpleTwoDStorer() {
        this.clear();
    }

    @Override
    public void fill(double x, double y) {
        try {
            this.m_currentSimple[this.m_countSimple++] = x;
            this.m_currentSimple[this.m_countSimple++] = y;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.m_currentSimple = this.m_simple.newArray();
            this.m_countSimple = 0;
            this.m_currentSimple[this.m_countSimple++] = x;
            this.m_currentSimple[this.m_countSimple++] = y;
        }
        ++this.m_simpleEntriesFilled;
    }

    @Override
    public void fillW(double x, double y, double weight) {
        try {
            this.m_currentWeighted[this.m_countWeighted++] = x;
            this.m_currentWeighted[this.m_countWeighted++] = y;
            this.m_currentWeighted[this.m_countWeighted++] = weight;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.m_currentWeighted = this.m_weighted.newArray();
            this.m_countWeighted = 0;
            this.m_currentWeighted[this.m_countWeighted++] = x;
            this.m_currentWeighted[this.m_countWeighted++] = y;
            this.m_currentWeighted[this.m_countWeighted++] = weight;
        }
        ++this.m_weightedEntriesFilled;
    }

    @Override
    public void fillData(TwoDFillable fill) {
        PartitionEnumeration e = this.m_simple.elements();
        e.setEndPoint(this.m_simpleEntriesFilled);
        while (e.hasMoreElements()) {
            fill.fill(e.nextValue(), e.nextValue());
        }
        e = this.m_weighted.elements();
        e.setEndPoint(this.m_weightedEntriesFilled);
        while (e.hasMoreElements()) {
            fill.fillW(e.nextValue(), e.nextValue(), e.nextValue());
        }
    }

    @Override
    public void clear() {
        this.m_simple.clear();
        this.m_weighted.clear();
        this.m_currentSimple = this.m_simple.newArray();
        this.m_currentWeighted = this.m_weighted.newArray();
        this.m_countSimple = 0;
        this.m_countWeighted = 0;
        this.m_simpleEntriesFilled = 0;
        this.m_weightedEntriesFilled = 0;
    }
}

