/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.Partition;
import hepjas.analysis.partition.BinAdapter;
import hepjas.analysis.partition.BinType;
import hepjas.analysis.partition.FillableTee;
import hepjas.analysis.partition.OneDDelegatingPartition;
import hepjas.analysis.partition.OneDStatisticsProvider;
import hepjas.analysis.partition.SimpleBinFinder;
import hepjas.analysis.partition.SimpleBinner;
import hepjas.analysis.partition.SimpleBinnerDataSourceAdapter;
import hepjas.analysis.partition.SimpleStorer;
import hepjas.analysis.partition.Statistics;

public class SimplePartition
extends OneDDelegatingPartition {
    protected double m_min;
    protected double m_max;
    protected boolean m_autoRange;
    protected int m_defaultBins;
    private BinType m_type;
    private SimpleStorer m_storer;
    private OneDStatisticsProvider m_stats;
    static final long serialVersionUID = 1464862023276245054L;

    public SimplePartition() {
        this(40);
    }

    public SimplePartition(int bins) {
        this(new SimpleBinner(bins));
    }

    public SimplePartition(BinType type) {
        this.m_type = type;
        this.m_autoRange = true;
        this.m_defaultBins = type.getNumberOfBins();
        this.m_storer = new SimpleStorer();
        this.m_stats = new OneDStatisticsProvider(this);
        this.setFillable(new FillableTee(this.m_storer, this.m_stats));
        this.setStatisticsProvider(this.m_stats);
    }

    public SimplePartition(double min, double max) {
        this(min, max, 40);
    }

    public SimplePartition(double min, double max, int bins) {
        this(min, max, new SimpleBinner(bins));
    }

    public SimplePartition(double min, double max, BinType type) {
        if (max <= min) {
            throw new IllegalArgumentException("max <= min");
        }
        this.m_type = type;
        this.m_autoRange = false;
        this.m_min = min;
        this.m_max = max;
        this.m_defaultBins = type.getNumberOfBins();
        this.m_storer = new SimpleStorer();
        this.setFillable(this.m_storer);
    }

    @Override
    public void setBinning(int bins, double min, double max) {
        SimpleBinFinder finder = new SimpleBinFinder(bins, min, max, false);
        this.m_type.setNumberOfBins(bins);
        this.m_type.clear();
        BinAdapter fill = new BinAdapter(finder, this.m_type);
        this.m_storer.fillData(fill);
        this.setDataSource(new SimpleBinnerDataSourceAdapter(finder, this.m_type));
    }

    @Override
    public int getNumberOfBins() {
        return this.m_defaultBins;
    }

    @Override
    public double getMin() {
        this.clearRangeChanged();
        if (this.m_autoRange) {
            return this.m_stats.getMin();
        }
        return this.m_min;
    }

    @Override
    public double getMax() {
        this.clearRangeChanged();
        if (this.m_autoRange) {
            return this.m_stats.getMax();
        }
        return this.m_max;
    }

    @Override
    public Statistics getStatistics() {
        if (this.m_autoRange) {
            return this.m_stats.getStatistics();
        }
        OneDStatisticsProvider stats = new OneDStatisticsProvider();
        this.m_storer.fillData(stats);
        return stats.getStatistics();
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    @Override
    public int getAxisType() {
        return 1;
    }

    @Override
    public Partition makeCopy() {
        if (this.m_autoRange) {
            return new SimplePartition(this.m_defaultBins);
        }
        return new SimplePartition(this.m_min, this.m_max, this.m_defaultBins);
    }
}

