/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.NoSuchBinException;
import hepjas.analysis.Partition;
import hepjas.analysis.partition.PartitionFillException;
import hepjas.analysis.partition.PartitionNotification;
import hepjas.analysis.partition.RangeChangeListener;
import hepjas.analysis.partition.TwoDDataSource;
import hepjas.analysis.partition.UnsupportedPartitionMethodException;
import java.io.Serializable;
import java.util.Date;

public abstract class Abstract2DPartition
extends Partition
implements TwoDDataSource {
    static final long serialVersionUID = -4211256413767101846L;
    protected transient boolean m_dataChanged = false;
    protected transient boolean m_xAxisChanged = false;
    protected transient boolean m_yAxisChanged = false;
    protected transient boolean m_dataNotificationSent = false;
    protected transient boolean m_xAxisNotificationSent = false;
    protected transient boolean m_yAxisNotificationSent = false;
    protected transient boolean m_dataFinalChangedNotificationSent = false;
    protected transient boolean m_rangeFinalChangedNotificationSent = false;
    private static final PartitionNotification hx = new PartitionNotification(6, false);
    private static final PartitionNotification hy = new PartitionNotification(6, false);
    private static final PartitionNotification hxy = new PartitionNotification(6, false);
    private static final PartitionNotification hd = new PartitionNotification(2, false);
    private static final PartitionNotification hr = new PartitionNotification(16, false);

    @Override
    public void fillW(double x, double v) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(int x, double v) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(String x, double v) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(Date x, double v) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fill(double x) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fill(int x) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fill(String x) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fill(Date x) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fill(double x, double y) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(double x, double y, double weight) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fill(Date x, double y) {
        throw new PartitionFillException(this);
    }

    @Override
    public void fillW(Date x, double y, double weight) {
        throw new PartitionFillException(this);
    }

    public double getBin(int binX, int binY) throws NoSuchBinException {
        try {
            return 0.0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchBinException();
        }
    }

    @Override
    public boolean isRebinnable() {
        return false;
    }

    @Override
    public void setXBinning(int bins, double min, double max) {
        throw new UnsupportedPartitionMethodException();
    }

    @Override
    public void setYBinning(int bins, double min, double max) {
        throw new UnsupportedPartitionMethodException();
    }

    @Override
    public int getXAxisType() {
        return 1;
    }

    @Override
    public int getYAxisType() {
        return 1;
    }

    @Override
    public boolean hasAsymmetricErrorBars() {
        return false;
    }

    @Override
    public boolean hasSimpleQuadraticErrorBars() {
        return false;
    }

    @Override
    public String[] getXAxisLabels() {
        throw new UnsupportedPartitionMethodException();
    }

    @Override
    public String[] getYAxisLabels() {
        throw new UnsupportedPartitionMethodException();
    }

    public abstract int getNumberOfXBins();

    public abstract int getNumberOfYBins();

    protected RangeChangeListener getRangeChangeListener(int axis) {
        return new TwoDRangeChangeListener(axis);
    }

    protected void setBothRangesChanged() {
        this.m_xAxisChanged = true;
        this.m_yAxisChanged = true;
        if (!this.m_xAxisNotificationSent || !this.m_yAxisNotificationSent) {
            this.notifyObservers(hxy);
            this.m_yAxisNotificationSent = true;
            this.m_xAxisNotificationSent = true;
        }
    }

    protected void setXRangeChanged() {
        this.m_xAxisChanged = true;
        if (!this.m_xAxisNotificationSent) {
            this.notifyObservers(hx);
            this.m_xAxisNotificationSent = true;
        }
    }

    protected void setYRangeChanged() {
        this.m_yAxisChanged = true;
        if (!this.m_yAxisNotificationSent) {
            this.notifyObservers(hy);
            this.m_yAxisNotificationSent = true;
        }
    }

    public void setDataChanged() {
        this.m_dataChanged = false;
        if (!this.m_dataNotificationSent) {
            this.notifyObservers(hd);
            this.m_dataNotificationSent = true;
        }
    }

    protected void clearDataChanged() {
        this.m_dataChanged = false;
        this.m_dataNotificationSent = false;
        this.m_dataFinalChangedNotificationSent = false;
    }

    public void clearChanges() {
        this.m_dataChanged = false;
        this.m_yAxisChanged = false;
        this.m_xAxisChanged = false;
        this.m_dataNotificationSent = false;
        this.m_yAxisNotificationSent = false;
        this.m_xAxisNotificationSent = false;
    }

    @Override
    public void clear() {
        this.setDataAndRangeChangedNow();
    }

    protected final void setDataAndRangeChangedNow() {
        this.m_dataChanged = true;
        this.m_xAxisChanged = true;
        this.m_yAxisChanged = true;
        this.m_dataFinalChangedNotificationSent = false;
        this.m_rangeFinalChangedNotificationSent = false;
        this.done();
    }

    @Override
    public void done() {
        int flag = 0;
        if (this.m_dataChanged && !this.m_dataFinalChangedNotificationSent) {
            flag |= 2;
        }
        if ((this.m_xAxisChanged || this.m_yAxisChanged) && !this.m_rangeFinalChangedNotificationSent) {
            flag |= 4;
        }
        if (flag != 0) {
            PartitionNotification h = new PartitionNotification(flag, true);
            if (this.m_xAxisChanged) {
                h.setAxis(0);
            }
            if (this.m_yAxisChanged) {
                h.setAxis(1);
            }
            this.notifyObservers(h);
        }
    }

    @Override
    public final void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    static {
        hx.setAxis(0);
        hy.setAxis(1);
        hxy.setAxis(0);
        hxy.setAxis(1);
    }

    private class TwoDRangeChangeListener
    implements RangeChangeListener,
    Serializable {
        private int axis;
        static final long serialVersionUID = 4238834432795315582L;

        TwoDRangeChangeListener(int axis) {
            this.axis = axis;
        }

        @Override
        public void rangeChanged(double min, double max) {
            if (this.axis == 0) {
                Abstract2DPartition.this.setXRangeChanged();
            } else {
                Abstract2DPartition.this.setYRangeChanged();
            }
        }
    }
}

