/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis;

import hepjas.analysis.Folder;
import hepjas.analysis.FolderSet;
import hepjas.analysis.Histogram;
import hepjas.analysis.HistogramFolderSet;
import hepjas.analysis.HistogramStyle;
import hepjas.analysis.Job;
import hepjas.analysis.JobFolder;
import hepjas.analysis.Partition;
import hepjas.analysis.Style;
import hepjas.analysis.StyleContainer;
import hepjas.analysis.partition.DefaultPartitionFactory;
import java.util.Enumeration;

public class HistogramFolder
extends Folder {
    static final long serialVersionUID = -4180570083776479278L;
    static final Class klass = HistogramFolderSet.class;
    private boolean clearOnRewind = true;
    private HistogramStyle style;
    private Partition defaultPartition;
    private static Partition defaultDefaultPartition = new DefaultPartitionFactory();

    public HistogramFolder(String name) {
        this(name, HistogramFolder.getDefaultFolder());
    }

    public HistogramFolder(String name, HistogramFolder parent) {
        super(parent, name);
    }

    HistogramFolder(String name, Folder parent) {
        super(parent, name);
    }

    public static HistogramFolder getDefaultFolder() {
        FolderSet root = Job.currentJob().getFolderSet(klass);
        return (HistogramFolder)root.getCurrentFolder();
    }

    public static void setDefaultFolder(HistogramFolder f) {
        FolderSet root = Job.currentJob().getFolderSet(klass);
        root.setCurrentFolder(f);
    }

    public static void setDefaultFolder(String path) {
        FolderSet root = Job.currentJob().getFolderSet(klass);
        root.setCurrentFolder(path);
    }

    public void setStyle(HistogramStyle style) {
        this.style = style;
        style.setContainer(this.getStyleContainer(this.getFolder()));
    }

    StyleContainer getStyleContainer() {
        return this.getStyleContainer(this);
    }

    private StyleContainer getStyleContainer(final Folder start) {
        return new StyleContainer(){

            @Override
            public Style getParent() {
                Folder parent = start;
                while (parent instanceof HistogramFolder) {
                    HistogramStyle style = ((HistogramFolder)parent).style;
                    if (style != null) {
                        return style;
                    }
                    parent = parent.getFolder();
                }
                return null;
            }
        };
    }

    public void setDefaultPartition(Partition partition) {
        this.defaultPartition = partition;
    }

    public Partition getDefaultPartition() {
        if (this.defaultPartition != null) {
            return this.defaultPartition;
        }
        Folder parent = this.getFolder();
        if (parent instanceof HistogramFolder) {
            return ((HistogramFolder)parent).getDefaultPartition();
        }
        return defaultDefaultPartition;
    }

    @Override
    protected Folder getDefaultParent() {
        return HistogramFolder.getDefaultFolder();
    }

    public void clear() {
        Enumeration e = this.getChildren();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Histogram) {
                ((Histogram)o).clear();
                continue;
            }
            if (!(o instanceof HistogramFolder)) continue;
            ((HistogramFolder)o).clear();
        }
    }

    void rewind() {
        if (this.clearOnRewind) {
            Enumeration e = this.getChildren();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof Histogram) {
                    ((Histogram)o).rewind();
                    continue;
                }
                if (!(o instanceof HistogramFolder)) continue;
                ((HistogramFolder)o).rewind();
            }
        }
    }

    public void setClearOnRewind(boolean value) {
        this.clearOnRewind = value;
    }

    public boolean isClearOnRewind() {
        return this.clearOnRewind;
    }

    public boolean canSetClearOnRewind() {
        Folder f = this.getFolder();
        if (f instanceof HistogramFolder) {
            HistogramFolder parent = (HistogramFolder)f;
            if (!parent.clearOnRewind) {
                return false;
            }
            return parent.canSetClearOnRewind();
        }
        if (f instanceof JobFolder) {
            return ((JobFolder)f).canSetClearOnRewind(this);
        }
        return false;
    }

    void done() {
        Enumeration e = this.getChildren();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof Histogram) {
                ((Histogram)o).getPartition().done();
                continue;
            }
            if (!(o instanceof HistogramFolder)) continue;
            ((HistogramFolder)o).done();
        }
    }
}

