/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.reps;

import hep.rootio.NameMangler;
import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.Leaf;
import hep.rootio.implementation.RootRandomAccessFile;
import hep.rootio.implementation.SpecificRootObject;
import hep.rootio.reps.TBasket;
import hep.rootio.reps.TObjArray;
import java.io.IOException;
import java.util.Hashtable;

public class TBranch
extends SpecificRootObject {
    private RootRandomAccessFile raf;
    private Hashtable map;
    private Hashtable mangledMap;
    private static final NameMangler nameMangler = NameMangler.instance();

    @Override
    public void readMembers(RootInput in, int v) throws IOException {
        super.readMembers(in, v);
        this.raf = in.getRAF();
        TObjArray leaves = (TObjArray)this.get("fLeaves");
        if (leaves != null) {
            for (int i = 0; i < leaves.size(); ++i) {
                Leaf leaf = (Leaf)((Object)leaves.elementAt(i));
                leaf.setBranch(this);
            }
        }
    }

    Object getValue(Leaf leaf, int index) throws IOException {
        int i = this.findBasketForIndex(index);
        TBasket basket = this.getBasket(i);
        int[] offsets = (int[])this.get("fBasketEntry");
        return basket.getEntry(index, offsets[i], leaf);
    }

    public Object getEntry(int index) throws IOException {
        TObjArray leaves = (TObjArray)this.get("fLeaves");
        Leaf leaf = (Leaf)((Object)leaves.elementAt(0));
        return this.getValue(leaf, index);
    }

    private int findBasketForIndex(int index) {
        int nEntries = ((Number)this.get("fEntryNumber")).intValue();
        if (index < 0 || index >= nEntries) {
            throw new ArrayIndexOutOfBoundsException("index=" + index);
        }
        int[] entries = (int[])this.get("fBasketEntry");
        int n = (Integer)this.get("fWriteBasket");
        for (int i = 0; i < n; ++i) {
            if (index < entries[i] || index >= entries[i + 1]) continue;
            return i;
        }
        return n;
    }

    private TBasket getBasket(int index) throws IOException {
        TObjArray baskets = (TObjArray)this.get("fBaskets");
        TBasket basket = (TBasket)baskets.elementAt(index);
        if (basket != null) {
            return basket;
        }
        int[] seek = (int[])this.get("fBasketSeek");
        this.raf.seek(seek[index]);
        basket = (TBasket)this.raf.readObject("TBasket");
        int len = (Integer)this.get("fEntryOffsetLen");
        if (len > 0) {
            basket.readEntryOffsets(len);
        }
        baskets.setElementAt(index, basket);
        return basket;
    }

    public int getNEntries() {
        return ((Number)this.get("fEntries")).intValue();
    }

    public RootObjectRepresentation getBranchForName(String name) {
        if (this.map == null) {
            this.buildMap();
        }
        return (RootObjectRepresentation)this.map.get(name);
    }

    public RootObjectRepresentation getBranchForMangledName(String name) {
        if (this.map == null) {
            this.buildMap();
        }
        return (RootObjectRepresentation)this.mangledMap.get(name);
    }

    private void buildMap() {
        this.map = new Hashtable();
        this.mangledMap = new Hashtable();
        TObjArray branches = (TObjArray)this.get("fBranches");
        int size = branches.size();
        for (int i = 0; i < size; ++i) {
            RootObjectRepresentation b = branches.elementAt(i);
            String bName = b.get("fName").toString();
            int pos = bName.indexOf(91);
            if (pos > 0) {
                bName = bName.substring(0, pos);
            }
            if ((pos = bName.indexOf(46)) > 0) {
                bName = bName.substring(pos + 1);
            }
            this.map.put(bName, b);
            this.mangledMap.put(nameMangler.mangleMember(bName), b);
        }
    }
}

