/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.RootClassFactory;
import hep.rootio.RootFileReader;
import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.AbstractRootObject;
import hep.rootio.implementation.RootInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;

public class RootRandomAccessFile
extends RandomAccessFile
implements RootInput {
    private long offset;
    private RootFileReader reader;
    private Hashtable map = new Hashtable();

    public RootRandomAccessFile(File file, RootFileReader reader) throws IOException {
        super(file, "r");
        this.reader = reader;
        if (this.readByte() != 114 || this.readByte() != 111 || this.readByte() != 111 || this.readByte() != 116) {
            throw new IOException("Not a root file: " + file);
        }
    }

    @Override
    public String readString() throws IOException {
        return RootInputStream.readString(this);
    }

    @Override
    public String readNullTerminatedString(int maxLength) throws IOException {
        return RootInputStream.readNullTerminatedString(this, maxLength);
    }

    @Override
    public int readVersion() throws IOException {
        return RootInputStream.readVersion(this, null);
    }

    @Override
    public int readVersion(AbstractRootObject obj) throws IOException {
        return RootInputStream.readVersion(this, obj);
    }

    @Override
    public int readArray(int[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    @Override
    public int readArray(byte[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    @Override
    public int readArray(float[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    @Override
    public int readArray(double[] data) throws IOException {
        return RootInputStream.readArray((RootInput)this, data);
    }

    @Override
    public void checkLength(AbstractRootObject obj) throws IOException {
        RootInputStream.checkLength(this, obj);
    }

    @Override
    public long getPosition() throws IOException {
        return this.getFilePointer() - this.offset;
    }

    @Override
    public RootObjectRepresentation readObject(String type) throws IOException {
        return RootInputStream.readObject(this, type);
    }

    @Override
    public RootObjectRepresentation readObjectRef() throws IOException {
        return RootInputStream.readObjectRef(this, this.map);
    }

    @Override
    public RootClassFactory getFactory() {
        return this.reader.getFactory();
    }

    @Override
    public RootRandomAccessFile getRAF() {
        return this;
    }

    public void clearMap() {
        this.map.clear();
        this.offset = 0L;
    }

    public void setMap(int keylen) throws IOException {
        this.offset = this.getFilePointer() - (long)keylen;
    }
}

