/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio;

import hep.rootio.RootClass;
import hep.rootio.RootClassFactory;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.DefaultClassFactory;
import hep.rootio.implementation.FileClassFactory;
import hep.rootio.implementation.RootRandomAccessFile;
import hep.rootio.interfaces.TDirectory;
import hep.rootio.interfaces.TFile;
import hep.rootio.interfaces.TKey;
import hep.rootio.reps.TString;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class RootFileReader
implements TFile {
    private RootClassFactory factory;
    private RootRandomAccessFile raf;
    private TString name;
    private TString title;
    private TDirectory dir;
    private TKey streamerInfo;
    private ClassLoader classLoader;
    private static boolean welcome = false;

    private static void welcome() {
        System.out.println("Root IO for Java, part of the FreeHEP library: http://java.freehep.org");
        System.out.println("Please report all bugs/problems to tonyj@slac.stanford.edu");
        System.out.println("Version $Id: RootFileReader.java,v 1.10 2001/06/05 22:21:47 tonyj Exp $");
        welcome = true;
    }

    public RootFileReader(String file) throws IOException {
        this(new File(file), null);
    }

    public RootFileReader(File file) throws IOException {
        this(file, null);
    }

    public RootFileReader(File file, RootClassFactory factory) throws IOException {
        if (!welcome) {
            RootFileReader.welcome();
        }
        if (factory == null) {
            factory = new DefaultClassFactory(this);
        }
        this.factory = factory;
        this.raf = new RootRandomAccessFile(file, this);
        int fVersion = this.raf.readInt();
        if (fVersion < 30006) {
            throw new IOException("hep.rootio package cannot read files created by Root before release 3.00/6 (" + fVersion + ")");
        }
        int fBEGIN = this.raf.readInt();
        int fEND = this.raf.readInt();
        int fSeekFree = this.raf.readInt();
        int fNbytesFree = this.raf.readInt();
        int nfree = this.raf.readInt();
        int fNbytesName = this.raf.readInt();
        byte fUnits = this.raf.readByte();
        int fCompress = this.raf.readInt();
        int fSeekInfo = this.raf.readInt();
        int fNBytesInfo = this.raf.readInt();
        this.raf.seek(fBEGIN);
        int Nbytes = this.raf.readInt();
        short Version2 = this.raf.readShort();
        int ObjLen = this.raf.readInt();
        RootObjectRepresentation Datime = this.raf.readObject("TDatime");
        short KeyLen = this.raf.readShort();
        short Cycle = this.raf.readShort();
        int SeekKey = this.raf.readInt();
        int SeekPdir = this.raf.readInt();
        TString className = (TString)this.raf.readObject("TString");
        this.name = (TString)this.raf.readObject("TString");
        this.title = (TString)this.raf.readObject("TString");
        this.raf.seek(fBEGIN + fNbytesName);
        this.dir = (TDirectory)this.raf.readObject("TDirectory").getProxy();
        if (fSeekInfo != 0) {
            this.raf.seek(fSeekInfo);
            this.streamerInfo = (TKey)this.raf.readObject("TKey").getProxy();
            this.factory = new FileClassFactory(this.streamerInfo, factory, this);
        }
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    public RootClassFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public String getTitle() {
        return this.title.toString();
    }

    @Override
    public int nKeys() {
        return this.dir.nKeys();
    }

    @Override
    public TKey getKey(int index) {
        return this.dir.getKey(index);
    }

    @Override
    public TKey getKeyForTitle(String name) {
        return this.dir.getKeyForTitle(name);
    }

    @Override
    public TKey getKey(String name) {
        return this.dir.getKey(name);
    }

    @Override
    public TKey streamerInfoKey() {
        return this.streamerInfo;
    }

    @Override
    public RootClass rootClass() {
        try {
            return this.factory.create("TFile");
        }
        catch (RootClassNotFound rootclassnotfound) {
            return null;
        }
    }

    @Override
    public Object getValue(String member) {
        return this.dir.getValue(member);
    }

    @Override
    public List streamerInfo() throws IOException {
        return (List)this.streamerInfo.getObject();
    }

    public Object get(String name) throws IOException {
        TKey key = this.getKey(name);
        return key.getObject();
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

