/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFFontLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontInfoFinder {
    private FontEventListener eventListener;
    private final Pattern quotePattern = Pattern.compile("'");

    public void setEventListener(FontEventListener listener) {
        this.eventListener = listener;
    }

    private void generateTripletsFromFont(CustomFont customFont, Collection<FontTriplet> triplets) {
        int guessedWeight;
        String strippedName = this.stripQuotes(customFont.getStrippedFontName());
        String fullName = this.stripQuotes(customFont.getFullName());
        String searchName = fullName.toLowerCase();
        String style = this.guessStyle(customFont, searchName);
        int weight = guessedWeight = FontUtil.guessWeight(searchName);
        triplets.add(new FontTriplet(fullName, "normal", 400));
        if (!fullName.equals(strippedName)) {
            triplets.add(new FontTriplet(strippedName, "normal", 400));
        }
        Set<String> familyNames = customFont.getFamilyNames();
        for (String familyName : familyNames) {
            if (fullName.equals(familyName = this.stripQuotes(familyName))) continue;
            int priority = fullName.startsWith(familyName) ? fullName.length() - familyName.length() : fullName.length();
            triplets.add(new FontTriplet(familyName, style, weight, priority));
        }
    }

    private String stripQuotes(String name) {
        return this.quotePattern.matcher(name).replaceAll("");
    }

    private String guessStyle(CustomFont customFont, String fontName) {
        String style = "normal";
        style = customFont.getItalicAngle() > 0 ? "italic" : FontUtil.guessStyle(fontName);
        return style;
    }

    private EmbedFontInfo getFontInfoFromCustomFont(URL fontURL, CustomFont customFont, FontCache fontCache) {
        ArrayList<FontTriplet> fontTripletList = new ArrayList<FontTriplet>();
        this.generateTripletsFromFont(customFont, fontTripletList);
        String embedUrl = fontURL.toExternalForm();
        String subFontName = null;
        if (customFont instanceof MultiByteFont) {
            subFontName = ((MultiByteFont)customFont).getTTCName();
        }
        EmbedFontInfo fontInfo = new EmbedFontInfo(null, customFont.isKerningEnabled(), customFont.isAdvancedEnabled(), fontTripletList, embedUrl, subFontName);
        fontInfo.setPostScriptName(customFont.getFontName());
        if (fontCache != null) {
            fontCache.addFont(fontInfo);
        }
        return fontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbedFontInfo[] find(URL fontURL, FontResolver resolver, FontCache fontCache) {
        String embedURL = null;
        embedURL = fontURL.toExternalForm();
        boolean useKerning = true;
        boolean useAdvanced = resolver != null ? resolver.isComplexScriptFeaturesEnabled() : true;
        long fileLastModified = -1L;
        if (fontCache != null) {
            fileLastModified = FontCache.getLastModified(fontURL);
            if (fontCache.containsFont(embedURL)) {
                EmbedFontInfo[] fontInfos = fontCache.getFontInfos(embedURL, fileLastModified);
                if (fontInfos != null) {
                    return fontInfos;
                }
            } else if (fontCache.isFailedFont(embedURL, fileLastModified)) {
                return null;
            }
        }
        CustomFont customFont = null;
        if (fontURL.toExternalForm().toLowerCase().endsWith(".ttc")) {
            List<String> ttcNames = null;
            String fontFileURL = fontURL.toExternalForm().trim();
            InputStream in = null;
            try {
                in = FontLoader.openFontUri(resolver, fontFileURL);
                TTFFile ttf = new TTFFile(false, false);
                FontFileReader reader = new FontFileReader(in);
                ttcNames = ttf.getTTCnames(reader);
            }
            catch (Exception e) {
                if (this.eventListener != null) {
                    this.eventListener.fontLoadingErrorAtAutoDetection(this, fontFileURL, e);
                }
                EmbedFontInfo[] reader = null;
                return reader;
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            ArrayList<EmbedFontInfo> embedFontInfoList = new ArrayList<EmbedFontInfo>();
            for (String fontName : ttcNames) {
                EmbedFontInfo fi;
                block23: {
                    try {
                        TTFFontLoader ttfLoader = new TTFFontLoader(fontFileURL, fontName, true, EmbeddingMode.AUTO, EncodingMode.AUTO, useKerning, useAdvanced, resolver);
                        customFont = ttfLoader.getFont();
                        if (this.eventListener == null) break block23;
                        customFont.setEventListener(this.eventListener);
                    }
                    catch (Exception e) {
                        if (fontCache != null) {
                            fontCache.registerFailedFont(embedURL, fileLastModified);
                        }
                        if (this.eventListener == null) continue;
                        this.eventListener.fontLoadingErrorAtAutoDetection(this, embedURL, e);
                        continue;
                    }
                }
                if ((fi = this.getFontInfoFromCustomFont(fontURL, customFont, fontCache)) == null) continue;
                embedFontInfoList.add(fi);
            }
            return embedFontInfoList.toArray(new EmbedFontInfo[embedFontInfoList.size()]);
        }
        try {
            customFont = FontLoader.loadFont(fontURL, null, true, EmbeddingMode.AUTO, EncodingMode.AUTO, resolver);
            if (this.eventListener != null) {
                customFont.setEventListener(this.eventListener);
            }
        }
        catch (Exception e) {
            if (fontCache != null) {
                fontCache.registerFailedFont(embedURL, fileLastModified);
            }
            if (this.eventListener != null) {
                this.eventListener.fontLoadingErrorAtAutoDetection(this, embedURL, e);
            }
            return null;
        }
        EmbedFontInfo fi = this.getFontInfoFromCustomFont(fontURL, customFont, fontCache);
        if (fi != null) {
            return new EmbedFontInfo[]{fi};
        }
        return null;
    }
}

