/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BasicLinAlg<C extends RingElem<C>>
implements Serializable {
    private static final Logger logger = Logger.getLogger(BasicLinAlg.class);

    public C scalarProduct(List<C> G, List<C> F) {
        RingElem sp = null;
        Iterator<C> it = G.iterator();
        Iterator<C> jt = F.iterator();
        while (it.hasNext() && jt.hasNext()) {
            RingElem pi = (RingElem)it.next();
            RingElem pj = (RingElem)jt.next();
            if (pi == null || pj == null) continue;
            if (sp == null) {
                sp = pi.multiply(pj);
                continue;
            }
            sp = (RingElem)sp.sum((AbelianGroupElem)pi.multiply(pj));
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"scalarProduct wrong sizes");
        }
        return (C)sp;
    }

    public List<C> leftScalarProduct(List<C> G, List<List<C>> F) {
        List<RingElem> sp = null;
        Iterator<C> it = G.iterator();
        Iterator<List<C>> jt = F.iterator();
        while (it.hasNext() && jt.hasNext()) {
            RingElem pi = (RingElem)it.next();
            List<C> pj = jt.next();
            if (pi == null || pj == null) continue;
            List<RingElem> s = this.scalarProduct(pi, pj);
            if (sp == null) {
                sp = s;
                continue;
            }
            sp = this.vectorAdd(sp, s);
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"scalarProduct wrong sizes");
        }
        return sp;
    }

    public List<C> rightScalarProduct(List<C> G, List<List<C>> F) {
        List<RingElem> sp = null;
        Iterator<C> it = G.iterator();
        Iterator<List<C>> jt = F.iterator();
        while (it.hasNext() && jt.hasNext()) {
            RingElem pi = (RingElem)it.next();
            List<C> pj = jt.next();
            if (pi == null || pj == null) continue;
            List<RingElem> s = this.scalarProduct(pj, pi);
            if (sp == null) {
                sp = s;
                continue;
            }
            sp = this.vectorAdd(sp, s);
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"scalarProduct wrong sizes");
        }
        return sp;
    }

    public List<C> vectorAdd(List<C> a, List<C> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<RingElem> V = new ArrayList<RingElem>(a.size());
        Iterator<C> it = a.iterator();
        Iterator<C> jt = b.iterator();
        while (it.hasNext() && jt.hasNext()) {
            RingElem pi = (RingElem)it.next();
            RingElem pj = (RingElem)jt.next();
            RingElem p = pi.sum(pj);
            V.add(p);
        }
        if (it.hasNext() || jt.hasNext()) {
            logger.error((Object)"vectorAdd wrong sizes");
        }
        return V;
    }

    public boolean isZero(List<C> a) {
        if (a == null) {
            return true;
        }
        for (RingElem pi : a) {
            if (pi == null || pi.isZERO()) continue;
            return false;
        }
        return true;
    }

    public List<C> scalarProduct(C p, List<C> F) {
        ArrayList<RingElem> V = new ArrayList<RingElem>(F.size());
        for (RingElem pi : F) {
            pi = p != null ? p.multiply((RingElem)pi) : null;
            V.add(pi);
        }
        return V;
    }

    public List<C> scalarProduct(List<C> F, C p) {
        ArrayList<RingElem> V = new ArrayList<RingElem>(F.size());
        for (RingElem pi : F) {
            if (pi != null) {
                pi = (RingElem)pi.multiply(p);
            }
            V.add(pi);
        }
        return V;
    }
}

