/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeFieldCharP;
import java.math.BigInteger;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SquarefreeFiniteFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeFieldCharP<C> {
    private static final Logger logger = Logger.getLogger(SquarefreeFiniteFieldCharP.class);

    public SquarefreeFiniteFieldCharP(RingFactory<C> fac) {
        super(fac);
        if (!fac.isFinite()) {
            throw new IllegalArgumentException("fac must be finite");
        }
    }

    public SortedMap<C, Long> rootCharacteristic(C p) {
        if (p == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " p == null");
        }
        TreeMap<C, Long> root = new TreeMap<C, Long>();
        if (p.isZERO()) {
            return root;
        }
        root.put(p, 1L);
        return root;
    }

    public C coeffRootCharacteristic(C c) {
        if (c == null || c.isZERO()) {
            return c;
        }
        Object r = c;
        if (this.aCoFac == null && this.qCoFac == null) {
            return r;
        }
        if (this.aCoFac != null) {
            long d = this.aCoFac.totalExtensionDegree();
            if (d <= 1L) {
                return r;
            }
            edu.jas.arith.BigInteger p = new edu.jas.arith.BigInteger(this.aCoFac.characteristic());
            edu.jas.arith.BigInteger q = Power.positivePower(p, d - 1L);
            r = (GcdRingElem)Power.positivePower(r, q.getVal());
            return r;
        }
        if (this.qCoFac != null) {
            throw new UnsupportedOperationException("case QuotientRing not yet implemented");
        }
        return r;
    }

    public SortedMap<GenPolynomial<C>, Long> rootCharacteristic(GenPolynomial<C> P) {
        if (P == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        BigInteger c = P.ring.characteristic();
        if (c.signum() == 0) {
            return null;
        }
        TreeMap<GenPolynomial<C>, Long> root = new TreeMap<GenPolynomial<C>, Long>();
        if (P.isZERO()) {
            return root;
        }
        if (P.isONE()) {
            root.put(P, 1L);
            return root;
        }
        SortedMap<GenPolynomial<C>, Long> sf = this.squarefreeFactors(P);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sf = " + sf));
        }
        Long k = null;
        for (Map.Entry<GenPolynomial<C>, Long> me : sf.entrySet()) {
            GenPolynomial<C> p = me.getKey();
            if (p.isConstant()) continue;
            Long e = me.getValue();
            BigInteger E = new BigInteger(e.toString());
            BigInteger r = E.remainder(c);
            if (!r.equals(BigInteger.ZERO)) {
                return null;
            }
            if (k == null) {
                k = e;
                continue;
            }
            if (k.compareTo(e) < 0) continue;
            k = e;
        }
        Long cl = c.longValue();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> rp = P.ring.getONE();
        for (Map.Entry<GenPolynomial<C>, Long> me : sf.entrySet()) {
            GenPolynomial<Object> q = me.getKey();
            Long e = me.getValue();
            if (q.isConstant()) {
                GcdRingElem qc = (GcdRingElem)q.leadingBaseCoefficient();
                if (e > 1L) {
                    qc = Power.positivePower(qc, e);
                }
                GcdRingElem qr = this.coeffRootCharacteristic(qc);
                q = ((GenPolynomial)P.ring.getONE()).multiply(qr);
                root.put(q, 1L);
                continue;
            }
            if (e > k) {
                long ep = e / cl;
                q = Power.positivePower(q, ep);
            }
            rp = rp.multiply((GenPolynomial<GenPolynomial<C>>)q);
        }
        if (k != null) {
            k = k / cl;
            root.put(rp, k);
        }
        return root;
    }

    @Override
    public GenPolynomial<C> baseRootCharacteristic(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for char p > 0 " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<C> m : P) {
            ExpVector f = m.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            ExpVector e = ExpVector.create(1, 0, fl /= mp);
            GcdRingElem r = this.coeffRootCharacteristic((GcdRingElem)m.c);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }

    @Override
    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        if (rf.characteristic().signum() != 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for char p > 0 " + rf);
        }
        long mp = rf.characteristic().longValue();
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        for (Monomial<GenPolynomial<C>> monomial : P) {
            ExpVector f = monomial.e;
            long fl = f.getVal(0);
            if (fl % mp != 0L) {
                return null;
            }
            fl /= mp;
            SortedMap<GenPolynomial<C>, Long> sm = this.rootCharacteristic((GenPolynomial)monomial.c);
            if (sm == null) {
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("sm,rec = " + sm));
            }
            GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = (GenPolynomial<GenPolynomial<GenPolynomial<C>>>)rf.getONE();
            for (Map.Entry<GenPolynomial<C>, Long> me : sm.entrySet()) {
                GenPolynomial<C> rp = me.getKey();
                long gl = me.getValue();
                if (gl > 1L) {
                    rp = Power.positivePower(rp, gl);
                }
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)rp);
            }
            ExpVector e = ExpVector.create(1, 0, fl);
            ((GenPolynomial)d).doPutToMap(e, r);
        }
        return d;
    }
}

