/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.FactorRational;
import edu.jas.ufd.PartialFraction;

public class ExamplesPartialFraction {
    public static void main(String[] args) {
        ExamplesPartialFraction.example11();
        ExamplesPartialFraction.example12();
        ExamplesPartialFraction.example13();
        ExamplesPartialFraction.example14();
        ExamplesPartialFraction.example15();
        ExamplesPartialFraction.example16();
        ExamplesPartialFraction.example17();
        ComputerThreads.terminate();
    }

    public static void example11() {
        System.out.println("\n\nexample 11");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("x^2 - 2");
        MonoidElem N = pfac.getONE();
        FactorRational engine = (FactorRational)FactorFactory.getImplementation(cfac);
        PartialFraction F = engine.baseAlgebraicPartialFractionIrreducible(N, D);
        System.out.println("\nintegral " + F);
    }

    public static void example12() {
        System.out.println("\n\nexample 12");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("x^3 + x");
        MonoidElem N = pfac.getONE();
        FactorRational engine = (FactorRational)FactorFactory.getImplementation(cfac);
        PartialFraction F = engine.baseAlgebraicPartialFraction(N, D);
        System.out.println("\nintegral " + F);
    }

    public static void example13() {
        System.out.println("\n\nexample 13");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("x^6 - 5 x^4 + 5 x^2 + 4");
        MonoidElem N = pfac.getONE();
        FactorRational engine = (FactorRational)FactorFactory.getImplementation(cfac);
        PartialFraction F = engine.baseAlgebraicPartialFraction(N, D);
        System.out.println("\nintegral " + F);
    }

    public static void example14() {
        System.out.println("\n\nexample 14");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("x^4 + 4");
        MonoidElem N = pfac.getONE();
        FactorRational engine = (FactorRational)FactorFactory.getImplementation(cfac);
        PartialFraction F = engine.baseAlgebraicPartialFraction(N, D);
        System.out.println("\nintegral " + F);
    }

    public static void example15() {
        System.out.println("\n\nexample 15");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("x^3 - 2");
        MonoidElem N = pfac.getONE();
        FactorRational engine = (FactorRational)FactorFactory.getImplementation(cfac);
        PartialFraction F = engine.baseAlgebraicPartialFraction(N, D);
        System.out.println("\nintegral " + F);
    }

    public static void example16() {
        System.out.println("\n\nexample 16");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("( x - 1 ) * ( x - 2 ) * ( x - 3 )");
        MonoidElem N = pfac.getONE();
        FactorRational engine = (FactorRational)FactorFactory.getImplementation(cfac);
        PartialFraction F = engine.baseAlgebraicPartialFraction(N, D);
        System.out.println("\nintegral " + F);
    }

    public static void example17() {
        System.out.println("\n\nexample 17");
        TermOrder to = new TermOrder(2);
        BigRational cfac = new BigRational(1L);
        String[] vars = new String[]{"x"};
        GenPolynomialRing<BigRational> pfac = new GenPolynomialRing<BigRational>(cfac, 1, to, vars);
        Element D = pfac.parse("x^3 - 2");
        MonoidElem N = pfac.getONE();
        FactorRational engine = (FactorRational)FactorFactory.getImplementation(cfac);
        PartialFraction F = engine.baseAlgebraicPartialFractionIrreducibleAbsolute(N, D);
        System.out.println("\nintegral " + F);
    }
}

