/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.Overlap;
import edu.jas.poly.OverlapList;
import edu.jas.poly.WordFactory;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.MonoidFactory;
import edu.jas.structure.NotInvertibleException;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Word
implements MonoidElem<Word> {
    public final WordFactory mono;
    final String val;
    protected int hash = 0;

    public Word(WordFactory m) {
        this(m, "");
    }

    public Word(WordFactory m, String s) {
        this(m, s, true);
    }

    public Word(WordFactory m, String s, boolean translate) {
        this.mono = m;
        this.hash = 0;
        if (s == null) {
            throw new IllegalArgumentException("null string not allowed");
        }
        if (translate) {
            if (this.mono.translation != null) {
                String[] S = GenPolynomialTokenizer.variableList(s);
                this.val = this.mono.translate(S);
            } else {
                this.val = WordFactory.cleanSpace(s);
            }
        } else {
            this.val = s;
        }
    }

    @Override
    public MonoidFactory<Word> factory() {
        return this.mono;
    }

    @Override
    public Word copy() {
        return new Word(this.mono, this.val, false);
    }

    String getVal() {
        return this.val;
    }

    public char getVal(int i) {
        return this.val.charAt(i);
    }

    public int length() {
        return this.val.length();
    }

    public String toString() {
        if (this.val.length() == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("\"");
        if (this.mono.translation == null) {
            for (int i = 0; i < this.length(); ++i) {
                if (i != 0) {
                    s.append(" ");
                }
                s.append(this.getVal(i));
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                if (i != 0) {
                    s.append(" ");
                }
                s.append(this.mono.transVar(this.getVal(i)));
            }
        }
        s.append("\"");
        return s.toString();
    }

    @Override
    public String toScript() {
        if (this.val.length() == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("");
        if (this.mono.translation == null) {
            for (int i = 0; i < this.length(); ++i) {
                if (i != 0) {
                    s.append("*");
                }
                s.append(this.getVal(i));
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                if (i != 0) {
                    s.append("*");
                }
                s.append(this.mono.transVar(this.getVal(i)));
            }
        }
        s.append("");
        return s.toString();
    }

    @Override
    public String toScriptFactory() {
        return this.mono.toString();
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof Word)) {
            return false;
        }
        Word b = (Word)B;
        int t = this.compareTo(b);
        return 0 == t;
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.val.hashCode();
        }
        return this.hash;
    }

    @Override
    public boolean isONE() {
        return 0 == this.length();
    }

    @Override
    public boolean isUnit() {
        return this.isONE();
    }

    @Override
    public Word multiply(Word V) {
        return new Word(this.mono, this.val + V.val, false);
    }

    @Override
    public Word divide(Word V) {
        Word[] ret = this.divideWord(V);
        if (!ret[0].isONE() && !ret[1].isONE()) {
            throw new IllegalArgumentException("not simple dividable: left = " + ret[0] + ", right = " + ret[1] + ", use divideWord");
        }
        return ret[0].multiply(ret[1]);
    }

    public Word[] divideWord(Word V) {
        int i = this.val.indexOf(V.val);
        if (i < 0) {
            throw new NotInvertibleException("not dividable: " + this + ", other " + V);
        }
        int len = V.val.length();
        String pre = this.val.substring(0, i);
        String suf = this.val.substring(i + len);
        Word[] ret = new Word[]{new Word(this.mono, pre, false), new Word(this.mono, suf, false)};
        return ret;
    }

    @Override
    public Word remainder(Word V) {
        int i = this.val.indexOf(V.val);
        if (i < 0) {
            throw new NotInvertibleException("not dividable: " + this + ", other " + V);
        }
        return V;
    }

    public Word[] quotientRemainder(Word S) {
        return new Word[]{this.divide(S), this.remainder(S)};
    }

    @Override
    public Word inverse() {
        if (this.val.length() == 0) {
            return this;
        }
        throw new NotInvertibleException("not inversible " + this);
    }

    public int signum() {
        int i = this.val.length();
        if (i > 0) {
            i = 1;
        }
        assert (i >= 0);
        return i;
    }

    public long degree() {
        return this.val.length();
    }

    public SortedMap<String, Integer> dependencyOnVariables() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (int i = 0; i < this.val.length(); ++i) {
            String s = String.valueOf(this.val.charAt(i));
            Integer n = (Integer)map.get(s);
            if (n == null) {
                n = 0;
            }
            n = n + 1;
            map.put(s, n);
        }
        return map;
    }

    public boolean multipleOf(Word V) {
        return this.val.contains(V.val);
    }

    public boolean divides(Word V) {
        return V.val.contains(this.val);
    }

    @Override
    public int compareTo(Word V) {
        return this.val.compareTo(V.val);
    }

    public int gradCompareTo(Word V) {
        long f;
        long e = this.degree();
        if (e < (f = V.degree())) {
            return 1;
        }
        if (e > f) {
            return -1;
        }
        return this.compareTo(V);
    }

    public int gradInvlexCompareTo(Word V) {
        long f;
        long e = this.degree();
        if (e < (f = V.degree())) {
            return 1;
        }
        if (e > f) {
            return -1;
        }
        return -this.compareTo(V);
    }

    public boolean isOverlap(Overlap ol, Word V) {
        return ol.isOverlap(this, V);
    }

    public OverlapList overlap(Word V) {
        OverlapList ret = new OverlapList();
        Word wone = this.mono.getONE();
        String a = this.val;
        String b = V.val;
        int ai = a.length();
        int bi = b.length();
        int j = b.indexOf(a);
        if (j >= 0) {
            while (j >= 0) {
                String pre = b.substring(0, j);
                String suf = b.substring(j + ai);
                Word wpre = new Word(this.mono, pre, false);
                Word wsuf = new Word(this.mono, suf, false);
                ret.add(new Overlap(wpre, wsuf, wone, wone));
                j = b.indexOf(a, j + ai);
            }
            return ret;
        }
        j = a.indexOf(b);
        if (j >= 0) {
            while (j >= 0) {
                String pre = a.substring(0, j);
                String suf = a.substring(j + bi);
                Word wpre = new Word(this.mono, pre, false);
                Word wsuf = new Word(this.mono, suf, false);
                ret.add(new Overlap(wone, wone, wpre, wsuf));
                j = a.indexOf(b, j + bi);
            }
            return ret;
        }
        if (ai >= bi) {
            Word w2;
            Word w1;
            String bs;
            String as;
            int i;
            for (i = 0; i < bi; ++i) {
                as = a.substring(0, i + 1);
                if (!as.equals(bs = b.substring(bi - i - 1, bi))) continue;
                w1 = new Word(this.mono, b.substring(0, bi - i - 1), false);
                w2 = new Word(this.mono, a.substring(i + 1), false);
                ret.add(new Overlap(w1, wone, wone, w2));
                break;
            }
            for (i = 0; i < bi; ++i) {
                as = a.substring(ai - i - 1, ai);
                if (!as.equals(bs = b.substring(0, i + 1))) continue;
                w1 = new Word(this.mono, b.substring(i + 1), false);
                w2 = new Word(this.mono, a.substring(0, ai - i - 1), false);
                ret.add(new Overlap(wone, w1, w2, wone));
                break;
            }
        } else {
            Word w2;
            Word w1;
            String bs;
            String as;
            int i;
            for (i = 0; i < ai; ++i) {
                as = a.substring(ai - i - 1, ai);
                if (!as.equals(bs = b.substring(0, i + 1))) continue;
                w1 = new Word(this.mono, b.substring(i + 1), false);
                w2 = new Word(this.mono, a.substring(0, ai - i - 1), false);
                ret.add(new Overlap(wone, w1, w2, wone));
                break;
            }
            for (i = 0; i < ai; ++i) {
                as = a.substring(0, i + 1);
                if (!as.equals(bs = b.substring(bi - i - 1, bi))) continue;
                w1 = new Word(this.mono, b.substring(0, bi - i - 1), false);
                w2 = new Word(this.mono, a.substring(i + 1), false);
                ret.add(new Overlap(w1, wone, wone, w2));
                break;
            }
        }
        return ret;
    }

    public Word lcm(Word V) {
        OverlapList oll = this.overlap(V);
        if (oll.ols.isEmpty()) {
            return null;
        }
        Overlap ol = oll.ols.get(0);
        Word g = ol.l1.multiply(this).multiply(ol.r1);
        return g;
    }
}

