/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import edu.jas.vector.BasicLinAlg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class TermOrderOptimization {
    private static final Logger logger = Logger.getLogger(TermOrderOptimization.class);

    public static <C extends RingElem<C>> List<GenPolynomial<BigInteger>> degreeMatrix(GenPolynomial<C> A) {
        List<GenPolynomial<BigInteger>> dem = null;
        if (A == null) {
            return dem;
        }
        BigInteger cfac = new BigInteger();
        GenPolynomialRing<BigInteger> ufac = new GenPolynomialRing<BigInteger>(cfac, 1);
        int nvar = A.numberOfVariables();
        dem = new ArrayList<GenPolynomial<BigInteger>>(nvar);
        for (int i = 0; i < nvar; ++i) {
            dem.add((GenPolynomial<BigInteger>)ufac.getZERO());
        }
        if (A.isZERO()) {
            return dem;
        }
        for (ExpVector e : A.getMap().keySet()) {
            dem = TermOrderOptimization.expVectorAdd(dem, e);
        }
        return dem;
    }

    public static List<GenPolynomial<BigInteger>> expVectorAdd(List<GenPolynomial<BigInteger>> dm, ExpVector e) {
        for (int i = 0; i < dm.size() && i < e.length(); ++i) {
            GenPolynomial<BigInteger> p = dm.get(i);
            long u = e.getVal(i);
            ExpVector f = ExpVector.create(1, 0, u);
            p = p.sum((BigInteger)p.ring.getONECoefficient(), f);
            dm.set(i, p);
        }
        return dm;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<BigInteger>> degreeMatrixOfCoefficients(GenPolynomial<GenPolynomial<C>> A) {
        if (A == null) {
            throw new IllegalArgumentException("polynomial must not be null");
        }
        return TermOrderOptimization.degreeMatrix(A.getMap().values());
    }

    public static <C extends RingElem<C>> List<GenPolynomial<BigInteger>> degreeMatrix(Collection<GenPolynomial<C>> L) {
        if (L == null) {
            throw new IllegalArgumentException("list must be non null");
        }
        BasicLinAlg<GenPolynomial<BigInteger>> blas = new BasicLinAlg<GenPolynomial<BigInteger>>();
        List<GenPolynomial<BigInteger>> dem = null;
        for (GenPolynomial<C> p : L) {
            List<GenPolynomial<BigInteger>> dm = TermOrderOptimization.degreeMatrix(p);
            if (dem == null) {
                dem = dm;
                continue;
            }
            dem = blas.vectorAdd(dem, dm);
        }
        return dem;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<BigInteger>> degreeMatrixOfCoefficients(Collection<GenPolynomial<GenPolynomial<C>>> L) {
        if (L == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        BasicLinAlg<GenPolynomial<BigInteger>> blas = new BasicLinAlg<GenPolynomial<BigInteger>>();
        List<GenPolynomial<BigInteger>> dem = null;
        for (GenPolynomial<GenPolynomial<C>> p : L) {
            List<GenPolynomial<BigInteger>> dm = TermOrderOptimization.degreeMatrixOfCoefficients(p);
            if (dem == null) {
                dem = dm;
                continue;
            }
            dem = blas.vectorAdd(dem, dm);
        }
        return dem;
    }

    public static List<Integer> optimalPermutation(List<GenPolynomial<BigInteger>> D) {
        if (D == null) {
            throw new IllegalArgumentException("list must be non null");
        }
        ArrayList<Integer> P = new ArrayList<Integer>(D.size());
        if (D.size() == 0) {
            return P;
        }
        if (D.size() == 1) {
            P.add(0);
            return P;
        }
        TreeMap<GenPolynomial<BigInteger>, ArrayList<Integer>> map = new TreeMap<GenPolynomial<BigInteger>, ArrayList<Integer>>();
        int i = 0;
        for (GenPolynomial<BigInteger> p : D) {
            ArrayList<Integer> il = (ArrayList<Integer>)map.get(p);
            if (il == null) {
                il = new ArrayList<Integer>(3);
            }
            il.add(i);
            map.put(p, il);
            ++i;
        }
        ArrayList V = new ArrayList(map.values());
        for (int j = 0; j < V.size(); ++j) {
            List v = (List)V.get(j);
            for (Integer k : v) {
                P.add(k);
            }
        }
        return P;
    }

    public static List<Integer> inversePermutation(List<Integer> P) {
        if (P == null || P.size() <= 1) {
            return P;
        }
        ArrayList<Integer> ip = new ArrayList<Integer>(P);
        for (int i = 0; i < P.size(); ++i) {
            ip.set(P.get(i), i);
        }
        return ip;
    }

    public static boolean isIdentityPermutation(List<Integer> P) {
        if (P == null || P.size() <= 1) {
            return true;
        }
        for (int i = 0; i < P.size(); ++i) {
            if (P.get(i) == i) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> multiplyPermutation(List<Integer> P, List<Integer> S) {
        if (P == null || S == null) {
            return null;
        }
        if (P.size() != S.size()) {
            throw new IllegalArgumentException("#P != #S: P =" + P + ", S = " + S);
        }
        ArrayList<Integer> ip = new ArrayList<Integer>(P);
        for (int i = 0; i < P.size(); ++i) {
            ip.set(i, S.get(P.get(i)));
        }
        return ip;
    }

    public static <T> List<T> listPermutation(List<Integer> P, List<T> L) {
        if (L == null || L.size() <= 1) {
            return L;
        }
        ArrayList<T> pl = new ArrayList<T>(L.size());
        for (Integer i : P) {
            pl.add(L.get(i));
        }
        return pl;
    }

    public static <T> T[] arrayPermutation(List<Integer> P, T[] a) {
        if (a == null || a.length <= 1) {
            return a;
        }
        Object[] b = new Object[a.length];
        int j = 0;
        for (Integer i : P) {
            b[j] = a[i];
            ++j;
        }
        return b;
    }

    public static String[] stringArrayPermutation(List<Integer> P, String[] a) {
        if (a == null || a.length <= 1) {
            return a;
        }
        String[] b = new String[a.length];
        int j = 0;
        for (Integer i : P) {
            b[j] = a[i];
            ++j;
        }
        return b;
    }

    public static long[] longArrayPermutation(List<Integer> P, long[] a) {
        if (a == null || a.length <= 1) {
            return a;
        }
        long[] b = new long[a.length];
        int j = 0;
        for (Integer i : P) {
            b[j] = a[i];
            ++j;
        }
        return b;
    }

    public static ExpVector permutation(List<Integer> P, ExpVector e) {
        if (e == null) {
            return e;
        }
        long[] u = TermOrderOptimization.longArrayPermutation(P, e.getVal());
        ExpVector f = ExpVector.create(u);
        return f;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> permutation(List<Integer> P, GenPolynomialRing<C> R, GenPolynomial<C> A) {
        if (A == null) {
            return A;
        }
        Element B = ((GenPolynomial)R.getZERO()).copy();
        SortedMap Bv = ((GenPolynomial)B).val;
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            RingElem a = (RingElem)y.getValue();
            ExpVector f = TermOrderOptimization.permutation(P, e);
            Bv.put(f, a);
        }
        return B;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> permutation(List<Integer> P, GenPolynomialRing<C> R, List<GenPolynomial<C>> L) {
        if (L == null || L.size() == 0) {
            return L;
        }
        ArrayList<GenPolynomial<C>> K = new ArrayList<GenPolynomial<C>>(L.size());
        for (GenPolynomial<C> a : L) {
            GenPolynomial<C> b = TermOrderOptimization.permutation(P, R, a);
            K.add(b);
        }
        return K;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> permutationOnCoefficients(List<Integer> P, GenPolynomialRing<GenPolynomial<C>> R, GenPolynomial<GenPolynomial<C>> A) {
        if (A == null) {
            return A;
        }
        Element B = ((GenPolynomial)R.getZERO()).copy();
        GenPolynomialRing cf = (GenPolynomialRing)R.coFac;
        SortedMap Bv = ((GenPolynomial)B).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> a = y.getValue();
            GenPolynomial<C> b = TermOrderOptimization.permutation(P, cf, a);
            Bv.put(e, b);
        }
        return B;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> permutationOnCoefficients(List<Integer> P, GenPolynomialRing<GenPolynomial<C>> R, List<GenPolynomial<GenPolynomial<C>>> L) {
        if (L == null || L.size() == 0) {
            return L;
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> K = new ArrayList<GenPolynomial<GenPolynomial<C>>>(L.size());
        for (GenPolynomial<GenPolynomial<C>> a : L) {
            GenPolynomial<GenPolynomial<C>> b = TermOrderOptimization.permutationOnCoefficients(P, R, a);
            K.add(b);
        }
        return K;
    }

    public static <C extends RingElem<C>> GenPolynomialRing<C> permutation(List<Integer> P, GenPolynomialRing<C> R) {
        int i;
        long[][] weight;
        if (R == null) {
            return R;
        }
        if (R.vars == null || R.nvar <= 1) {
            return R;
        }
        TermOrder tord = R.tord;
        if (tord.getEvord2() != 0) {
            tord = new TermOrder(tord.getEvord2());
            logger.warn((Object)("split term order '" + R.tord + "' not permutable, resetting to most base term order " + tord));
        }
        if ((weight = tord.getWeight()) != null) {
            long[][] w = new long[weight.length][];
            for (i = 0; i < weight.length; ++i) {
                w[i] = TermOrderOptimization.longArrayPermutation(P, weight[i]);
            }
            tord = new TermOrder(w);
        }
        String[] v1 = new String[R.vars.length];
        for (i = 0; i < v1.length; ++i) {
            v1[i] = R.vars[v1.length - 1 - i];
        }
        String[] vars = TermOrderOptimization.stringArrayPermutation(P, v1);
        String[] v2 = new String[R.vars.length];
        for (int i2 = 0; i2 < v1.length; ++i2) {
            v2[i2] = vars[v2.length - 1 - i2];
        }
        GenPolynomialRing S = new GenPolynomialRing(R.coFac, R.nvar, tord, v2);
        return S;
    }

    public static <C extends RingElem<C>> OptimizedPolynomialList<C> optimizeTermOrder(GenPolynomialRing<C> R, List<GenPolynomial<C>> L) {
        List<Integer> perm = TermOrderOptimization.optimalPermutation(TermOrderOptimization.degreeMatrix(L));
        GenPolynomialRing<C> pring = TermOrderOptimization.permutation(perm, R);
        List<GenPolynomial<C>> ppolys = TermOrderOptimization.permutation(perm, pring, L);
        OptimizedPolynomialList<C> op = new OptimizedPolynomialList<C>(perm, pring, ppolys);
        return op;
    }

    public static <C extends RingElem<C>> OptimizedPolynomialList<C> optimizeTermOrder(PolynomialList<C> P) {
        if (P == null) {
            return null;
        }
        return TermOrderOptimization.optimizeTermOrder(P.ring, P.list);
    }

    public static <C extends RingElem<C>> OptimizedPolynomialList<GenPolynomial<C>> optimizeTermOrderOnCoefficients(PolynomialList<GenPolynomial<C>> P) {
        if (P == null) {
            return null;
        }
        List<Integer> perm = TermOrderOptimization.optimalPermutation(TermOrderOptimization.degreeMatrixOfCoefficients(P.list));
        GenPolynomialRing ring = P.ring;
        GenPolynomialRing coFac = (GenPolynomialRing)ring.coFac;
        GenPolynomialRing<C> pFac = TermOrderOptimization.permutation(perm, coFac);
        GenPolynomialRing<GenPolynomial<C>> pring = new GenPolynomialRing<GenPolynomial<C>>(pFac, ring.nvar, ring.tord, ring.vars);
        List ppolys = TermOrderOptimization.permutationOnCoefficients(perm, pring, P.list);
        OptimizedPolynomialList<GenPolynomial<C>> op = new OptimizedPolynomialList<GenPolynomial<C>>(perm, pring, ppolys);
        return op;
    }
}

