/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.Modular;
import edu.jas.arith.ModularRingFactory;
import edu.jas.arith.Product;
import edu.jas.arith.ProductRing;
import edu.jas.arith.Rational;
import edu.jas.poly.AlgToPoly;
import edu.jas.poly.AlgebToCompl;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.AnyToComplex;
import edu.jas.poly.CoeffToAlg;
import edu.jas.poly.CoeffToRecAlg;
import edu.jas.poly.CompRatToDec;
import edu.jas.poly.ComplToAlgeb;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.DistToRec;
import edu.jas.poly.EvalMain;
import edu.jas.poly.EvalMainPol;
import edu.jas.poly.ExpVector;
import edu.jas.poly.FromInteger;
import edu.jas.poly.FromIntegerPoly;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ImagPart;
import edu.jas.poly.ImagPartComplex;
import edu.jas.poly.ModSymToInt;
import edu.jas.poly.ModToInt;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyToAlg;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RatToCompl;
import edu.jas.poly.RatToDec;
import edu.jas.poly.RatToInt;
import edu.jas.poly.RatToIntFactor;
import edu.jas.poly.RatToIntPoly;
import edu.jas.poly.RealPart;
import edu.jas.poly.RealPartComplex;
import edu.jas.poly.RecToDist;
import edu.jas.poly.TermOrder;
import edu.jas.poly.ToComplex;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.structure.UnaryFunctor;
import edu.jas.util.ListUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class PolyUtil {
    private static final Logger logger = Logger.getLogger(PolyUtil.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursive(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<C> A) {
        Element B = ((GenPolynomial)rfac.getZERO()).copy();
        if (A.isZERO()) {
            return B;
        }
        int i = rfac.nvar;
        GenPolynomial<RingElem> zero = rfac.getZEROCoefficient();
        SortedMap Bv = ((GenPolynomial)B).val;
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            RingElem a = (RingElem)y.getValue();
            ExpVector f = e.contract(0, i);
            ExpVector g = e.contract(i, e.length() - i);
            GenPolynomial<RingElem> p = (GenPolynomial<RingElem>)Bv.get(f);
            if (p == null) {
                p = zero;
            }
            p = p.sum(a, g);
            Bv.put(f, p);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> distribute(GenPolynomialRing<C> dfac, GenPolynomial<GenPolynomial<C>> B) {
        Element C = ((GenPolynomial)dfac.getZERO()).copy();
        if (B.isZERO()) {
            return C;
        }
        SortedMap Cm = ((GenPolynomial)C).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> y : B.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial<C> A = y.getValue();
            for (Map.Entry x : A.val.entrySet()) {
                ExpVector f = x.getKey();
                RingElem b = (RingElem)x.getValue();
                ExpVector g = e.combine(f);
                assert (Cm.get(g) != null);
                Cm.put(g, b);
            }
        }
        return C;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> recursive(GenPolynomialRing<GenPolynomial<C>> rfac, List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new DistToRec<C>(rfac));
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> distribute(GenPolynomialRing<C> dfac, List<GenPolynomial<GenPolynomial<C>>> L) {
        return ListUtil.map(L, new RecToDist<C>(dfac));
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<edu.jas.arith.BigInteger> integerFromModularCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new ModSymToInt());
    }

    public static <C extends RingElem<C> & Modular> List<GenPolynomial<edu.jas.arith.BigInteger>> integerFromModularCoefficients(final GenPolynomialRing<edu.jas.arith.BigInteger> fac, List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, GenPolynomial<edu.jas.arith.BigInteger>>(){

            @Override
            public GenPolynomial<edu.jas.arith.BigInteger> eval(GenPolynomial<C> c) {
                return PolyUtil.integerFromModularCoefficients((GenPolynomialRing<edu.jas.arith.BigInteger>)fac, c);
            }
        });
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<edu.jas.arith.BigInteger> integerFromModularCoefficientsPositive(GenPolynomialRing<edu.jas.arith.BigInteger> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new ModToInt());
    }

    public static GenPolynomial<edu.jas.arith.BigInteger> integerFromRationalCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> fac, GenPolynomial<BigRational> A) {
        if (A == null || A.isZERO()) {
            return fac.getZERO();
        }
        BigInteger c = null;
        int s = 0;
        for (BigRational y : A.val.values()) {
            BigInteger x = y.denominator();
            if (c == null) {
                c = x;
                s = x.signum();
                continue;
            }
            BigInteger d = c.gcd(x);
            c = c.multiply(x.divide(d));
        }
        if (s < 0) {
            c = c.negate();
        }
        return PolyUtil.map(fac, A, new RatToInt(c));
    }

    public static Object[] integerFromRationalCoefficientsFactor(GenPolynomialRing<edu.jas.arith.BigInteger> fac, GenPolynomial<BigRational> A) {
        Object[] result = new Object[3];
        if (A == null || A.isZERO()) {
            result[0] = BigInteger.ONE;
            result[1] = BigInteger.ZERO;
            result[2] = fac.getZERO();
            return result;
        }
        BigInteger gcd = null;
        BigInteger lcm = null;
        int sLCM = 0;
        int sGCD = 0;
        for (BigRational y : A.val.values()) {
            BigInteger numerator = y.numerator();
            BigInteger denominator = y.denominator();
            if (lcm == null) {
                lcm = denominator;
                sLCM = denominator.signum();
            } else {
                BigInteger d = lcm.gcd(denominator);
                lcm = lcm.multiply(denominator.divide(d));
            }
            if (gcd == null) {
                gcd = numerator;
                sGCD = numerator.signum();
                continue;
            }
            gcd = gcd.gcd(numerator);
        }
        if (sLCM < 0) {
            lcm = lcm.negate();
        }
        if (sGCD < 0) {
            gcd = gcd.negate();
        }
        result[0] = gcd;
        result[1] = lcm;
        result[2] = PolyUtil.map(fac, A, new RatToIntFactor(gcd, lcm));
        return result;
    }

    public static List<GenPolynomial<edu.jas.arith.BigInteger>> integerFromRationalCoefficients(GenPolynomialRing<edu.jas.arith.BigInteger> fac, List<GenPolynomial<BigRational>> L) {
        return ListUtil.map(L, new RatToIntPoly(fac));
    }

    public static <C extends RingElem<C>> GenPolynomial<C> fromIntegerCoefficients(GenPolynomialRing<C> fac, GenPolynomial<edu.jas.arith.BigInteger> A) {
        return PolyUtil.map(fac, A, new FromInteger(fac.coFac));
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> fromIntegerCoefficients(GenPolynomialRing<C> fac, List<GenPolynomial<edu.jas.arith.BigInteger>> L) {
        return ListUtil.map(L, new FromIntegerPoly<C>(fac));
    }

    public static <C extends RingElem<C> & Rational> GenPolynomial<BigDecimal> decimalFromRational(GenPolynomialRing<BigDecimal> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new RatToDec());
    }

    public static <C extends RingElem<C> & Rational> GenPolynomial<Complex<BigDecimal>> complexDecimalFromRational(GenPolynomialRing<Complex<BigDecimal>> fac, GenPolynomial<Complex<C>> A) {
        return PolyUtil.map(fac, A, new CompRatToDec(fac.coFac));
    }

    public static GenPolynomial<BigRational> realPart(GenPolynomialRing<BigRational> fac, GenPolynomial<BigComplex> A) {
        return PolyUtil.map(fac, A, new RealPart());
    }

    public static GenPolynomial<BigRational> imaginaryPart(GenPolynomialRing<BigRational> fac, GenPolynomial<BigComplex> A) {
        return PolyUtil.map(fac, A, new ImagPart());
    }

    public static <C extends RingElem<C>> GenPolynomial<C> realPartFromComplex(GenPolynomialRing<C> fac, GenPolynomial<Complex<C>> A) {
        return PolyUtil.map(fac, A, new RealPartComplex());
    }

    public static <C extends RingElem<C>> GenPolynomial<C> imaginaryPartFromComplex(GenPolynomialRing<C> fac, GenPolynomial<Complex<C>> A) {
        return PolyUtil.map(fac, A, new ImagPartComplex());
    }

    public static <C extends RingElem<C>> GenPolynomial<Complex<C>> toComplex(GenPolynomialRing<Complex<C>> fac, GenPolynomial<C> A) {
        return PolyUtil.map(fac, A, new ToComplex(fac.coFac));
    }

    public static GenPolynomial<BigComplex> complexFromRational(GenPolynomialRing<BigComplex> fac, GenPolynomial<BigRational> A) {
        return PolyUtil.map(fac, A, new RatToCompl());
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Complex<C>> complexFromAny(GenPolynomialRing<Complex<C>> fac, GenPolynomial<C> A) {
        ComplexRing cr = (ComplexRing)fac.coFac;
        return PolyUtil.map(fac, A, new AnyToComplex(cr));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<GenPolynomial<C>> fromAlgebraicCoefficients(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<AlgebraicNumber<C>> A) {
        return PolyUtil.map(rfac, A, new AlgToPoly());
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToAlg(afac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertToRecAlgebraicCoefficients(int depth, GenPolynomialRing<AlgebraicNumber<C>> pfac, GenPolynomial<C> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new CoeffToRecAlg(depth, afac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> convertRecursiveToAlgebraicCoefficients(GenPolynomialRing<AlgebraicNumber<C>> pfac, GenPolynomial<GenPolynomial<C>> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)pfac.coFac;
        return PolyUtil.map(pfac, A, new PolyToAlg(afac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Complex<C>> complexFromAlgebraic(GenPolynomialRing<Complex<C>> fac, GenPolynomial<AlgebraicNumber<C>> A) {
        ComplexRing cfac = (ComplexRing)fac.coFac;
        return PolyUtil.map(fac, A, new AlgebToCompl(cfac));
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<AlgebraicNumber<C>> algebraicFromComplex(GenPolynomialRing<AlgebraicNumber<C>> fac, GenPolynomial<Complex<C>> A) {
        AlgebraicNumberRing afac = (AlgebraicNumberRing)fac.coFac;
        return PolyUtil.map(fac, A, new ComplToAlgeb(afac));
    }

    public static <C extends RingElem<C> & Modular> GenPolynomial<C> chineseRemainder(GenPolynomialRing<C> fac, GenPolynomial<C> A, C mi, GenPolynomial<C> B) {
        ExpVector e;
        ModularRingFactory cfac = (ModularRingFactory)fac.coFac;
        Element S = ((GenPolynomial)fac.getZERO()).copy();
        Element Ap = A.copy();
        SortedMap av = ((GenPolynomial)Ap).val;
        SortedMap<ExpVector, C> bv = B.getMap();
        SortedMap sv = ((GenPolynomial)S).val;
        RingElem c = null;
        for (Map.Entry<ExpVector, C> me : bv.entrySet()) {
            e = me.getKey();
            RingElem y = (RingElem)me.getValue();
            RingElem x = (RingElem)av.get(e);
            if (x != null) {
                av.remove(e);
                c = cfac.chineseRemainder(x, mi, y);
                if (c.isZERO()) continue;
                sv.put(e, c);
                continue;
            }
            c = cfac.chineseRemainder((RingElem)A.ring.coFac.getZERO(), mi, y);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        for (Map.Entry<ExpVector, C> me : av.entrySet()) {
            e = me.getKey();
            RingElem x = (RingElem)me.getValue();
            c = cfac.chineseRemainder(x, mi, (RingElem)B.ring.coFac.getZERO());
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        return S;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> monic(GenPolynomial<GenPolynomial<C>> p) {
        if (p == null || p.isZERO()) {
            return p;
        }
        C lc = p.leadingBaseCoefficient().leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return p;
        }
        RingElem lm = (RingElem)lc.inverse();
        GenPolynomial<RingElem> L = (GenPolynomial<RingElem>)p.ring.coFac.getONE();
        L = L.multiply(lm);
        return p.multiply((GenPolynomial<GenPolynomial<RingElem>>)L);
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> monic(GenSolvablePolynomial<GenPolynomial<C>> p) {
        if (p == null || p.isZERO()) {
            return p;
        }
        Object lc = ((GenPolynomial)p.leadingBaseCoefficient()).leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return p;
        }
        RingElem lm = (RingElem)lc.inverse();
        GenPolynomial L = (GenSolvablePolynomial)p.ring.coFac.getONE();
        L = L.multiply(lm);
        return p.multiplyLeft(L);
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> monic(List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, GenPolynomial<C>>(){

            @Override
            public GenPolynomial<C> eval(GenPolynomial<C> c) {
                if (c == null) {
                    return null;
                }
                return c.monic();
            }
        });
    }

    public static <C extends RingElem<C>> List<GenPolynomial<GenPolynomial<C>>> monicRec(List<GenPolynomial<GenPolynomial<C>>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<GenPolynomial<C>>, GenPolynomial<GenPolynomial<C>>>(){

            @Override
            public GenPolynomial<GenPolynomial<C>> eval(GenPolynomial<GenPolynomial<C>> c) {
                if (c == null) {
                    return null;
                }
                return PolyUtil.monic(c);
            }
        });
    }

    public static <C extends RingElem<C>> List<ExpVector> leadingExpVector(List<GenPolynomial<C>> L) {
        return ListUtil.map(L, new UnaryFunctor<GenPolynomial<C>, ExpVector>(){

            @Override
            public ExpVector eval(GenPolynomial<C> c) {
                if (c == null) {
                    return null;
                }
                return c.leadingExpVector();
            }
        });
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> extendCoefficients(GenPolynomialRing<GenPolynomial<C>> pfac, GenPolynomial<GenPolynomial<C>> A, int j, long k) {
        Element Cp = ((GenPolynomial)pfac.getZERO()).copy();
        if (A.isZERO()) {
            return Cp;
        }
        GenPolynomialRing cfac = (GenPolynomialRing)pfac.coFac;
        SortedMap CC = ((GenPolynomial)Cp).val;
        for (Map.Entry y : A.val.entrySet()) {
            ExpVector e = y.getKey();
            GenPolynomial a = (GenPolynomial)y.getValue();
            GenPolynomial f = a.extend(cfac, j, k);
            CC.put(e, f);
        }
        return Cp;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> extendCoefficients(GenSolvablePolynomialRing<GenPolynomial<C>> pfac, GenSolvablePolynomial<GenPolynomial<C>> A, int j, long k) {
        GenPolynomial Cp = ((GenSolvablePolynomial)pfac.getZERO()).copy();
        if (A.isZERO()) {
            return Cp;
        }
        GenPolynomialRing cfac = (GenPolynomialRing)pfac.coFac;
        SortedMap CC = ((GenSolvablePolynomial)Cp).val;
        for (Map.Entry y : A.val.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            GenPolynomial a = (GenPolynomial)y.getValue();
            GenPolynomial f = a.extend(cfac, j, k);
            CC.put(e, f);
        }
        return Cp;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> toRecursive(GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomial<C> A) {
        Element B = ((GenPolynomial)rfac.getZERO()).copy();
        if (A.isZERO()) {
            return B;
        }
        GenPolynomial one = rfac.getONECoefficient();
        SortedMap Bv = ((GenPolynomial)B).val;
        for (Monomial<C> m : A) {
            ExpVector e = m.e;
            Object a = m.c;
            GenPolynomial<C> p = one.multiply(a);
            Bv.put(e, p);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomial<GenPolynomial<C>> toRecursive(GenSolvablePolynomialRing<GenPolynomial<C>> rfac, GenSolvablePolynomial<C> A) {
        GenPolynomial B = ((GenSolvablePolynomial)rfac.getZERO()).copy();
        if (A.isZERO()) {
            return B;
        }
        GenPolynomial one = (GenPolynomial)rfac.getONECoefficient();
        SortedMap Bv = ((GenSolvablePolynomial)B).val;
        for (Monomial m : A) {
            ExpVector e = m.e;
            Object a = m.c;
            GenPolynomial p = one.multiply(a);
            Bv.put(e, p);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseRemainderPoly(GenPolynomial<C> P, C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + s);
        }
        Element h = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap hm = ((GenPolynomial)h).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            RingElem a = (RingElem)m.getValue();
            C x = a.remainder(s);
            hm.put(f, x);
        }
        return h;
    }

    @Deprecated
    public static <C extends RingElem<C>> GenPolynomial<C> basePseudoRemainder(GenPolynomial<C> P, GenPolynomial<C> S) {
        return PolyUtil.baseSparsePseudoRemainder(P, S);
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseSparsePseudoRemainder(GenPolynomial<C> P, GenPolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        if (P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial<Object> h;
            C a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            RingElem x = (RingElem)a.remainder(c);
            if (x.isZERO()) {
                RingElem y = (RingElem)a.divide(c);
                h = S.multiply(y, f);
            } else {
                r = r.multiply(c);
                h = S.multiply((RingElem)a, f);
            }
            r = r.subtract((C)h);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDensePseudoRemainder(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        long m = P.degree(0);
        long n = S.degree(0);
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        for (long i = m; i >= n; --i) {
            if (r.isZERO()) {
                return r;
            }
            long k = r.degree(0);
            if (i == k) {
                ExpVector f = r.leadingExpVector();
                C a = r.leadingBaseCoefficient();
                f = f.subtract(e);
                r = r.multiply(c);
                GenPolynomial<C> h = S.multiply(a, f);
                r = r.subtract((C)h);
                continue;
            }
            r = r.multiply(c);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDensePseudoQuotient(GenPolynomial<C> P, GenPolynomial<C> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P.isZERO()) {
            return P;
        }
        long m = P.degree(0);
        long n = S.degree(0);
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<C> q = P.ring.getZERO();
        GenPolynomial<Object> r = P;
        for (long i = m; i >= n; --i) {
            if (r.isZERO()) {
                return q;
            }
            long k = r.degree(0);
            if (i == k) {
                ExpVector f = r.leadingExpVector();
                C a = r.leadingBaseCoefficient();
                f = f.subtract(e);
                r = r.multiply(c);
                GenPolynomial<C> h = S.multiply(a, f);
                r = r.subtract((C)h);
                q = q.multiply(c);
                q = q.sum(a, f);
                continue;
            }
            q = q.multiply(c);
            r = r.multiply(c);
        }
        return q;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> basePseudoDivide(GenPolynomial<C> P, GenPolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        if (P.isZERO() || S.isONE()) {
            return P;
        }
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        GenPolynomial q = ((GenPolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial h;
            C a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            RingElem x = (RingElem)a.remainder(c);
            if (x.isZERO()) {
                RingElem y = (RingElem)a.divide(c);
                q = q.sum(y, f);
                h = S.multiply(y, f);
            } else {
                q = q.multiply(c);
                q = q.sum(a, f);
                r = r.multiply(c);
                h = S.multiply((RingElem)a, f);
            }
            r = r.subtract((C)h);
        }
        return q;
    }

    public static <C extends RingElem<C>> GenPolynomial<C>[] basePseudoQuotientRemainder(GenPolynomial<C> P, GenPolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P.toString() + " division by zero " + S);
        }
        GenPolynomial[] ret = new GenPolynomial[]{null, null};
        if (P.isZERO() || S.isONE()) {
            ret[0] = P;
            ret[1] = S.ring.getZERO();
            return ret;
        }
        C c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<Object> r = P;
        GenPolynomial q = ((GenPolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial h;
            C a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            RingElem x = (RingElem)a.remainder(c);
            if (x.isZERO()) {
                RingElem y = (RingElem)a.divide(c);
                q = q.sum(y, f);
                h = S.multiply(y, f);
            } else {
                q = q.multiply(c);
                q = q.sum(a, f);
                r = r.multiply(c);
                h = S.multiply((RingElem)a, f);
            }
            r = r.subtract((C)h);
        }
        ret[0] = q;
        ret[1] = r;
        return ret;
    }

    public static <C extends RingElem<C>> boolean isBasePseudoQuotientRemainder(GenPolynomial<C> P, GenPolynomial<C> S, GenPolynomial<C> q, GenPolynomial<C> r) {
        GenPolynomial<GenPolynomial<RingElem>> rhs = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)S).sum((GenPolynomial<GenPolynomial<C>>)r);
        GenPolynomial<Object> lhs = P;
        C ldcf = S.leadingBaseCoefficient();
        long d = P.degree(0) - S.degree(0) + 1L;
        d = d > 0L ? d : -d + 2L;
        for (long i = 0L; i <= d; ++i) {
            if (lhs.equals(rhs) || ((GenPolynomial)lhs.negate()).equals(rhs)) {
                return true;
            }
            lhs = lhs.multiply(ldcf);
        }
        GenPolynomial<GenPolynomial<RingElem>> Pp = P;
        rhs = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)S);
        for (long i = 0L; i <= d; ++i) {
            lhs = Pp.subtract((GenPolynomial<RingElem>)r);
            if (lhs.equals(rhs) || ((GenPolynomial)lhs.negate()).equals(rhs)) {
                return true;
            }
            Pp = Pp.multiply((GenPolynomial<RingElem>)ldcf);
        }
        GenPolynomial<C> a = P.leadingBaseCoefficient();
        rhs = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)S).sum((GenPolynomial<GenPolynomial<C>>)r);
        GenPolynomial<C> b = rhs.leadingBaseCoefficient();
        GenPolynomial<C> gcd = a.gcd((C)b);
        RingElem p = a.multiply((C)b);
        RingElem lcm = p.divide(gcd);
        RingElem ap = (RingElem)lcm.divide(a);
        RingElem bp = lcm.divide(b);
        return P.multiply((GenPolynomial<RingElem>)ap).equals(rhs.multiply((GenPolynomial<RingElem>)bp));
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        Element p = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m1 : P.getMap().entrySet()) {
            GenPolynomial<C> c1 = m1.getValue();
            ExpVector e1 = m1.getKey();
            GenPolynomial<C> c = PolyUtil.basePseudoDivide(c1, s);
            if (!c.isZERO()) {
                pv.put(e1, c);
                continue;
            }
            System.out.println("rDiv, P  = " + P);
            System.out.println("rDiv, c1 = " + c1);
            System.out.println("rDiv, s  = " + s);
            System.out.println("rDiv, c  = " + c);
            throw new RuntimeException("something is wrong");
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> baseRecursiveDivide(GenPolynomial<GenPolynomial<C>> P, C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException("division by zero " + P + ", " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        if (s.isONE()) {
            return P;
        }
        Element p = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m1 : P.getMap().entrySet()) {
            GenPolynomial<C> c1 = m1.getValue();
            ExpVector e1 = m1.getKey();
            GenPolynomial<C> c = PolyUtil.coefficientBasePseudoDivide(c1, s);
            if (!c.isZERO()) {
                pv.put(e1, c);
                continue;
            }
            System.out.println("pu, c1 = " + c1);
            System.out.println("pu, s  = " + s);
            System.out.println("pu, c  = " + c);
            throw new RuntimeException("something is wrong");
        }
        return p;
    }

    @Deprecated
    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursivePseudoRemainder(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        return PolyUtil.recursiveSparsePseudoRemainder(P, S);
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveSparsePseudoRemainder(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        GenPolynomial<C> c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial<GenPolynomial<C>> h;
            GenPolynomial<C> a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenPolynomial<C> x = c;
            if (x.isZERO()) {
                GenPolynomial<C> y = PolyUtil.basePseudoDivide(a, c);
                h = S.multiply(y, f);
            } else {
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
                h = S.multiply(a, f);
            }
            r = r.subtract(h);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDensePseudoRemainder(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isConstant()) {
            return P.ring.getZERO();
        }
        long m = P.degree(0);
        long n = S.degree(0);
        GenPolynomial<C> c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        for (long i = m; i >= n; --i) {
            if (r.isZERO()) {
                return r;
            }
            long k = r.degree(0);
            if (i == k) {
                ExpVector f = r.leadingExpVector();
                GenPolynomial<C> a = r.leadingBaseCoefficient();
                f = f.subtract(e);
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
                GenPolynomial<GenPolynomial<C>> h = S.multiply(a, f);
                r = r.subtract(h);
                continue;
            }
            r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
        }
        return r;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursivePseudoDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + S);
        }
        if (P == null || P.isZERO()) {
            return P;
        }
        if (S.isONE()) {
            return P;
        }
        GenPolynomial<C> c = S.leadingBaseCoefficient();
        ExpVector e = S.leadingExpVector();
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> r = P;
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> q = ((GenPolynomial)S.ring.getZERO()).copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            GenPolynomial<GenPolynomial<C>> h;
            GenPolynomial<C> a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            GenPolynomial<C> x = PolyUtil.baseSparsePseudoRemainder(a, c);
            if (x.isZERO() && !c.isConstant()) {
                GenPolynomial<C> y = PolyUtil.basePseudoDivide(a, c);
                q = q.sum(y, f);
                h = S.multiply(y, f);
            } else {
                q = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)c);
                q = q.sum(a, f);
                r = r.multiply((GenPolynomial<GenPolynomial<C>>)c);
                h = S.multiply(a, f);
            }
            r = r.subtract(h);
        }
        return q;
    }

    public static <C extends RingElem<C>> boolean isRecursivePseudoQuotientRemainder(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<GenPolynomial<C>> S, GenPolynomial<GenPolynomial<C>> q, GenPolynomial<GenPolynomial<C>> r) {
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<Object>>>> rhs = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>>)S).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)r);
        GenPolynomial<GenPolynomial<Object>> lhs = P;
        GenPolynomial<C> ldcf = S.leadingBaseCoefficient();
        long d = P.degree(0) - S.degree(0) + 1L;
        d = d > 0L ? d : -d + 2L;
        for (long i = 0L; i <= d; ++i) {
            if (lhs.equals(rhs)) {
                return true;
            }
            lhs = lhs.multiply((GenPolynomial<Object>)ldcf);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>> Pp = P;
        rhs = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>>)S);
        for (long i = 0L; i <= d; ++i) {
            lhs = Pp.subtract((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)r);
            if (lhs.equals(rhs)) {
                return true;
            }
            Pp = Pp.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)ldcf);
        }
        GenPolynomial<C> a = P.leadingBaseCoefficient();
        rhs = q.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>>>)S).sum((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)r);
        GenPolynomial<GenPolynomial<C>> b = rhs.leadingBaseCoefficient();
        return P.multiply((GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>>)b).equals(rhs.multiply((GenPolynomial<GenPolynomial<GenPolynomial<Object>>>)((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)a)));
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> coefficientPseudoDivide(GenPolynomial<GenPolynomial<C>> P, GenPolynomial<C> s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        Element p = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : P.getMap().entrySet()) {
            GenPolynomial<C> x;
            ExpVector e = m.getKey();
            GenPolynomial<C> c1 = m.getValue();
            GenPolynomial<C> c = PolyUtil.basePseudoDivide(c1, s);
            if (debug && !(x = c1.remainder(s)).isZERO()) {
                logger.info((Object)("divide x = " + x));
                throw new ArithmeticException(" no exact division: " + c1 + "/" + s);
            }
            if (c.isZERO()) {
                System.out.println(" no exact division: " + c1 + "/" + s);
                continue;
            }
            pv.put(e, c);
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> coefficientBasePseudoDivide(GenPolynomial<C> P, C s) {
        if (s == null || s.isZERO()) {
            throw new ArithmeticException(P + " division by zero " + s);
        }
        if (P.isZERO()) {
            return P;
        }
        Element p = ((GenPolynomial)P.ring.getZERO()).copy();
        SortedMap pv = ((GenPolynomial)p).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            C x;
            ExpVector e = m.getKey();
            RingElem c1 = (RingElem)m.getValue();
            C c = c1.divide(s);
            if (debug && !(x = c1.remainder(s)).isZERO()) {
                logger.info((Object)("divide x = " + x));
                throw new ArithmeticException(" no exact division: " + c1 + "/" + s);
            }
            if (c.isZERO()) {
                System.out.println(" no exact division: " + c1 + "/" + s);
                continue;
            }
            pv.put(e, c);
        }
        return p;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDeriviative(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(0);
            if (fl <= 0L) continue;
            RingElem cf = (RingElem)rf.fromInteger(fl);
            RingElem a = (RingElem)m.getValue();
            RingElem x = a.multiply(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = ExpVector.create(1, 0, fl - 1L);
            dm.put(e, x);
        }
        return d;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseDeriviative(GenPolynomial<C> P, int r) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (r < 0 || pfac.nvar <= r) {
            throw new IllegalArgumentException(P.getClass().getName() + " deriviative variable out of bound " + r);
        }
        int rp = pfac.nvar - 1 - r;
        RingFactory rf = pfac.coFac;
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(rp);
            if (fl <= 0L) continue;
            RingElem cf = (RingElem)rf.fromInteger(fl);
            RingElem a = (RingElem)m.getValue();
            RingElem x = a.multiply(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = f.subst(rp, fl - 1L);
            dm.put(e, x);
        }
        return d;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> baseIntegral(GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory rf = pfac.coFac;
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, C> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(0);
            RingElem cf = (RingElem)rf.fromInteger(++fl);
            RingElem a = (RingElem)m.getValue();
            RingElem x = a.divide(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = ExpVector.create(1, 0, fl);
            dm.put(e, x);
        }
        return d;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> recursiveDeriviative(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null || P.isZERO()) {
            return P;
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException(P.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing pr = (GenPolynomialRing)pfac.coFac;
        RingFactory rf = pr.coFac;
        Element d = ((GenPolynomial)pfac.getZERO()).copy();
        SortedMap dm = ((GenPolynomial)d).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : P.getMap().entrySet()) {
            ExpVector f = m.getKey();
            long fl = f.getVal(0);
            if (fl <= 0L) continue;
            RingElem cf = (RingElem)rf.fromInteger(fl);
            GenPolynomial<RingElem> a = m.getValue();
            GenPolynomial<RingElem> x = a.multiply(cf);
            if (x == null || x.isZERO()) continue;
            ExpVector e = ExpVector.create(1, 0, fl - 1L);
            dm.put(e, x);
        }
        return d;
    }

    public static edu.jas.arith.BigInteger factorBound(ExpVector e) {
        BigInteger v;
        int n = 0;
        BigInteger p = BigInteger.ONE;
        if (e == null || e.isZERO()) {
            return edu.jas.arith.BigInteger.ONE;
        }
        for (int i = 0; i < e.length(); ++i) {
            if (e.getVal(i) <= 0L) continue;
            n = (int)((long)n + (2L * e.getVal(i) - 1L));
            v = new BigInteger("" + (e.getVal(i) - 1L));
            p = p.multiply(v);
        }
        n += p.bitCount() + 1;
        v = new BigInteger("2");
        v = v.shiftLeft(n /= 2);
        edu.jas.arith.BigInteger N = new edu.jas.arith.BigInteger(v);
        return N;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateMainRecursive(GenPolynomialRing<C> cfac, GenPolynomial<GenPolynomial<C>> A, C a) {
        if (A == null || A.isZERO()) {
            return cfac.getZERO();
        }
        if (A.ring.nvar != 1) {
            throw new IllegalArgumentException("evaluateMain no univariate polynomial");
        }
        if (a == null || a.isZERO()) {
            return A.trailingBaseCoefficient();
        }
        SortedMap<ExpVector, GenPolynomial<C>> val = A.getMap();
        GenPolynomial<Object> B = null;
        long el1 = -1L;
        long el2 = -1L;
        for (Map.Entry me : val.entrySet()) {
            ExpVector e = (ExpVector)me.getKey();
            el2 = e.getVal(0);
            if (B == null) {
                B = (GenPolynomial<C>)me.getValue();
            } else {
                for (long i = el2; i < el1; ++i) {
                    B = B.multiply((Object)a);
                }
                B = B.sum((Object)((GenPolynomial)me.getValue()));
            }
            el1 = el2;
        }
        for (long i = 0L; i < el2; ++i) {
            B = B.multiply((Object)a);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateMain(GenPolynomialRing<C> cfac, GenPolynomial<C> A, C a) {
        if (A == null || A.isZERO()) {
            return cfac.getZERO();
        }
        GenPolynomialRing<GenPolynomial<C>> rfac = new GenPolynomialRing<GenPolynomial<C>>(cfac, 1);
        if (rfac.nvar + cfac.nvar != A.ring.nvar) {
            throw new IllegalArgumentException("evaluateMain number of variabes mismatch");
        }
        GenPolynomial<GenPolynomial<C>> Ap = PolyUtil.recursive(rfac, A);
        return PolyUtil.evaluateMainRecursive(cfac, Ap, a);
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> evaluateMain(GenPolynomialRing<C> cfac, List<GenPolynomial<C>> L, C a) {
        return ListUtil.map(L, new EvalMainPol<C>(cfac, a));
    }

    public static <C extends RingElem<C>> C evaluateMain(RingFactory<C> cfac, GenPolynomial<C> A, C a) {
        if (A == null || A.isZERO()) {
            return (C)((RingElem)cfac.getZERO());
        }
        if (A.ring.nvar != 1) {
            throw new IllegalArgumentException("evaluateMain no univariate polynomial");
        }
        if (a == null || a.isZERO()) {
            return A.trailingBaseCoefficient();
        }
        SortedMap<ExpVector, C> val = A.getMap();
        MonoidElem<AbelianGroupElem> B = null;
        long el1 = -1L;
        long el2 = -1L;
        for (Map.Entry me : val.entrySet()) {
            ExpVector e = (ExpVector)me.getKey();
            el2 = e.getVal(0);
            if (B == null) {
                B = (RingElem)me.getValue();
            } else {
                for (long i = el2; i < el1; ++i) {
                    B = (RingElem)B.multiply(a);
                }
                B = (RingElem)B.sum((AbelianGroupElem)me.getValue());
            }
            el1 = el2;
        }
        for (long i = 0L; i < el2; ++i) {
            B = B.multiply(a);
        }
        return (C)B;
    }

    public static <C extends RingElem<C>> List<C> evaluateMain(RingFactory<C> cfac, List<GenPolynomial<C>> L, C a) {
        return ListUtil.map(L, new EvalMain<C>(cfac, a));
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluate(GenPolynomialRing<C> cfac, GenPolynomialRing<GenPolynomial<C>> rfac, GenPolynomialRing<GenPolynomial<C>> nfac, GenPolynomialRing<C> dfac, GenPolynomial<C> A, C a) {
        if (rfac.nvar != 1) {
            throw new IllegalArgumentException("evaluate coefficient ring not univariate");
        }
        if (A == null || A.isZERO()) {
            return cfac.getZERO();
        }
        Map<ExpVector, GenPolynomial<C>> Ap = A.contract(cfac);
        GenPolynomialRing rcf = (GenPolynomialRing)rfac.coFac;
        Element Ev = ((GenPolynomial)nfac.getZERO()).copy();
        SortedMap Evm = ((GenPolynomial)Ev).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : Ap.entrySet()) {
            ExpVector e = m.getKey();
            GenPolynomial<C> b = m.getValue();
            GenPolynomial<GenPolynomial<C>> c = PolyUtil.recursive(rfac, b);
            GenPolynomial<C> d = PolyUtil.evaluateMainRecursive(rcf, c, a);
            if (d == null || d.isZERO()) continue;
            Evm.put(e, d);
        }
        GenPolynomial<C> B = PolyUtil.distribute(dfac, Ev);
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateFirst(GenPolynomialRing<C> cfac, GenPolynomialRing<C> dfac, GenPolynomial<C> A, C a) {
        if (A == null || A.isZERO()) {
            return dfac.getZERO();
        }
        Map<ExpVector, GenPolynomial<C>> Ap = A.contract(cfac);
        Element B = ((GenPolynomial)dfac.getZERO()).copy();
        SortedMap Bm = ((GenPolynomial)B).val;
        for (Map.Entry<ExpVector, GenPolynomial<C>> m : Ap.entrySet()) {
            ExpVector e = m.getKey();
            GenPolynomial<C> b = m.getValue();
            Object d = PolyUtil.evaluateMain(cfac.coFac, b, a);
            if (d == null || d.isZERO()) continue;
            Bm.put(e, d);
        }
        return B;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> evaluateFirstRec(GenPolynomialRing<C> cfac, GenPolynomialRing<C> dfac, GenPolynomial<GenPolynomial<C>> A, C a) {
        if (A == null || A.isZERO()) {
            return dfac.getZERO();
        }
        SortedMap<ExpVector, GenPolynomial<C>> Ap = A.getMap();
        Element B = ((GenPolynomial)dfac.getZERO()).copy();
        SortedMap Bm = ((GenPolynomial)B).val;
        for (Map.Entry m : Ap.entrySet()) {
            ExpVector e = (ExpVector)m.getKey();
            GenPolynomial b = (GenPolynomial)m.getValue();
            Object d = PolyUtil.evaluateMain(cfac.coFac, b, a);
            if (d == null || d.isZERO()) continue;
            Bm.put(e, d);
        }
        return B;
    }

    @Deprecated
    public static <C extends RingElem<C>> C evaluateAll(RingFactory<C> cfac, GenPolynomialRing<C> dfac, GenPolynomial<C> A, List<C> a) {
        return PolyUtil.evaluateAll(cfac, A, a);
    }

    public static <C extends RingElem<C>> C evaluateAll(RingFactory<C> cfac, GenPolynomial<C> A, List<C> a) {
        if (A == null || A.isZERO()) {
            return (C)((RingElem)cfac.getZERO());
        }
        GenPolynomialRing dfac = A.ring;
        if (a == null || a.size() != dfac.nvar) {
            throw new IllegalArgumentException("evaluate tuple size not equal to number of variables");
        }
        if (dfac.nvar == 0) {
            return A.trailingBaseCoefficient();
        }
        if (dfac.nvar == 1) {
            return (C)PolyUtil.evaluateMain(cfac, A, (RingElem)a.get(0));
        }
        RingElem b = (RingElem)cfac.getZERO();
        GenPolynomial<Object> Ap = A;
        for (int k = 0; k < dfac.nvar - 1; ++k) {
            GenPolynomialRing<C> c1fac = new GenPolynomialRing<C>(cfac, 1);
            GenPolynomialRing<C> cnfac = new GenPolynomialRing<C>(cfac, dfac.nvar - 1 - k);
            RingElem ap = (RingElem)a.get(k);
            GenPolynomial<RingElem> Bp = PolyUtil.evaluateFirst(c1fac, cnfac, Ap, ap);
            if (Bp.isZERO()) {
                return (C)b;
            }
            Ap = Bp;
        }
        RingElem ap = (RingElem)a.get(dfac.nvar - 1);
        b = PolyUtil.evaluateMain(cfac, Ap, ap);
        return (C)b;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> substituteMain(GenPolynomial<C> A, GenPolynomial<C> s) {
        return PolyUtil.substituteUnivariate(A, s);
    }

    public static <C extends RingElem<C>> GenPolynomial<C> substituteUnivariate(GenPolynomial<C> f, GenPolynomial<C> t) {
        if (f == null || t == null) {
            return null;
        }
        GenPolynomialRing fac = f.ring;
        if (fac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomial f");
        }
        if (f.isZERO() || f.isConstant()) {
            return f;
        }
        if (t.ring.nvar > 1) {
            fac = t.ring;
        }
        SortedMap<ExpVector, C> val = f.getMap();
        GenPolynomial<RingElem<GenPolynomial<RingElem>>> s = null;
        long el1 = -1L;
        long el2 = -1L;
        for (Map.Entry me : val.entrySet()) {
            ExpVector e = (ExpVector)me.getKey();
            el2 = e.getVal(0);
            if (s == null) {
                s = ((GenPolynomial)fac.getZERO()).sum((RingElem)me.getValue());
            } else {
                for (long i = el2; i < el1; ++i) {
                    s = s.multiply((RingElem<GenPolynomial<RingElem>>)t);
                }
                s = s.sum((RingElem)me.getValue());
            }
            el1 = el2;
        }
        for (long i = 0L; i < el2; ++i) {
            s = s.multiply((RingElem<GenPolynomial<RingElem>>)t);
        }
        return s;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> seriesOfTaylor(GenPolynomial<C> f, C a) {
        if (f == null) {
            return null;
        }
        GenPolynomialRing fac = f.ring;
        if (fac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        if (f.isZERO() || f.isConstant()) {
            return f;
        }
        GenPolynomial s = fac.getZERO();
        Object fa = PolyUtil.evaluateMain(fac.coFac, f, a);
        s = s.sum(fa);
        long n = 1L;
        long i = 0L;
        GenPolynomial<C> g = PolyUtil.baseDeriviative(f);
        while (!g.isZERO()) {
            fa = PolyUtil.evaluateMain(fac.coFac, g, a);
            GenPolynomial q = fac.univariate(0, i);
            q = q.multiply(fa);
            q = q.divide(fac.fromInteger(n *= ++i));
            s = s.sum(q);
            g = PolyUtil.baseDeriviative(g);
        }
        return s;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> interpolate(GenPolynomialRing<GenPolynomial<C>> fac, GenPolynomial<GenPolynomial<C>> A, GenPolynomial<C> M, C mi, GenPolynomial<C> B, C am) {
        ExpVector e;
        Element S = ((GenPolynomial)fac.getZERO()).copy();
        Element Ap = A.copy();
        SortedMap av = ((GenPolynomial)Ap).val;
        SortedMap<ExpVector, C> bv = B.getMap();
        SortedMap sv = ((GenPolynomial)S).val;
        GenPolynomialRing cfac = (GenPolynomialRing)fac.coFac;
        RingFactory bfac = cfac.coFac;
        GenPolynomial<RingElem> c = null;
        for (Map.Entry<ExpVector, C> me : bv.entrySet()) {
            e = me.getKey();
            RingElem y = (RingElem)me.getValue();
            GenPolynomial x = (GenPolynomial)av.get(e);
            if (x != null) {
                av.remove(e);
                c = PolyUtil.interpolate(cfac, x, M, mi, y, am);
                if (c.isZERO()) continue;
                sv.put(e, c);
                continue;
            }
            c = PolyUtil.interpolate(cfac, cfac.getZERO(), M, mi, y, am);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        for (Map.Entry<ExpVector, C> me : av.entrySet()) {
            e = me.getKey();
            GenPolynomial x = (GenPolynomial)me.getValue();
            c = PolyUtil.interpolate(cfac, x, M, mi, (RingElem)bfac.getZERO(), am);
            if (c.isZERO()) continue;
            sv.put(e, c);
        }
        return S;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> interpolate(GenPolynomialRing<C> fac, GenPolynomial<C> A, GenPolynomial<C> M, C mi, C a, C am) {
        Object b = PolyUtil.evaluateMain(fac.coFac, A, am);
        RingElem d = (RingElem)a.subtract(b);
        if (d.isZERO()) {
            return A;
        }
        b = d.multiply(mi);
        GenPolynomial<GenPolynomial<C>> s = M.multiply(b);
        s = s.sum(A);
        return s;
    }

    public static <C extends RingElem<C>> GenPolynomial<GenPolynomial<C>> switchVariables(GenPolynomial<GenPolynomial<C>> P) {
        if (P == null) {
            throw new IllegalArgumentException("P == null");
        }
        GenPolynomialRing rfac1 = P.ring;
        GenPolynomialRing cfac1 = (GenPolynomialRing)rfac1.coFac;
        GenPolynomialRing cfac2 = new GenPolynomialRing(cfac1.coFac, rfac1);
        AbelianGroupElem zero = cfac2.getZERO();
        GenPolynomialRing rfac2 = new GenPolynomialRing(cfac2, cfac1);
        GenPolynomial B = ((GenPolynomial)rfac2.getZERO()).copy();
        if (P.isZERO()) {
            return B;
        }
        for (Monomial<GenPolynomial<C>> monomial : P) {
            GenPolynomial cr = (GenPolynomial)monomial.c;
            for (Monomial mc : cr) {
                GenPolynomial c = ((GenPolynomial)zero).sum(mc.c, monomial.e);
                B = B.sum(c, mc.e);
            }
        }
        return B;
    }

    public static <C extends RingElem<C>> long totalDegreeLeadingTerm(List<GenPolynomial<C>> P) {
        long degree = 0L;
        for (GenPolynomial<C> g : P) {
            long total = g.leadingExpVector().totalDeg();
            if (degree >= total) continue;
            degree = total;
        }
        return degree;
    }

    public static <C extends RingElem<C>> long totalDegree(List<GenPolynomial<C>> P) {
        long degree = 0L;
        for (GenPolynomial<C> g : P) {
            long total = g.degree();
            if (degree >= total) continue;
            degree = total;
        }
        return degree;
    }

    public static <C extends RingElem<C>> long coeffMaxDegree(GenPolynomial<GenPolynomial<C>> A) {
        if (A.isZERO()) {
            return 0L;
        }
        long deg = 0L;
        for (GenPolynomial<C> a : A.getMap().values()) {
            long d = a.degree();
            if (d <= deg) continue;
            deg = d;
        }
        return deg;
    }

    public static <C extends RingElem<C>, D extends RingElem<D>> GenPolynomial<D> map(GenPolynomialRing<D> ring, GenPolynomial<C> p, UnaryFunctor<C, D> f) {
        Element n = ((GenPolynomial)ring.getZERO()).copy();
        SortedMap nv = ((GenPolynomial)n).val;
        for (Monomial<C> m : p) {
            RingElem c = (RingElem)f.eval(m.c);
            if (c == null || c.isZERO()) continue;
            nv.put(m.e, c);
        }
        return n;
    }

    public static <C extends GcdRingElem<C>> List<GenPolynomial<Product<C>>> toProductGen(GenPolynomialRing<Product<C>> pfac, List<GenPolynomial<C>> L) {
        ArrayList<GenPolynomial<Product<C>>> list = new ArrayList<GenPolynomial<Product<C>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<C> a : L) {
            GenPolynomial<Product<C>> b = PolyUtil.toProductGen(pfac, a);
            list.add(b);
        }
        return list;
    }

    public static <C extends GcdRingElem<C>> GenPolynomial<Product<C>> toProductGen(GenPolynomialRing<Product<C>> pfac, GenPolynomial<C> A) {
        Element P = ((GenPolynomial)pfac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return P;
        }
        RingFactory rpfac = pfac.coFac;
        ProductRing rfac = (ProductRing)rpfac;
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            GcdRingElem a = (GcdRingElem)y.getValue();
            Product<GcdRingElem> p = PolyUtil.toProductGen(rfac, a);
            if (p.isZERO()) continue;
            ((GenPolynomial)P).doPutToMap(e, p);
        }
        return P;
    }

    public static <C extends GcdRingElem<C>> Product<C> toProductGen(ProductRing<C> pfac, C c) {
        TreeMap<Integer, C> elem = new TreeMap<Integer, C>();
        for (int i = 0; i < pfac.length(); ++i) {
            RingFactory<C> rfac = pfac.getFactory(i);
            C u = rfac.copy(c);
            if (u == null || u.isZERO()) continue;
            elem.put(i, u);
        }
        return new Product<C>(pfac, elem);
    }

    public static <C extends RingElem<C>> Product<GenPolynomial<C>> toProduct(ProductRing<GenPolynomial<C>> pfac, C c, ExpVector e) {
        TreeMap<Integer, GenPolynomial<C>> elem = new TreeMap<Integer, GenPolynomial<C>>();
        for (int i = 0; i < e.length(); ++i) {
            RingFactory<GenPolynomial<C>> rfac = pfac.getFactory(i);
            GenPolynomialRing fac = (GenPolynomialRing)rfac;
            long a = e.getVal(i);
            GenPolynomial<C> u = a == 0L ? fac.getONE() : fac.univariate(0, a);
            u = u.multiply(c);
            elem.put(i, u);
        }
        return new Product<GenPolynomial<C>>(pfac, elem);
    }

    public static <C extends RingElem<C>> Product<GenPolynomial<C>> toProduct(ProductRing<GenPolynomial<C>> pfac, GenPolynomial<C> A) {
        Product<GenPolynomial<RingElem>> P = pfac.getZERO();
        if (A == null || A.isZERO()) {
            return P;
        }
        for (Map.Entry<ExpVector, C> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            RingElem a = (RingElem)y.getValue();
            Product<GenPolynomial<RingElem>> p = PolyUtil.toProduct(pfac, a, e);
            P = P.sum(p);
        }
        return P;
    }

    public static Product<ModInteger> toProduct(ProductRing<ModInteger> pfac, edu.jas.arith.BigInteger c) {
        TreeMap<Integer, ModInteger> elem = new TreeMap<Integer, ModInteger>();
        for (int i = 0; i < pfac.length(); ++i) {
            RingFactory<ModInteger> rfac = pfac.getFactory(i);
            ModIntegerRing fac = (ModIntegerRing)rfac;
            ModInteger u = fac.fromInteger(c.getVal());
            if (u.isZERO()) continue;
            elem.put(i, u);
        }
        return new Product<ModInteger>(pfac, elem);
    }

    public static GenPolynomial<Product<ModInteger>> toProduct(GenPolynomialRing<Product<ModInteger>> pfac, GenPolynomial<edu.jas.arith.BigInteger> A) {
        Element P = ((GenPolynomial)pfac.getZERO()).copy();
        if (A == null || A.isZERO()) {
            return P;
        }
        RingFactory rpfac = pfac.coFac;
        ProductRing fac = (ProductRing)rpfac;
        for (Map.Entry<ExpVector, edu.jas.arith.BigInteger> y : A.getMap().entrySet()) {
            ExpVector e = y.getKey();
            edu.jas.arith.BigInteger a = y.getValue();
            Product<ModInteger> p = PolyUtil.toProduct(fac, a);
            if (p.isZERO()) continue;
            ((GenPolynomial)P).doPutToMap(e, p);
        }
        return P;
    }

    public static List<GenPolynomial<Product<ModInteger>>> toProduct(GenPolynomialRing<Product<ModInteger>> pfac, List<GenPolynomial<edu.jas.arith.BigInteger>> L) {
        ArrayList<GenPolynomial<Product<ModInteger>>> list = new ArrayList<GenPolynomial<Product<ModInteger>>>();
        if (L == null || L.size() == 0) {
            return list;
        }
        for (GenPolynomial<edu.jas.arith.BigInteger> a : L) {
            GenPolynomial<Product<ModInteger>> b = PolyUtil.toProduct(pfac, a);
            list.add(b);
        }
        return list;
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> intersect(GenPolynomialRing<C> R, List<GenPolynomial<C>> F) {
        if (F == null || F.isEmpty()) {
            return F;
        }
        GenPolynomialRing pfac = F.get((int)0).ring;
        int d = pfac.nvar - R.nvar;
        if (d <= 0) {
            return F;
        }
        ArrayList<GenPolynomial<C>> H = new ArrayList<GenPolynomial<C>>(F.size());
        for (GenPolynomial<C> p : F) {
            Map<ExpVector, GenPolynomial<C>> m = null;
            m = p.contract(R);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("intersect contract m = " + m));
            }
            if (m.size() != 1) continue;
            for (Map.Entry<ExpVector, GenPolynomial<C>> me : m.entrySet()) {
                ExpVector e = me.getKey();
                if (!e.isZERO()) continue;
                H.add(me.getValue());
            }
        }
        GenPolynomialRing tfac = pfac.contract(d);
        if (tfac.equals(R)) {
            return H;
        }
        logger.warn((Object)("tfac != R: tfac = " + tfac.toScript() + ", R = " + R.toScript()));
        return H;
    }

    public static <C extends RingElem<C>> List<GenSolvablePolynomial<C>> intersect(GenSolvablePolynomialRing<C> R, List<GenSolvablePolynomial<C>> F) {
        List<GenPolynomial<C>> Fp = PolynomialList.castToList(F);
        GenSolvablePolynomialRing<C> Rp = R;
        List<GenPolynomial<C>> H = PolyUtil.intersect(Rp, Fp);
        return PolynomialList.castToSolvableList(H);
    }

    public static <C extends RingElem<C>> GenPolynomial<C> removeUnusedUpperVariables(GenPolynomial<C> p) {
        GenPolynomialRing fac = p.ring;
        if (fac.nvar <= 1) {
            return p;
        }
        int[] dep = p.degreeVector().dependencyOnVariables();
        if (fac.nvar == dep.length) {
            return p;
        }
        if (dep.length == 0) {
            GenPolynomialRing fac0 = new GenPolynomialRing(fac.coFac, 0);
            GenPolynomial p0 = new GenPolynomial(fac0, p.leadingBaseCoefficient());
            return p0;
        }
        int l = dep[0];
        int r = dep[dep.length - 1];
        if (l == 0) {
            return p;
        }
        int n = l;
        GenPolynomialRing facr = fac.contract(n);
        Map<ExpVector, GenPolynomial<C>> mpr = p.contract(facr);
        if (mpr.size() != 1) {
            System.out.println("upper ex, l = " + l + ", r = " + r + ", p = " + p + ", fac = " + fac.toScript());
            throw new RuntimeException("this should not happen " + mpr);
        }
        GenPolynomial<C> pr = mpr.values().iterator().next();
        n = fac.nvar - 1 - r;
        if (n == 0) {
            return pr;
        }
        return pr;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> removeUnusedLowerVariables(GenPolynomial<C> p) {
        GenPolynomialRing fac = p.ring;
        if (fac.nvar <= 1) {
            return p;
        }
        int[] dep = p.degreeVector().dependencyOnVariables();
        if (fac.nvar == dep.length) {
            return p;
        }
        if (dep.length == 0) {
            GenPolynomialRing fac0 = new GenPolynomialRing(fac.coFac, 0);
            GenPolynomial p0 = new GenPolynomial(fac0, p.leadingBaseCoefficient());
            return p0;
        }
        int l = dep[0];
        int r = dep[dep.length - 1];
        if (r == fac.nvar - 1) {
            return p;
        }
        int n = r + 1;
        GenPolynomialRing rfac = fac.recursive(n);
        GenPolynomial mpr = PolyUtil.recursive(rfac, p);
        if (mpr.length() != p.length()) {
            System.out.println("lower ex, l = " + l + ", r = " + r + ", p = " + p + ", fac = " + fac.toScript());
            throw new RuntimeException("this should not happen " + mpr);
        }
        RingFactory cf = fac.coFac;
        GenPolynomialRing facl = new GenPolynomialRing(cf, rfac);
        Element pr = ((GenPolynomial)facl.getZERO()).copy();
        for (Monomial monomial : mpr) {
            ExpVector e = monomial.e;
            GenPolynomial a = (GenPolynomial)monomial.c;
            if (!a.isConstant()) {
                throw new RuntimeException("this can not happen " + a);
            }
            Object c = a.leadingBaseCoefficient();
            ((GenPolynomial)pr).doPutToMap(e, c);
        }
        return pr;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> removeUnusedMiddleVariables(GenPolynomial<C> p) {
        GenPolynomialRing fac = p.ring;
        if (fac.nvar <= 2) {
            return p;
        }
        int[] dep = p.degreeVector().dependencyOnVariables();
        if (fac.nvar == dep.length) {
            return p;
        }
        if (dep.length == 0) {
            GenPolynomialRing fac0 = new GenPolynomialRing(fac.coFac, 0);
            GenPolynomial p0 = new GenPolynomial(fac0, p.leadingBaseCoefficient());
            return p0;
        }
        ExpVector e1 = p.leadingExpVector();
        if (dep.length == 1) {
            TermOrder to = new TermOrder(fac.tord.getEvord());
            int i = dep[0];
            String v1 = e1.indexVarName(i, fac.getVars());
            String[] vars = new String[]{v1};
            GenPolynomialRing fac1 = new GenPolynomialRing(fac.coFac, to, vars);
            Element p1 = ((GenPolynomial)fac1.getZERO()).copy();
            for (Monomial<C> m : p) {
                ExpVector e = m.e;
                ExpVector f = ExpVector.create(1, 0, e.getVal(i));
                ((GenPolynomial)p1).doPutToMap(f, m.c);
            }
            return p1;
        }
        GenPolynomialRing rfac = fac.recursive(1);
        GenPolynomial mpr = PolyUtil.recursive(rfac, p);
        int l = dep[0];
        int r = fac.nvar - dep[1];
        TermOrder to = new TermOrder(fac.tord.getEvord());
        String[] vs = fac.getVars();
        String[] vars = new String[r + 1];
        for (int i = 0; i < r; ++i) {
            vars[i] = vs[i];
        }
        vars[r] = e1.indexVarName(l, vs);
        GenPolynomialRing dfac = new GenPolynomialRing(fac.coFac, to, vars);
        GenPolynomialRing fac2 = dfac.recursive(1);
        GenPolynomialRing cfac = (GenPolynomialRing)fac2.coFac;
        Element p2r = ((GenPolynomial)fac2.getZERO()).copy();
        for (Monomial monomial : mpr) {
            ExpVector e = monomial.e;
            GenPolynomial a = (GenPolynomial)monomial.c;
            Map cc = a.contract(cfac);
            for (Map.Entry me : cc.entrySet()) {
                ExpVector f = me.getKey();
                if (f.isZERO()) {
                    GenPolynomial c = me.getValue();
                    ((GenPolynomial)p2r).doPutToMap(e, c);
                    continue;
                }
                throw new RuntimeException("this should not happen " + cc);
            }
        }
        GenPolynomial p2 = PolyUtil.distribute(dfac, p2r);
        return p2;
    }

    public static <C extends RingElem<C>> GenPolynomial<C> selectWithVariable(List<GenPolynomial<C>> P, int i) {
        for (GenPolynomial<C> p : P) {
            int[] dep = p.leadingExpVector().dependencyOnVariables();
            if (dep.length != 1 || dep[0] != i) continue;
            return p;
        }
        return null;
    }
}

