/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.TableRelation;
import edu.jas.structure.NotInvertibleException;
import edu.jas.structure.RingElem;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class GenSolvablePolynomial<C extends RingElem<C>>
extends GenPolynomial<C> {
    public final GenSolvablePolynomialRing<C> ring;
    private static final Logger logger = Logger.getLogger(GenSolvablePolynomial.class);
    private final boolean debug = false;

    public GenSolvablePolynomial(GenSolvablePolynomialRing<C> r) {
        super(r);
        this.ring = r;
    }

    public GenSolvablePolynomial(GenSolvablePolynomialRing<C> r, C c, ExpVector e) {
        this(r);
        if (c != null && !c.isZERO()) {
            this.val.put(e, c);
        }
    }

    public GenSolvablePolynomial(GenSolvablePolynomialRing<C> r, C c) {
        this(r, c, r.evzero);
    }

    protected GenSolvablePolynomial(GenSolvablePolynomialRing<C> r, SortedMap<ExpVector, C> v) {
        this(r);
        this.val.putAll(v);
    }

    @Override
    public GenSolvablePolynomialRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenSolvablePolynomial<C> copy() {
        return new GenSolvablePolynomial<C>(this.ring, this.val);
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof GenSolvablePolynomial)) {
            return false;
        }
        return super.equals(B);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(GenSolvablePolynomial<C> Bp) {
        if (Bp == null || Bp.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.ring.nvar == Bp.ring.nvar);
        if (this instanceof RecSolvablePolynomial || Bp instanceof RecSolvablePolynomial) {
            logger.info((Object)"warn: wrong method dispatch in JRE multiply(Bp) - trying to fix");
            RecSolvablePolynomial T = (RecSolvablePolynomial)this;
            RecSolvablePolynomial Sp = (RecSolvablePolynomial)Bp;
            return T.multiply(Sp);
        }
        ExpVector Z = this.ring.evzero;
        GenPolynomial Cp = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        GenPolynomial zero = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        Object one = this.ring.getONECoefficient();
        GenSolvablePolynomial C1 = null;
        GenSolvablePolynomial C2 = null;
        SortedMap A = this.val;
        SortedMap B = Bp.val;
        Set Bk = B.entrySet();
        for (Map.Entry y : A.entrySet()) {
            RingElem a = (RingElem)y.getValue();
            ExpVector e = (ExpVector)y.getKey();
            int[] ep = e.dependencyOnVariables();
            int el1 = this.ring.nvar + 1;
            if (ep.length > 0) {
                el1 = ep[0];
            }
            int el1s = this.ring.nvar + 1 - el1;
            for (Map.Entry x : Bk) {
                RingElem b = (RingElem)x.getValue();
                ExpVector f = (ExpVector)x.getKey();
                int[] fp = f.dependencyOnVariables();
                int fl1 = 0;
                if (fp.length > 0) {
                    fl1 = fp[fp.length - 1];
                }
                int fl1s = this.ring.nvar + 1 - fl1;
                GenSolvablePolynomial<RingElem<GenSolvablePolynomial>> Cs = null;
                if (el1s <= fl1s) {
                    ExpVector g = e.sum(f);
                    Cs = (GenSolvablePolynomial<RingElem>)zero.sum(one, g);
                } else {
                    ExpVector e1 = e.subst(el1, 0L);
                    ExpVector e2 = Z.subst(el1, e.getVal(el1));
                    ExpVector f1 = f.subst(fl1, 0L);
                    ExpVector f2 = Z.subst(fl1, f.getVal(fl1));
                    TableRelation rel = this.ring.table.lookup(e2, f2);
                    Cs = rel.p;
                    if (rel.f != null) {
                        C2 = (GenSolvablePolynomial)zero.sum(one, rel.f);
                        Cs = Cs.multiply((RingElem)C2);
                        ExpVector e4 = rel.e == null ? e2 : e2.subtract(rel.e);
                        this.ring.table.update(e4, f2, Cs);
                    }
                    if (rel.e != null) {
                        C1 = (GenSolvablePolynomial)zero.sum(one, rel.e);
                        Cs = C1.multiply((C)Cs);
                        this.ring.table.update(e2, f2, Cs);
                    }
                    if (!f1.isZERO()) {
                        C2 = (GenSolvablePolynomial)zero.sum(one, f1);
                        Cs = Cs.multiply((RingElem<GenSolvablePolynomial>)C2);
                    }
                    if (!e1.isZERO()) {
                        C1 = (GenSolvablePolynomial)zero.sum(one, e1);
                        Cs = C1.multiply((C)Cs);
                    }
                }
                Cs = Cs.multiply(a, b);
                Cp = (GenSolvablePolynomial)Cp.sum(Cs);
            }
        }
        return Cp;
    }

    public GenSolvablePolynomial<C> multiply(GenSolvablePolynomial<C> S, GenSolvablePolynomial<C> T) {
        if (S.isZERO() || T.isZERO() || this.isZERO()) {
            return this.ring.getZERO();
        }
        if (S.isONE()) {
            return this.multiply((C)T);
        }
        if (T.isONE()) {
            return S.multiply(this);
        }
        return S.multiply(this).multiply(T);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(C b) {
        GenPolynomial Cp = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((GenSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            RingElem c = (RingElem)a.multiply(b);
            if (c.isZERO()) continue;
            Cm.put(e, c);
        }
        return Cp;
    }

    public GenSolvablePolynomial<C> multiply(C b, C c) {
        GenPolynomial Cp = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        if (c == null || c.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((GenSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            RingElem d = (RingElem)b.multiply((RingElem)a).multiply(c);
            if (d.isZERO()) continue;
            Cm.put(e, d);
        }
        return Cp;
    }

    @Override
    public GenSolvablePolynomial<C> multiply(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        Object b = this.ring.getONECoefficient();
        return this.multiply((RingElem)b, e);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(ExpVector e, ExpVector f) {
        if (e == null || e.isZERO()) {
            return this;
        }
        if (f == null || f.isZERO()) {
            return this;
        }
        Object b = this.ring.getONECoefficient();
        return this.multiply(b, e, b, f);
    }

    @Override
    public GenSolvablePolynomial<C> multiply(C b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        GenSolvablePolynomial<C> Cp = new GenSolvablePolynomial<C>(this.ring, b, e);
        return this.multiply((C)Cp);
    }

    public GenSolvablePolynomial<C> multiply(C b, ExpVector e, C c, ExpVector f) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        GenSolvablePolynomial<C> Cp = new GenSolvablePolynomial<C>(this.ring, b, e);
        GenSolvablePolynomial<C> Dp = new GenSolvablePolynomial<C>(this.ring, c, f);
        return this.multiply((C)Cp, (C)Dp);
    }

    public GenSolvablePolynomial<C> multiplyLeft(C b, ExpVector e) {
        if (b == null || b.isZERO()) {
            return this.ring.getZERO();
        }
        GenSolvablePolynomial<GenSolvablePolynomial> Cp = new GenSolvablePolynomial<GenSolvablePolynomial>((GenSolvablePolynomialRing<GenSolvablePolynomial>)this.ring, (GenSolvablePolynomial)b, e);
        return Cp.multiply(this);
    }

    public GenSolvablePolynomial<C> multiplyLeft(ExpVector e) {
        if (e == null || e.isZERO()) {
            return this;
        }
        Object b = this.ring.getONECoefficient();
        GenSolvablePolynomial<GenSolvablePolynomial> Cp = new GenSolvablePolynomial<GenSolvablePolynomial>((GenSolvablePolynomialRing<GenSolvablePolynomial>)this.ring, (GenSolvablePolynomial)b, e);
        return Cp.multiply(this);
    }

    public GenSolvablePolynomial<C> multiplyLeft(C b) {
        GenPolynomial Cp = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        if (b == null || b.isZERO()) {
            return Cp;
        }
        SortedMap Cm = ((GenSolvablePolynomial)Cp).val;
        SortedMap Am = this.val;
        for (Map.Entry y : Am.entrySet()) {
            ExpVector e = (ExpVector)y.getKey();
            RingElem a = (RingElem)y.getValue();
            RingElem c = b.multiply((RingElem)a);
            if (c.isZERO()) continue;
            Cm.put(e, c);
        }
        return Cp;
    }

    public GenSolvablePolynomial<C> multiplyLeft(Map.Entry<ExpVector, C> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiplyLeft((RingElem)m.getValue(), m.getKey());
    }

    @Override
    public GenSolvablePolynomial<C> multiply(Map.Entry<ExpVector, C> m) {
        if (m == null) {
            return this.ring.getZERO();
        }
        return this.multiply((RingElem)m.getValue(), m.getKey());
    }

    @Override
    public GenSolvablePolynomial<C> monic() {
        if (this.isZERO()) {
            return this;
        }
        Object lc = this.leadingBaseCoefficient();
        if (!lc.isUnit()) {
            return this;
        }
        try {
            RingElem lm = (RingElem)lc.inverse();
            return this.multiplyLeft(lm);
        }
        catch (NotInvertibleException notInvertibleException) {
            return this;
        }
    }

    public GenSolvablePolynomial<C>[] quotientRemainder(GenSolvablePolynomial<C> S) {
        ExpVector f;
        if (S == null || S.isZERO()) {
            throw new ArithmeticException("division by zero");
        }
        Object c = S.leadingBaseCoefficient();
        if (!c.isUnit()) {
            throw new ArithmeticException("lbcf not invertible " + c);
        }
        RingElem ci = (RingElem)c.inverse();
        assert (this.ring.nvar == S.ring.nvar);
        ExpVector e = S.leadingExpVector();
        GenPolynomial q = ((GenSolvablePolynomial)this.ring.getZERO()).copy();
        GenPolynomial r = this.copy();
        while (!r.isZERO() && (f = r.leadingExpVector()).multipleOf(e)) {
            RingElem a = r.leadingBaseCoefficient();
            f = f.subtract(e);
            a = a.multiply((RingElem)ci);
            q = (GenSolvablePolynomial)q.sum(a, f);
            GenSolvablePolynomial<C> h = S.multiplyLeft(a, f);
            if (!h.leadingBaseCoefficient().equals(r.leadingBaseCoefficient())) {
                throw new RuntimeException("something is wrong: r = " + r + ", h = " + h);
            }
            r = (GenSolvablePolynomial)r.subtract(h);
        }
        GenSolvablePolynomial[] ret = new GenSolvablePolynomial[]{q, r};
        return ret;
    }
}

