/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModInteger;
import edu.jas.arith.ModIntegerRing;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.InvalidExpressionException;
import edu.jas.poly.ModuleList;
import edu.jas.poly.OrderedModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.Element;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class GenPolynomialTokenizer {
    private static final Logger logger = Logger.getLogger(GenPolynomialTokenizer.class);
    private final boolean debug = logger.isDebugEnabled();
    private String[] vars = null;
    private int nvars = 1;
    private TermOrder tord;
    private RelationTable table;
    private final StreamTokenizer tok;
    private final Reader reader;
    private RingFactory fac;
    private coeffType parsedCoeff = coeffType.BigRat;
    private GenPolynomialRing pfac;
    private polyType parsedPoly = polyType.PolBigRat;
    private GenSolvablePolynomialRing spfac;

    public GenPolynomialTokenizer() {
        this(new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF8"))));
    }

    public GenPolynomialTokenizer(GenPolynomialRing rf, Reader r) {
        this(r);
        if (rf == null) {
            return;
        }
        if (rf instanceof GenSolvablePolynomialRing) {
            this.pfac = rf;
            this.spfac = (GenSolvablePolynomialRing)rf;
        } else {
            this.pfac = rf;
            this.spfac = null;
        }
        this.fac = rf.coFac;
        this.vars = rf.vars;
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = rf.tord;
        this.table = this.spfac != null ? this.spfac.table : null;
    }

    public GenPolynomialTokenizer(Reader r) {
        this.tord = new TermOrder();
        this.fac = new BigRational(1L);
        this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
        this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
        this.reader = r;
        this.tok = new StreamTokenizer(this.reader);
        this.tok.resetSyntax();
        this.tok.eolIsSignificant(false);
        this.tok.wordChars(48, 57);
        this.tok.wordChars(97, 122);
        this.tok.wordChars(65, 90);
        this.tok.wordChars(95, 95);
        this.tok.wordChars(47, 47);
        this.tok.wordChars(160, 255);
        this.tok.whitespaceChars(0, 32);
        this.tok.commentChar(35);
        this.tok.quoteChar(34);
        this.tok.quoteChar(39);
    }

    public void initFactory(RingFactory rf, coeffType ct) {
        this.fac = rf;
        this.parsedCoeff = ct;
        switch (ct) {
            case BigRat: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
                break;
            }
            case BigInt: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigInt;
                break;
            }
            case ModInt: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModInt;
                break;
            }
            case BigC: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigC;
                break;
            }
            case BigQ: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigQ;
                break;
            }
            case BigD: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigD;
                break;
            }
            case IntFunc: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolIntFunc;
                break;
            }
            default: {
                this.pfac = new GenPolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
            }
        }
    }

    public void initSolvableFactory(RingFactory rf, coeffType ct) {
        this.fac = rf;
        this.parsedCoeff = ct;
        switch (ct) {
            case BigRat: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
                break;
            }
            case BigInt: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigInt;
                break;
            }
            case ModInt: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolModInt;
                break;
            }
            case BigC: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigC;
                break;
            }
            case BigQ: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigQ;
                break;
            }
            case BigD: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigD;
                break;
            }
            case IntFunc: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolIntFunc;
                break;
            }
            default: {
                this.spfac = new GenSolvablePolynomialRing(this.fac, this.nvars, this.tord, this.vars);
                this.parsedPoly = polyType.PolBigRat;
            }
        }
    }

    public GenPolynomial nextPolynomial() throws IOException {
        if (this.debug) {
            logger.debug((Object)("torder = " + this.tord));
        }
        GenPolynomial a = this.pfac.getZERO();
        MonoidElem a1 = this.pfac.getONE();
        ExpVector leer = this.pfac.evzero;
        if (this.debug) {
            logger.debug((Object)("a = " + a));
            logger.debug((Object)("a1 = " + a1));
        }
        Element<RingElem> b = a1;
        boolean done = false;
        block22: while (!done) {
            int tt = this.tok.nextToken();
            logger.debug((Object)("while tt = " + this.tok));
            if (tt == -1) break;
            switch (tt) {
                case 41: 
                case 44: {
                    return a;
                }
                case 45: {
                    b = ((GenPolynomial)b).negate();
                }
                case 42: 
                case 43: {
                    tt = this.tok.nextToken();
                    break;
                }
            }
            if (tt == -1) break;
            switch (tt) {
                case 125: {
                    throw new InvalidExpressionException("mismatch of braces after " + a + ", error at " + b);
                }
                case 123: {
                    RingElem r;
                    StringBuffer rf = new StringBuffer();
                    int level = 0;
                    do {
                        if ((tt = this.tok.nextToken()) == -1) {
                            throw new InvalidExpressionException("mismatch of braces after " + a + ", error at " + b);
                        }
                        if (tt == 123) {
                            ++level;
                        }
                        if (tt == 125 && --level < 0) continue;
                        if (this.tok.sval != null) {
                            if (rf.length() > 0 && rf.charAt(rf.length() - 1) != '.') {
                                rf.append(" ");
                            }
                            rf.append(this.tok.sval);
                            continue;
                        }
                        rf.append((char)tt);
                    } while (level >= 0);
                    try {
                        r = (RingElem)this.fac.parse(rf.toString());
                    }
                    catch (NumberFormatException re) {
                        throw new InvalidExpressionException("not a number " + rf, re);
                    }
                    if (this.debug) {
                        logger.debug((Object)("coeff " + r));
                    }
                    long ie = this.nextExponent();
                    if (this.debug) {
                        logger.debug((Object)("ie " + ie));
                    }
                    r = Power.positivePower(r, ie);
                    if (this.debug) {
                        logger.debug((Object)("coeff^ie " + r));
                    }
                    b = ((GenPolynomial)b).multiply(r, leer);
                    tt = this.tok.nextToken();
                    if (!this.debug) break;
                    logger.debug((Object)("tt,digit = " + this.tok));
                    break;
                }
                case -3: {
                    long ie;
                    RingElem r;
                    if (this.tok.sval == null || this.tok.sval.length() == 0) break;
                    char first = this.tok.sval.charAt(0);
                    if (GenPolynomialTokenizer.digit(first)) {
                        StringBuffer df = new StringBuffer();
                        df.append(this.tok.sval);
                        if (this.tok.sval.charAt(this.tok.sval.length() - 1) == 'i') {
                            tt = this.tok.nextToken();
                            if (this.debug) {
                                logger.debug((Object)("tt,im = " + this.tok));
                            }
                            if (this.tok.sval != null || tt == 45) {
                                if (this.tok.sval != null) {
                                    df.append(this.tok.sval);
                                } else {
                                    df.append("-");
                                }
                                if (tt == 45) {
                                    tt = this.tok.nextToken();
                                    if (this.tok.sval != null && GenPolynomialTokenizer.digit(this.tok.sval.charAt(0))) {
                                        df.append(this.tok.sval);
                                    } else {
                                        this.tok.pushBack();
                                    }
                                }
                            } else {
                                this.tok.pushBack();
                            }
                        }
                        if ((tt = this.tok.nextToken()) == 46) {
                            tt = this.tok.nextToken();
                            if (this.debug) {
                                logger.debug((Object)("tt,dot = " + this.tok));
                            }
                            if (this.tok.sval != null) {
                                df.append(".");
                                df.append(this.tok.sval);
                            } else {
                                this.tok.pushBack();
                                this.tok.pushBack();
                            }
                        } else {
                            this.tok.pushBack();
                        }
                        try {
                            r = (RingElem)this.fac.parse(df.toString());
                        }
                        catch (NumberFormatException re) {
                            throw new InvalidExpressionException("not a number " + df, re);
                        }
                        if (this.debug) {
                            logger.debug((Object)("coeff " + r));
                        }
                        ie = this.nextExponent();
                        if (this.debug) {
                            logger.debug((Object)("ie " + ie));
                        }
                        r = Power.positivePower(r, ie);
                        if (this.debug) {
                            logger.debug((Object)("coeff^ie " + r));
                        }
                        b = ((GenPolynomial)b).multiply(r, leer);
                        tt = this.tok.nextToken();
                        if (this.debug) {
                            logger.debug((Object)("tt,digit = " + this.tok));
                        }
                    }
                    if (tt == -1 || this.tok.sval == null || !GenPolynomialTokenizer.letter(first = this.tok.sval.charAt(0))) break;
                    int ix = leer.indexVar(this.tok.sval, this.vars);
                    if (ix < 0) {
                        try {
                            r = (RingElem)this.fac.parse(this.tok.sval);
                        }
                        catch (NumberFormatException re) {
                            throw new InvalidExpressionException("recursively unknown variable " + this.tok.sval);
                        }
                        if (this.debug) {
                            logger.info((Object)("coeff " + r));
                        }
                        ie = this.nextExponent();
                        r = Power.positivePower(r, ie);
                        b = ((GenPolynomial)b).multiply(r);
                    } else {
                        ie = this.nextExponent();
                        ExpVector e = ExpVector.create(this.vars.length, ix, ie);
                        b = ((GenPolynomial)b).multiply(e);
                    }
                    tt = this.tok.nextToken();
                    if (!this.debug) break;
                    logger.debug((Object)("tt,letter = " + this.tok));
                    break;
                }
                case 40: {
                    GenPolynomial c = this.nextPolynomial();
                    if (this.debug) {
                        logger.debug((Object)("factor " + c));
                    }
                    long ie = this.nextExponent();
                    if (this.debug) {
                        logger.debug((Object)("ie " + ie));
                    }
                    c = Power.positivePower(c, ie);
                    if (this.debug) {
                        logger.debug((Object)("factor^ie " + c));
                    }
                    b = ((GenPolynomial)b).multiply(c);
                    tt = this.tok.nextToken();
                    if (!this.debug) break;
                    logger.debug((Object)("tt,digit = " + this.tok));
                    break;
                }
            }
            if (done || tt == -1) break;
            this.tok.pushBack();
            switch (tt) {
                case 41: 
                case 43: 
                case 44: 
                case 45: {
                    logger.debug((Object)("b, = " + b));
                    a = a.sum((MonoidElem)b);
                    b = a1;
                    continue block22;
                }
                case 42: {
                    logger.debug((Object)("b, = " + b));
                    continue block22;
                }
                case 10: {
                    tt = this.tok.nextToken();
                    if (!this.debug) continue block22;
                    logger.debug((Object)("tt,nl = " + tt));
                    continue block22;
                }
            }
            if (!this.debug) continue;
            logger.debug((Object)("default: " + this.tok));
        }
        if (this.debug) {
            logger.debug((Object)("b = " + b));
        }
        a = a.sum((MonoidElem)b);
        logger.debug((Object)("a = " + a));
        return a;
    }

    public long nextExponent() throws IOException {
        char first;
        long e = 1L;
        int tt = this.tok.nextToken();
        if (tt == 94) {
            if (this.debug) {
                logger.debug((Object)"exponent ^");
            }
            tt = this.tok.nextToken();
            if (this.tok.sval != null && GenPolynomialTokenizer.digit(first = this.tok.sval.charAt(0))) {
                e = Long.parseLong(this.tok.sval);
                return e;
            }
        }
        if (tt == 42) {
            tt = this.tok.nextToken();
            if (tt == 42) {
                if (this.debug) {
                    logger.debug((Object)"exponent **");
                }
                tt = this.tok.nextToken();
                if (this.tok.sval != null && GenPolynomialTokenizer.digit(first = this.tok.sval.charAt(0))) {
                    e = Long.parseLong(this.tok.sval);
                    return e;
                }
            }
            this.tok.pushBack();
        }
        this.tok.pushBack();
        return e;
    }

    public String nextComment() throws IOException {
        StringBuffer c = new StringBuffer();
        if (this.debug) {
            logger.debug((Object)("comment: " + this.tok));
        }
        int tt = this.tok.nextToken();
        if (this.debug) {
            logger.debug((Object)("comment: " + this.tok));
        }
        if (tt == 40) {
            tt = this.tok.nextToken();
            if (this.debug) {
                logger.debug((Object)("comment: " + this.tok));
            }
            if (tt == 42) {
                if (this.debug) {
                    logger.debug((Object)"comment: ");
                }
                while (true) {
                    if ((tt = this.tok.nextToken()) == 42) {
                        tt = this.tok.nextToken();
                        if (tt == 41) {
                            return c.toString();
                        }
                        this.tok.pushBack();
                    }
                    c.append(this.tok.sval);
                }
            }
            this.tok.pushBack();
            if (this.debug) {
                logger.debug((Object)("comment: " + this.tok));
            }
        }
        this.tok.pushBack();
        if (this.debug) {
            logger.debug((Object)("comment: " + this.tok));
        }
        return c.toString();
    }

    public String[] nextVariableList() throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        int tt = this.tok.nextToken();
        if (tt == 40 || tt == 123) {
            logger.debug((Object)"variable list");
            tt = this.tok.nextToken();
            while (tt != -1 && tt != 41 && tt != 125) {
                if (tt == -3) {
                    l.add(this.tok.sval);
                }
                tt = this.tok.nextToken();
            }
        }
        Object[] ol = l.toArray();
        String[] v = new String[ol.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (String)ol[i];
        }
        return v;
    }

    public RingFactory nextCoefficientRing() throws IOException {
        RingFactory<BigRational> coeff = null;
        coeffType ct = null;
        int tt = this.tok.nextToken();
        if (this.tok.sval != null) {
            if (this.tok.sval.equalsIgnoreCase("Q")) {
                coeff = new BigRational(0L);
                ct = coeffType.BigRat;
            } else if (this.tok.sval.equalsIgnoreCase("Rat")) {
                coeff = new BigRational(0L);
                ct = coeffType.BigRat;
            } else if (this.tok.sval.equalsIgnoreCase("D")) {
                coeff = new BigDecimal(0L);
                ct = coeffType.BigD;
            } else if (this.tok.sval.equalsIgnoreCase("Z")) {
                coeff = new BigInteger(0L);
                ct = coeffType.BigInt;
            } else if (this.tok.sval.equalsIgnoreCase("Int")) {
                coeff = new BigInteger(0L);
                ct = coeffType.BigInt;
            } else if (this.tok.sval.equalsIgnoreCase("C")) {
                coeff = new BigComplex(0L);
                ct = coeffType.BigC;
            } else if (this.tok.sval.equalsIgnoreCase("Complex")) {
                coeff = new BigComplex(0L);
                ct = coeffType.BigC;
            } else if (this.tok.sval.equalsIgnoreCase("Quat")) {
                coeff = new BigQuaternion(0L);
                ct = coeffType.BigQ;
            } else if (this.tok.sval.equalsIgnoreCase("Mod")) {
                tt = this.tok.nextToken();
                boolean openb = false;
                if (tt == 91) {
                    openb = true;
                    tt = this.tok.nextToken();
                }
                if (this.tok.sval != null && this.tok.sval.length() > 0) {
                    if (GenPolynomialTokenizer.digit(this.tok.sval.charAt(0))) {
                        BigInteger mo = new BigInteger(this.tok.sval);
                        BigInteger lm = new BigInteger(ModLongRing.MAX_LONG);
                        coeff = mo.compareTo(lm) < 0 ? new ModLongRing(mo.getVal()) : new ModIntegerRing(mo.getVal());
                        ct = coeffType.ModInt;
                    } else {
                        this.tok.pushBack();
                    }
                } else {
                    this.tok.pushBack();
                }
                if (tt == 93 && openb) {
                    tt = this.tok.nextToken();
                }
            } else {
                if (this.tok.sval.equalsIgnoreCase("RatFunc") || this.tok.sval.equalsIgnoreCase("ModFunc")) {
                    throw new InvalidExpressionException("RatFunc and ModFunc can no more be read, see edu.jas.application.RingFactoryTokenizer.");
                }
                if (this.tok.sval.equalsIgnoreCase("IntFunc")) {
                    String[] rfv = this.nextVariableList();
                    int vr = rfv.length;
                    BigRational bi = new BigRational();
                    TermOrder to = new TermOrder(2);
                    GenPolynomialRing<BigRational> pcf = new GenPolynomialRing<BigRational>(bi, vr, to, rfv);
                    coeff = pcf;
                    ct = coeffType.IntFunc;
                } else if (this.tok.sval.equalsIgnoreCase("AN")) {
                    tt = this.tok.nextToken();
                    if (tt == 91) {
                        GenPolynomial mod;
                        tt = this.tok.nextToken();
                        Iterable<ModInteger> tcfac = new ModIntegerRing("19");
                        if (this.tok.sval != null && this.tok.sval.length() > 0) {
                            if (GenPolynomialTokenizer.digit(this.tok.sval.charAt(0))) {
                                tcfac = new ModIntegerRing(this.tok.sval);
                            } else {
                                tcfac = new BigRational();
                                this.tok.pushBack();
                            }
                        } else {
                            tcfac = new BigRational();
                            this.tok.pushBack();
                        }
                        Object[] anv = this.nextVariableList();
                        int vs = anv.length;
                        if (vs != 1) {
                            throw new InvalidExpressionException("AlgebraicNumber only for univariate polynomials " + Arrays.toString(anv));
                        }
                        String[] ovars = this.vars;
                        this.vars = anv;
                        GenPolynomialRing tpfac = this.pfac;
                        RingFactory tfac = this.fac;
                        this.fac = tcfac;
                        this.pfac = tcfac instanceof ModIntegerRing ? new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)((Object)tcfac), vs, new TermOrder(), (String[])anv) : new GenPolynomialRing<ModInteger>((RingFactory<ModInteger>)((Object)tcfac), vs, new TermOrder(), (String[])anv);
                        if (this.debug) {
                            logger.debug((Object)("pfac = " + this.pfac));
                        }
                        if ((tt = this.tok.nextToken()) == 40) {
                            mod = this.nextPolynomial();
                            tt = this.tok.nextToken();
                            if (this.tok.ttype != 41) {
                                this.tok.pushBack();
                            }
                        } else {
                            this.tok.pushBack();
                            mod = this.nextPolynomial();
                        }
                        if (this.debug) {
                            logger.debug((Object)("mod = " + mod));
                        }
                        this.pfac = tpfac;
                        this.fac = tfac;
                        this.vars = ovars;
                        if (tcfac instanceof ModIntegerRing) {
                            GenPolynomial gfmod = mod;
                            coeff = new AlgebraicNumberRing(gfmod);
                            ct = coeffType.ANmod;
                        } else {
                            GenPolynomial anmod = mod;
                            coeff = new AlgebraicNumberRing(anmod);
                            ct = coeffType.ANrat;
                        }
                        if (this.debug) {
                            logger.debug((Object)("coeff = " + coeff));
                        }
                        if ((tt = this.tok.nextToken()) != 93) {
                            this.tok.pushBack();
                        }
                    } else {
                        this.tok.pushBack();
                    }
                }
            }
        }
        if (coeff == null) {
            this.tok.pushBack();
            coeff = new BigRational();
            ct = coeffType.BigRat;
        }
        this.parsedCoeff = ct;
        return coeff;
    }

    public long[] nextWeightList() throws IOException {
        ArrayList<Long> l = new ArrayList<Long>();
        long[] w = null;
        int tt = this.tok.nextToken();
        if (tt == 40) {
            logger.debug((Object)"weight list");
            tt = this.tok.nextToken();
            while (tt != -1 && tt != 41) {
                char first;
                if (this.tok.sval != null && GenPolynomialTokenizer.digit(first = this.tok.sval.charAt(0))) {
                    long e = Long.parseLong(this.tok.sval);
                    l.add(e);
                }
                tt = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] ol = l.toArray();
        w = new long[ol.length];
        for (int i = 0; i < w.length; ++i) {
            w[i] = (Long)ol[ol.length - i - 1];
        }
        return w;
    }

    public long[][] nextWeightArray() throws IOException {
        ArrayList<long[]> l = new ArrayList<long[]>();
        Object w = null;
        int tt = this.tok.nextToken();
        if (tt == 40) {
            logger.debug((Object)"weight array");
            tt = this.tok.nextToken();
            while (tt != -1 && tt != 41) {
                char first;
                long[] e;
                if (tt == 40) {
                    this.tok.pushBack();
                    e = this.nextWeightList();
                    l.add(e);
                } else if (this.tok.sval != null && GenPolynomialTokenizer.digit(first = this.tok.sval.charAt(0))) {
                    this.tok.pushBack();
                    this.tok.pushBack();
                    e = this.nextWeightList();
                    l.add(e);
                    break;
                }
                tt = this.tok.nextToken();
            }
        } else {
            this.tok.pushBack();
        }
        Object[] ol = l.toArray();
        w = new long[ol.length][];
        for (int i = 0; i < ((long[][])w).length; ++i) {
            w[i] = (long[])ol[i];
        }
        return w;
    }

    public int nextSplitIndex() throws IOException {
        int e = -1;
        int e0 = -1;
        int tt = this.tok.nextToken();
        if (tt == 124) {
            logger.debug((Object)"split index");
            tt = this.tok.nextToken();
            if (tt == -1) {
                return e;
            }
            if (this.tok.sval != null) {
                char first = this.tok.sval.charAt(0);
                if (GenPolynomialTokenizer.digit(first)) {
                    e = Integer.parseInt(this.tok.sval);
                }
                if ((tt = this.tok.nextToken()) != 124) {
                    this.tok.pushBack();
                }
            }
        } else if (tt == 91) {
            logger.debug((Object)"split index");
            tt = this.tok.nextToken();
            if (tt == -1) {
                return e;
            }
            if (this.tok.sval != null) {
                char first = this.tok.sval.charAt(0);
                if (GenPolynomialTokenizer.digit(first)) {
                    e0 = Integer.parseInt(this.tok.sval);
                }
                if ((tt = this.tok.nextToken()) == 44) {
                    tt = this.tok.nextToken();
                    if (tt == -1) {
                        return e0;
                    }
                    if (this.tok.sval != null && GenPolynomialTokenizer.digit(first = this.tok.sval.charAt(0))) {
                        e = Integer.parseInt(this.tok.sval);
                    }
                    if (tt != 93) {
                        this.tok.pushBack();
                    }
                }
            }
        } else {
            this.tok.pushBack();
        }
        return e;
    }

    public TermOrder nextTermOrder() throws IOException {
        int s;
        int evord = 4;
        int tt = this.tok.nextToken();
        if (tt != -1) {
            if (tt == -3) {
                if (this.tok.sval != null) {
                    if (this.tok.sval.equalsIgnoreCase("L")) {
                        evord = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("IL")) {
                        evord = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("INVLEX")) {
                        evord = 2;
                    } else if (this.tok.sval.equalsIgnoreCase("LEX")) {
                        evord = 1;
                    } else if (this.tok.sval.equalsIgnoreCase("G")) {
                        evord = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("IG")) {
                        evord = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("IGRLEX")) {
                        evord = 4;
                    } else if (this.tok.sval.equalsIgnoreCase("GRLEX")) {
                        evord = 3;
                    } else if (this.tok.sval.equalsIgnoreCase("W")) {
                        long[][] w = this.nextWeightArray();
                        return new TermOrder(w);
                    }
                }
            } else {
                this.tok.pushBack();
            }
        }
        if ((s = this.nextSplitIndex()) <= 0) {
            return new TermOrder(evord);
        }
        return new TermOrder(evord, evord, this.vars.length, s);
    }

    public List<GenPolynomial> nextPolynomialList() throws IOException {
        ArrayList<GenPolynomial> L = new ArrayList<GenPolynomial>();
        int tt = this.tok.nextToken();
        if (tt == -1) {
            return L;
        }
        if (tt != 40) {
            return L;
        }
        logger.debug((Object)"polynomial list");
        while (true) {
            GenPolynomial a;
            tt = this.tok.nextToken();
            if (this.tok.ttype == 44) continue;
            if (tt == 40) {
                a = this.nextPolynomial();
                tt = this.tok.nextToken();
                if (this.tok.ttype != 41) {
                    this.tok.pushBack();
                }
            } else {
                this.tok.pushBack();
                a = this.nextPolynomial();
            }
            logger.info((Object)("next pol = " + a));
            L.add(a);
            if (this.tok.ttype == -1 || this.tok.ttype == 41) break;
        }
        return L;
    }

    public List<List<GenPolynomial>> nextSubModuleList() throws IOException {
        ArrayList<List<GenPolynomial>> L = new ArrayList<List<GenPolynomial>>();
        int tt = this.tok.nextToken();
        if (tt == -1) {
            return L;
        }
        if (tt != 40) {
            return L;
        }
        logger.debug((Object)"module list");
        List<GenPolynomial> v = null;
        while (true) {
            tt = this.tok.nextToken();
            if (this.tok.ttype == 44) continue;
            if (this.tok.ttype == 41 || this.tok.ttype == -1) break;
            if (tt != 40) continue;
            this.tok.pushBack();
            v = this.nextPolynomialList();
            logger.info((Object)("next vect = " + v));
            L.add(v);
        }
        return L;
    }

    public void nextRelationTable() throws IOException {
        if (this.spfac == null) {
            return;
        }
        RelationTable table = this.spfac.table;
        List<GenPolynomial> rels = null;
        int tt = this.tok.nextToken();
        if (this.debug) {
            logger.debug((Object)("relation table: " + tt));
        }
        if (this.tok.sval != null && this.tok.sval.equalsIgnoreCase("RelationTable")) {
            rels = this.nextPolynomialList();
        }
        if (rels == null) {
            this.tok.pushBack();
            return;
        }
        Iterator it = rels.iterator();
        while (it.hasNext()) {
            GenPolynomial p = (GenPolynomial)it.next();
            ExpVector e = p.leadingExpVector();
            if (!it.hasNext()) continue;
            p = (GenPolynomial)it.next();
            ExpVector f = p.leadingExpVector();
            if (!it.hasNext()) continue;
            p = (GenPolynomial)it.next();
            GenSolvablePolynomial sp = new GenSolvablePolynomial(this.spfac, p.val);
            table.update(e, f, sp);
        }
        if (this.debug) {
            logger.info((Object)("table = " + table));
        }
    }

    public PolynomialList nextPolynomialSet() throws IOException {
        RingFactory coeff = this.nextCoefficientRing();
        logger.info((Object)("coeff = " + coeff.getClass().getSimpleName()));
        this.vars = this.nextVariableList();
        logger.info((Object)("vars = " + Arrays.toString(this.vars)));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info((Object)("tord = " + this.tord));
        this.initFactory(coeff, this.parsedCoeff);
        List s = null;
        s = this.nextPolynomialList();
        logger.info((Object)("s = " + s));
        return new PolynomialList(this.pfac, s);
    }

    public ModuleList nextSubModuleSet() throws IOException {
        RingFactory coeff = this.nextCoefficientRing();
        logger.info((Object)("coeff = " + coeff.getClass().getSimpleName()));
        this.vars = this.nextVariableList();
        logger.info((Object)("vars = " + Arrays.toString(this.vars)));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info((Object)("tord = " + this.tord));
        this.initFactory(coeff, this.parsedCoeff);
        List m = null;
        m = this.nextSubModuleList();
        logger.info((Object)("m = " + m));
        return new ModuleList(this.pfac, m);
    }

    public List<GenSolvablePolynomial> nextSolvablePolynomialList() throws IOException {
        List<GenPolynomial> s = this.nextPolynomialList();
        logger.info((Object)("s = " + s));
        ArrayList<GenSolvablePolynomial> sp = new ArrayList<GenSolvablePolynomial>(s.size());
        for (GenPolynomial p : s) {
            GenSolvablePolynomial ps = new GenSolvablePolynomial(this.spfac, p.val);
            sp.add(ps);
        }
        return sp;
    }

    public GenSolvablePolynomial nextSolvablePolynomial() throws IOException {
        GenPolynomial p = this.nextPolynomial();
        logger.info((Object)("p = " + p));
        GenSolvablePolynomial ps = new GenSolvablePolynomial(this.spfac, p.val);
        return ps;
    }

    public PolynomialList nextSolvablePolynomialSet() throws IOException {
        RingFactory coeff = this.nextCoefficientRing();
        logger.info((Object)("coeff = " + coeff.getClass().getSimpleName()));
        this.vars = this.nextVariableList();
        logger.info((Object)("vars = " + Arrays.toString(this.vars)));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info((Object)("tord = " + this.tord));
        this.initFactory(coeff, this.parsedCoeff);
        this.initSolvableFactory(coeff, this.parsedCoeff);
        this.nextRelationTable();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("table = " + this.table));
        }
        List s = null;
        s = this.nextSolvablePolynomialList();
        logger.info((Object)("s = " + s));
        return new PolynomialList(this.spfac, s);
    }

    public List<List<GenSolvablePolynomial>> nextSolvableSubModuleList() throws IOException {
        ArrayList<List<GenSolvablePolynomial>> L = new ArrayList<List<GenSolvablePolynomial>>();
        int tt = this.tok.nextToken();
        if (tt == -1) {
            return L;
        }
        if (tt != 40) {
            return L;
        }
        logger.debug((Object)"module list");
        List<GenSolvablePolynomial> v = null;
        while (true) {
            tt = this.tok.nextToken();
            if (this.tok.ttype == 44) continue;
            if (this.tok.ttype == 41 || this.tok.ttype == -1) break;
            if (tt != 40) continue;
            this.tok.pushBack();
            v = this.nextSolvablePolynomialList();
            logger.info((Object)("next vect = " + v));
            L.add(v);
        }
        return L;
    }

    public ModuleList nextSolvableSubModuleSet() throws IOException {
        RingFactory coeff = this.nextCoefficientRing();
        logger.info((Object)("coeff = " + coeff.getClass().getSimpleName()));
        this.vars = this.nextVariableList();
        logger.info((Object)("vars = " + Arrays.toString(this.vars)));
        if (this.vars != null) {
            this.nvars = this.vars.length;
        }
        this.tord = this.nextTermOrder();
        logger.info((Object)("tord = " + this.tord));
        this.initFactory(coeff, this.parsedCoeff);
        this.initSolvableFactory(coeff, this.parsedCoeff);
        this.nextRelationTable();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("table = " + this.table));
        }
        List s = null;
        s = this.nextSolvableSubModuleList();
        logger.info((Object)("s = " + s));
        return new OrderedModuleList(this.spfac, s);
    }

    private static boolean digit(char x) {
        return '0' <= x && x <= '9';
    }

    private static boolean letter(char x) {
        return 'a' <= x && x <= 'z' || 'A' <= x && x <= 'Z';
    }

    public void nextComma() throws IOException {
        if (this.tok.ttype == 44) {
            int tt = this.tok.nextToken();
            if (this.debug) {
                logger.debug((Object)("after comma: " + tt));
            }
        }
    }

    public static String[] variableList(String s) {
        String[] vl = null;
        if (s == null) {
            return vl;
        }
        String st = s.trim();
        if (st.length() == 0) {
            return new String[0];
        }
        if (st.charAt(0) == '(') {
            st = st.substring(1);
        }
        if (st.charAt(st.length() - 1) == ')') {
            st = st.substring(0, st.length() - 1);
        }
        st = st.replaceAll(",", " ");
        ArrayList<String> sl = new ArrayList<String>();
        Scanner sc = new Scanner(st);
        while (sc.hasNext()) {
            String sn = sc.next();
            sl.add(sn);
        }
        vl = new String[sl.size()];
        int i = 0;
        Iterator i$ = sl.iterator();
        while (i$.hasNext()) {
            String si;
            vl[i] = si = (String)i$.next();
            ++i;
        }
        return vl;
    }

    public static String[] expressionVariables(String s) {
        String[] vl = null;
        if (s == null) {
            return vl;
        }
        String st = s.trim();
        if (st.length() == 0) {
            return new String[0];
        }
        st = st.replaceAll(",", " ");
        st = st.replaceAll("\\+", " ");
        st = st.replaceAll("-", " ");
        st = st.replaceAll("\\*", " ");
        st = st.replaceAll("/", " ");
        st = st.replaceAll("\\(", " ");
        st = st.replaceAll("\\)", " ");
        st = st.replaceAll("\\{", " ");
        st = st.replaceAll("\\}", " ");
        st = st.replaceAll("\\[", " ");
        st = st.replaceAll("\\]", " ");
        st = st.replaceAll("\\^", " ");
        TreeSet<String> sl = new TreeSet<String>();
        Scanner sc = new Scanner(st);
        while (sc.hasNext()) {
            int i;
            String sn = sc.next();
            if (sn == null || sn.length() == 0) continue;
            for (i = 0; GenPolynomialTokenizer.digit(sn.charAt(i)) && i < sn.length() - 1; ++i) {
            }
            if (i > 0) {
                sn = sn.substring(i, sn.length());
            }
            if (sn.length() == 0 || !GenPolynomialTokenizer.letter(sn.charAt(0))) continue;
            sl.add(sn);
        }
        vl = new String[sl.size()];
        int i = 0;
        Iterator i$ = sl.iterator();
        while (i$.hasNext()) {
            String si;
            vl[i] = si = (String)i$.next();
            ++i;
        }
        return vl;
    }

    private static enum polyType {
        PolBigRat,
        PolBigInt,
        PolModInt,
        PolBigC,
        PolBigD,
        PolBigQ,
        PolANrat,
        PolANmod,
        PolIntFunc;

    }

    private static enum coeffType {
        BigRat,
        BigInt,
        ModInt,
        BigC,
        BigQ,
        BigD,
        ANrat,
        ANmod,
        IntFunc;

    }
}

