/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.ArrayList;

public final class ExpVectorByte
extends ExpVector {
    final byte[] val;
    public static final long maxByte = 63L;
    public static final long minByte = -64L;

    public ExpVectorByte(int n) {
        this(new byte[n]);
    }

    public ExpVectorByte(int n, int i, byte e) {
        this(n);
        this.val[i] = e;
    }

    public ExpVectorByte(int n, int i, long e) {
        this(n);
        if (e >= 63L || e <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (byte)e;
    }

    protected ExpVectorByte(byte[] v) {
        this.val = v;
    }

    public ExpVectorByte(long[] v) {
        this(v.length);
        for (int i = 0; i < v.length; ++i) {
            if (v[i] >= 63L || v[i] <= -64L) {
                throw new IllegalArgumentException("exponent to large: " + v[i]);
            }
            this.val[i] = (byte)v[i];
        }
    }

    public ExpVectorByte(String s) throws NumberFormatException {
        ArrayList<Byte> exps = new ArrayList<Byte>();
        s = s.trim();
        int b = s.indexOf(40);
        int e = s.indexOf(41, b + 1);
        if (b >= 0 && e >= 0) {
            byte a;
            String teil;
            int k;
            ++b;
            while ((k = s.indexOf(44, b)) >= 0) {
                teil = s.substring(b, k);
                a = Byte.parseByte(teil);
                exps.add(a);
                b = k + 1;
            }
            if (b <= e) {
                teil = s.substring(b, e);
                a = Byte.parseByte(teil);
                exps.add(a);
            }
            int length = exps.size();
            this.val = new byte[length];
            for (int j = 0; j < length; ++j) {
                this.val[j] = (Byte)exps.get(j);
            }
        } else {
            this.val = null;
        }
    }

    @Override
    public ExpVectorByte copy() {
        byte[] w = new byte[this.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        return new ExpVectorByte(w);
    }

    @Override
    long[] getVal() {
        long[] v = new long[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            v[i] = this.val[i];
        }
        return v;
    }

    @Override
    public long getVal(int i) {
        return this.val[i];
    }

    @Override
    protected long setVal(int i, long e) {
        byte x = this.val[i];
        if (e >= 63L || e <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        this.val[i] = (byte)e;
        this.hash = 0;
        return x;
    }

    protected byte setVal(int i, byte e) {
        byte x = this.val[i];
        this.val[i] = e;
        this.hash = 0;
        return x;
    }

    @Override
    public int length() {
        return this.val.length;
    }

    @Override
    public ExpVectorByte extend(int i, int j, long e) {
        byte[] w = new byte[this.val.length + i];
        System.arraycopy(this.val, 0, w, i, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        if (e >= 63L || e <= -64L) {
            throw new IllegalArgumentException("exponent to large: " + e);
        }
        w[j] = (byte)e;
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte extendLower(int i, int j, long e) {
        byte[] w = new byte[this.val.length + i];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        if (j >= i) {
            throw new IllegalArgumentException("i " + i + " <= j " + j + " invalid");
        }
        w[this.val.length + j] = (byte)e;
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte contract(int i, int len) {
        if (i + len > this.val.length) {
            throw new IllegalArgumentException("len " + len + " > val.len " + this.val.length);
        }
        byte[] w = new byte[len];
        System.arraycopy(this.val, i, w, 0, len);
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte reverse() {
        byte[] w = new byte[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            w[i] = this.val[this.val.length - 1 - i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte reverse(int j) {
        int i;
        if (j <= 0 || j > this.val.length) {
            return this;
        }
        byte[] w = new byte[this.val.length];
        for (i = 0; i < j; ++i) {
            w[i] = this.val[j - 1 - i];
        }
        for (i = j; i < this.val.length; ++i) {
            w[i] = this.val[i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte combine(ExpVector V) {
        if (V == null || V.length() == 0) {
            return this;
        }
        ExpVectorByte Vi = (ExpVectorByte)V;
        if (this.val.length == 0) {
            return Vi;
        }
        byte[] w = new byte[this.val.length + Vi.val.length];
        System.arraycopy(this.val, 0, w, 0, this.val.length);
        System.arraycopy(Vi.val, 0, w, this.val.length, Vi.val.length);
        return new ExpVectorByte(w);
    }

    @Override
    public String toString() {
        return super.toString() + ":byte";
    }

    @Override
    public boolean equals(Object B) {
        if (!(B instanceof ExpVectorByte)) {
            return false;
        }
        ExpVectorByte b = (ExpVectorByte)B;
        int t = this.invLexCompareTo(b);
        return 0 == t;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ExpVectorByte abs() {
        byte[] u = this.val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (long)u[i] >= 0L ? u[i] : (byte)(-u[i]);
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte negate() {
        byte[] u = this.val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = -u[i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte sum(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (byte)(u[i] + v[i]);
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte subtract(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = (byte)(u[i] - v[i]);
        }
        return new ExpVectorByte(w);
    }

    public ExpVectorByte subst(int i, byte d) {
        ExpVectorByte V = this.copy();
        V.setVal(i, d);
        return V;
    }

    @Override
    public ExpVectorByte subst(int i, long d) {
        ExpVectorByte V = this.copy();
        V.setVal(i, d);
        return V;
    }

    @Override
    public int signum() {
        int t = 0;
        byte[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] < 0) {
                return -1;
            }
            if (u[i] <= 0) continue;
            t = 1;
        }
        return t;
    }

    @Override
    public long totalDeg() {
        long t = 0L;
        byte[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            t += (long)u[i];
        }
        return t;
    }

    @Override
    public long maxDeg() {
        long t = 0L;
        byte[] u = this.val;
        for (int i = 0; i < u.length; ++i) {
            if ((long)u[i] <= t) continue;
            t = u[i];
        }
        return t;
    }

    @Override
    public long weightDeg(long[][] w) {
        if (w == null || w.length == 0) {
            return this.totalDeg();
        }
        long t = 0L;
        byte[] u = this.val;
        for (int j = 0; j < w.length; ++j) {
            long[] wj = w[j];
            for (int i = 0; i < u.length; ++i) {
                t += wj[i] * (long)u[i];
            }
        }
        return t;
    }

    @Override
    public ExpVectorByte lcm(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] >= v[i] ? u[i] : v[i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public ExpVectorByte gcd(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        byte[] w = new byte[u.length];
        for (int i = 0; i < u.length; ++i) {
            w[i] = u[i] <= v[i] ? u[i] : v[i];
        }
        return new ExpVectorByte(w);
    }

    @Override
    public int[] dependencyOnVariables() {
        byte[] u = this.val;
        int l = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0) continue;
            ++l;
        }
        int[] dep = new int[l];
        if (l == 0) {
            return dep;
        }
        int j = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] <= 0) continue;
            dep[j] = i;
            ++j;
        }
        return dep;
    }

    @Override
    public boolean multipleOf(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        boolean t = true;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] >= v[i]) continue;
            return false;
        }
        return t;
    }

    @Override
    public int compareTo(ExpVector V) {
        return this.invLexCompareTo(V);
    }

    @Override
    public int invLexCompareTo(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invLexCompareTo(ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < u.length; ++j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invGradCompareTo(ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j < end; ++j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvLexCompareTo(ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                return 1;
            }
            if (u[i] >= v[i]) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = u.length - 1; i >= 0; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= 0; --j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int revInvGradCompareTo(ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = end - 1; i >= begin; --i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        long up = 0L;
        long vp = 0L;
        for (int j = i; j >= begin; --j) {
            up += (long)u[j];
            vp += (long)v[j];
        }
        if (up > vp) {
            t = 1;
        } else if (up < vp) {
            t = -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = 0; i < u.length; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (int k = 0; k < w.length; ++k) {
            long[] wk = w[k];
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < u.length; ++j) {
                up += wk[j] * (long)u[j];
                vp += wk[j] * (long)v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }

    @Override
    public int invWeightCompareTo(long[][] w, ExpVector V, int begin, int end) {
        byte[] u = this.val;
        byte[] v = ((ExpVectorByte)V).val;
        int t = 0;
        for (int i = begin; i < end; ++i) {
            if (u[i] > v[i]) {
                t = 1;
                break;
            }
            if (u[i] >= v[i]) continue;
            t = -1;
            break;
        }
        if (t == 0) {
            return t;
        }
        for (int k = 0; k < w.length; ++k) {
            long[] wk = w[k];
            long up = 0L;
            long vp = 0L;
            for (int j = i; j < end; ++j) {
                up += wk[j] * (long)u[j];
                vp += wk[j] * (long)v[j];
            }
            if (up > vp) {
                return 1;
            }
            if (up >= vp) continue;
            return -1;
        }
        return t;
    }
}

