/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class CoeffToAlg<C extends GcdRingElem<C>>
implements UnaryFunctor<C, AlgebraicNumber<C>> {
    protected final AlgebraicNumberRing<C> afac;
    protected final GenPolynomial<C> zero;

    public CoeffToAlg(AlgebraicNumberRing<C> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.afac = fac;
        GenPolynomialRing pfac = this.afac.ring;
        this.zero = pfac.getZERO();
    }

    @Override
    public AlgebraicNumber<C> eval(C c) {
        if (c == null) {
            return this.afac.getZERO();
        }
        return new AlgebraicNumber<C>(this.afac, this.zero.sum(c));
    }
}

