/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.UnaryFunctor;

class AlgebToCompl<C extends GcdRingElem<C>>
implements UnaryFunctor<AlgebraicNumber<C>, Complex<C>> {
    protected final ComplexRing<C> cfac;

    public AlgebToCompl(ComplexRing<C> fac) {
        if (fac == null) {
            throw new IllegalArgumentException("fac must not be null");
        }
        this.cfac = fac;
    }

    @Override
    public Complex<C> eval(AlgebraicNumber<C> a) {
        if (a == null || a.isZERO()) {
            return this.cfac.getZERO();
        }
        if (a.isONE()) {
            return this.cfac.getONE();
        }
        GenPolynomial<C> p = a.getVal();
        GcdRingElem real = (GcdRingElem)this.cfac.ring.getZERO();
        GcdRingElem imag = (GcdRingElem)this.cfac.ring.getZERO();
        for (Monomial<C> m : p) {
            if (m.exponent().getVal(0) == 1L) {
                imag = (GcdRingElem)m.coefficient();
                continue;
            }
            if (m.exponent().getVal(0) == 0L) {
                real = (GcdRingElem)m.coefficient();
                continue;
            }
            throw new IllegalArgumentException("unexpected monomial " + m);
        }
        return new Complex<GcdRingElem>(this.cfac, real, imag);
    }
}

