/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.integrate;

import edu.jas.integrate.Integral;
import edu.jas.integrate.LogIntegral;
import edu.jas.integrate.QuotIntegral;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.Power;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorSubres;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class ElementaryIntegration<C extends GcdRingElem<C>> {
    private static final Logger logger = Logger.getLogger(ElementaryIntegration.class);
    private final boolean debug = logger.isDebugEnabled();
    public final FactorAbstract<C> irr;
    public final SquarefreeAbstract<C> sqf;
    public final GreatestCommonDivisorAbstract<C> ufd;

    public ElementaryIntegration(RingFactory<C> br) {
        this.ufd = GCDFactory.getProxy(br);
        this.sqf = SquarefreeFactory.getImplementation(br);
        this.irr = FactorFactory.getImplementation(br);
    }

    public QuotIntegral<C> integrate(Quotient<C> r) {
        Integral integral = this.integrate(r.num, r.den);
        return new QuotIntegral(r.ring, integral);
    }

    public Integral<C> integrate(GenPolynomial<C> a, GenPolynomial<C> d) {
        if (d == null || a == null || d.isZERO()) {
            throw new IllegalArgumentException("zero or null not allowed");
        }
        if (a.isZERO()) {
            return new Integral<C>(a, d, a);
        }
        if (d.isONE()) {
            GenPolynomial<C> pi = PolyUtil.baseIntegral(a);
            return new Integral<C>(a, d, pi);
        }
        GenPolynomialRing pfac = d.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials " + pfac);
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients " + pfac);
        }
        GenPolynomial<C>[] qr = PolyUtil.basePseudoQuotientRemainder(a, d);
        GenPolynomial<GenPolynomial<C>> p = qr[0];
        GenPolynomial<C> r = qr[1];
        GenPolynomial<C> c = this.ufd.gcd(r, d);
        if (!c.isONE()) {
            r = PolyUtil.basePseudoQuotientRemainder(r, c)[0];
            d = PolyUtil.basePseudoQuotientRemainder(d, c)[0];
        }
        List<GenPolynomial<C>>[] ih = this.integrateHermite(r, d);
        List<GenPolynomial<C>> rat = ih[0];
        List<GenPolynomial<C>> log = ih[1];
        GenPolynomial<C> pp = log.remove(0);
        p = p.sum(pp);
        GenPolynomial<C> pi = PolyUtil.baseIntegral(p);
        if (this.debug) {
            logger.debug((Object)("pi  = " + pi));
            logger.debug((Object)("rat = " + rat));
            logger.debug((Object)("log = " + log));
        }
        if (log.size() == 0) {
            return new Integral<C>(a, d, pi, rat);
        }
        ArrayList logi = new ArrayList(log.size() / 2);
        for (int i = 0; i < log.size(); ++i) {
            GenPolynomial<C> ln = log.get(i++);
            GenPolynomial<C> ld = log.get(i);
            LogIntegral<C> pf = this.integrateLogPart(ln, ld);
            logi.add(pf);
        }
        if (this.debug) {
            logger.debug((Object)("logi = " + logi));
        }
        return new Integral<C>(a, d, pi, rat, logi);
    }

    public List<GenPolynomial<C>>[] integrateHermite(GenPolynomial<C> a, GenPolynomial<C> d) {
        if (d == null || d.isZERO()) {
            throw new IllegalArgumentException("d == null or d == 0");
        }
        if (a == null || a.isZERO()) {
            throw new IllegalArgumentException("a == null or a == 0");
        }
        SortedMap<GenPolynomial<C>, Long> sfactors = this.sqf.squarefreeFactors(d);
        ArrayList<GenPolynomial<C>> D = new ArrayList<GenPolynomial<C>>(sfactors.keySet());
        ArrayList DP = new ArrayList();
        for (GenPolynomial genPolynomial : D) {
            long e = (Long)sfactors.get(genPolynomial);
            GenPolynomial dp = Power.positivePower(genPolynomial, e);
            DP.add(dp);
        }
        List<GenPolynomial<C>> Ai = this.ufd.basePartialFraction(a, DP);
        ArrayList<GenPolynomial> arrayList = new ArrayList<GenPolynomial>();
        ArrayList<GenPolynomial> H = new ArrayList<GenPolynomial>();
        H.add(Ai.remove(0));
        GenPolynomialRing fac = d.ring;
        int i = 0;
        for (GenPolynomial genPolynomial : D) {
            GenPolynomial<Object> Ak = Ai.get(i++);
            int k = ((Long)sfactors.get(genPolynomial)).intValue();
            for (int j = k - 1; j >= 1; --j) {
                GenPolynomial DV_dx = PolyUtil.baseDeriviative(genPolynomial);
                GenPolynomial<C> Aik = Ak.divide((GenPolynomial<C>)fac.fromInteger(-j));
                GenPolynomial<C>[] BC = this.ufd.baseGcdDiophant(DV_dx, genPolynomial, Aik);
                GenPolynomial<C> b = BC[0];
                GenPolynomial<C> c = BC[1];
                GenPolynomial vj = Power.positivePower(genPolynomial, j);
                arrayList.add(b);
                arrayList.add(vj);
                Ak = ((GenPolynomial)fac.fromInteger(-j)).multiply(c).subtract(PolyUtil.baseDeriviative(b));
            }
            if (Ak.isZERO()) continue;
            H.add(Ak);
            H.add(genPolynomial);
        }
        List[] ret = new List[]{arrayList, H};
        return ret;
    }

    public LogIntegral<C> integrateLogPart(GenPolynomial<C> A, GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            throw new IllegalArgumentException(" P == null or P == 0");
        }
        if (A == null || A.isZERO()) {
            throw new IllegalArgumentException(" A == null or A == 0");
        }
        GenPolynomialRing pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials " + pfac);
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients " + pfac);
        }
        ArrayList cfactors = new ArrayList();
        ArrayList cdenom = new ArrayList();
        ArrayList afactors = new ArrayList();
        ArrayList adenom = new ArrayList();
        if (P.degree(0) <= 1L) {
            cfactors.add(A.leadingBaseCoefficient());
            cdenom.add(P);
            return new LogIntegral<C>(A, P, cfactors, cdenom, afactors, adenom);
        }
        List<GenPolynomial<C>> Pfac = this.irr.baseFactorsSquarefree(P);
        List<GenPolynomial<C>> Afac = this.ufd.basePartialFraction(A, Pfac);
        GenPolynomial<C> A0 = Afac.remove(0);
        if (!A0.isZERO()) {
            throw new RuntimeException(" A0 != 0: deg(A)>= deg(P)");
        }
        int i = 0;
        for (GenPolynomial<C> pi : Pfac) {
            GenPolynomial<C> ai = Afac.get(i++);
            if (pi.degree(0) <= 1L) {
                cfactors.add(ai.leadingBaseCoefficient());
                cdenom.add(pi);
                continue;
            }
            LogIntegral<C> pf = this.integrateLogPartIrreducible(ai, pi);
            cfactors.addAll(pf.cfactors);
            cdenom.addAll(pf.cdenom);
            afactors.addAll(pf.afactors);
            adenom.addAll(pf.adenom);
        }
        return new LogIntegral<C>(A, P, cfactors, cdenom, afactors, adenom);
    }

    public LogIntegral<C> integrateLogPartIrreducible(GenPolynomial<C> A, GenPolynomial<C> P) {
        if (P == null || P.isZERO()) {
            throw new IllegalArgumentException("P == null or P == 0");
        }
        GenPolynomialRing<C> pfac = P.ring;
        if (pfac.nvar > 1) {
            throw new IllegalArgumentException("only for univariate polynomials " + pfac);
        }
        if (!pfac.coFac.isField()) {
            throw new IllegalArgumentException("only for field coefficients " + pfac);
        }
        ArrayList<C> cfactors = new ArrayList<C>();
        ArrayList cdenom = new ArrayList();
        ArrayList afactors = new ArrayList();
        ArrayList adenom = new ArrayList();
        if (P.degree(0) <= 1L) {
            cfactors.add(A.leadingBaseCoefficient());
            cdenom.add(P);
            return new LogIntegral<C>(A, P, cfactors, cdenom, afactors, adenom);
        }
        GenPolynomial<C> Pp = PolyUtil.baseDeriviative(P);
        String[] vars = new String[]{"t"};
        GenPolynomialRing cfac = new GenPolynomialRing(pfac.coFac, 1, pfac.tord, vars);
        GenPolynomial t = cfac.univariate(0);
        GenPolynomialRing rfac = new GenPolynomialRing(pfac, cfac);
        GenPolynomial Ac = PolyUfdUtil.introduceLowerVariable(rfac, A);
        GenPolynomial Pc = PolyUfdUtil.introduceLowerVariable(rfac, P);
        GenPolynomial Pcp = PolyUfdUtil.introduceLowerVariable(rfac, Pp);
        GenPolynomialRing rfac1 = Pc.ring;
        GenPolynomial tc = ((GenPolynomial)rfac1.getONE()).multiply(t);
        GenPolynomial At = Ac.subtract(tc.multiply(Pcp));
        GreatestCommonDivisorSubres engine = new GreatestCommonDivisorSubres();
        GreatestCommonDivisorAbstract<GenPolynomial<AlgebraicNumber<C>>> aengine = null;
        GenPolynomial Rc = engine.recursiveUnivariateResultant(Pc, At);
        GenPolynomial res = Rc.leadingBaseCoefficient();
        SortedMap<GenPolynomial<C>, Long> resfac = this.irr.baseFactors(res);
        for (GenPolynomial<C> r : resfac.keySet()) {
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> Ga;
            if (r.isConstant()) continue;
            vars = pfac.newVars("z_");
            pfac = pfac.copy();
            String[] unused = pfac.setVars(vars);
            r = pfac.copy(r);
            AlgebraicNumberRing<C> afac = new AlgebraicNumberRing<C>(r, true);
            logger.debug((Object)("afac = " + afac.toScript()));
            AlgebraicNumber<C> a = afac.getGenerator();
            GenPolynomialRing pafac = new GenPolynomialRing(afac, Pc.ring);
            GenPolynomial Pa = PolyUtil.convertToAlgebraicCoefficients(pafac, P);
            GenPolynomial<AlgebraicNumber<AlgebraicNumber<C>>> Pap = PolyUtil.convertToAlgebraicCoefficients(pafac, Pp);
            GenPolynomial<AlgebraicNumber<GenPolynomial<AlgebraicNumber<C>>>> Aa = PolyUtil.convertToAlgebraicCoefficients(pafac, A);
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> Ap = Aa.subtract((AlgebraicNumber<GenPolynomial<AlgebraicNumber<C>>>)((Object)Pap.multiply(a)));
            if (aengine == null) {
                aengine = GCDFactory.getImplementation(afac);
            }
            if ((Ga = aengine.baseGcd(Pa, Ap)).isConstant()) continue;
            afactors.add(a);
            adenom.add(Ga);
            if (P.degree(0) != 2L || Ga.degree(0) != 1L) continue;
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>>[] qra = PolyUtil.basePseudoQuotientRemainder(Pa, Ga);
            GenPolynomial<GenPolynomial<AlgebraicNumber<C>>> Qa = qra[0];
            if (!qra[1].isZERO()) {
                throw new ArithmeticException("remainder not zero");
            }
            afactors.add(a.negate());
            adenom.add(Qa);
        }
        return new LogIntegral<C>(A, P, cfactors, cdenom, afactors, adenom);
    }

    public Quotient<C> deriviative(Quotient<C> r) {
        GenPolynomial num = r.num;
        GenPolynomial den = r.den;
        GenPolynomial nump = PolyUtil.baseDeriviative(num);
        if (den.isONE()) {
            return new Quotient(r.ring, nump, den);
        }
        GenPolynomial denp = PolyUtil.baseDeriviative(den);
        GenPolynomial n = den.multiply(nump).subtract(num.multiply(denp));
        GenPolynomial d = den.multiply(den);
        Quotient der = new Quotient(r.ring, n, d);
        return der;
    }

    public boolean isIntegral(QuotIntegral<C> ri) {
        Quotient r = ri.quot;
        QuotientRing qr = r.ring;
        Quotient i = r.ring.getZERO();
        for (Quotient quotient : ri.rational) {
            Quotient qd = this.deriviative(quotient);
            i = i.sum(qd);
        }
        if (ri.logarithm.size() == 0) {
            return r.equals(i);
        }
        for (LogIntegral logIntegral : ri.logarithm) {
            Quotient q = new Quotient(qr, logIntegral.num, logIntegral.den);
            i = i.sum(q);
        }
        boolean t = r.equals(i);
        if (!t) {
            return false;
        }
        for (LogIntegral li : ri.logarithm) {
            t = this.isIntegral(li);
            if (t) continue;
            return false;
        }
        return true;
    }

    public boolean isIntegral(LogIntegral<C> rl) {
        QuotientRing qr = new QuotientRing(rl.den.ring);
        Quotient r = new Quotient(qr, rl.num, rl.den);
        Quotient i = qr.getZERO();
        int j = 0;
        for (GenPolynomial d : rl.cdenom) {
            GenPolynomial<RingElem> dp = PolyUtil.baseDeriviative(d);
            dp = dp.multiply((RingElem)rl.cfactors.get(j++));
            Quotient f = new Quotient(qr, dp, d);
            i = i.sum(f);
        }
        if (rl.afactors.size() == 0) {
            return r.equals(i);
        }
        r = r.subtract(i);
        QuotientRing aqr = new QuotientRing(rl.adenom.get((int)0).ring);
        Quotient ai = aqr.getZERO();
        GenPolynomial aqn = PolyUtil.convertToAlgebraicCoefficients(aqr.ring, r.num);
        GenPolynomial aqd = PolyUtil.convertToAlgebraicCoefficients(aqr.ring, r.den);
        Quotient ar = new Quotient(aqr, aqn, aqd);
        j = 0;
        for (GenPolynomial d : rl.adenom) {
            GenPolynomial dp = PolyUtil.baseDeriviative(d);
            dp = dp.multiply((AlgebraicNumber<RingElem>)rl.afactors.get(j++));
            Quotient f = new Quotient(aqr, dp, d);
            ai = ai.sum(f);
        }
        boolean t = ar.equals(ai);
        if (t) {
            return true;
        }
        logger.warn((Object)"log integral not verified");
        return true;
    }
}

