/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gbufd.RReduction;
import edu.jas.gbufd.RReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RegularRingElem;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrderedRPairlist<C extends RegularRingElem<C>>
extends OrderedPairlist<C> {
    private static final Logger logger = Logger.getLogger(OrderedRPairlist.class);
    protected final RReduction<C> rreduction = new RReductionSeq();

    public OrderedRPairlist(GenPolynomialRing<C> r) {
        this(0, r);
    }

    public OrderedRPairlist(int m, GenPolynomialRing<C> r) {
        super(m, r);
    }

    @Override
    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator ip = this.pairlist.entrySet().iterator();
        Pair pair = null;
        boolean c = false;
        if (ip.hasNext()) {
            Map.Entry me = ip.next();
            ExpVector g = (ExpVector)me.getKey();
            LinkedList xl = (LinkedList)me.getValue();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("g  = " + g));
            }
            pair = null;
            if (xl.size() > 0) {
                pair = (Pair)xl.removeFirst();
                int i = pair.i;
                int j = pair.j;
                c = this.useCriterion4 ? this.rreduction.criterion4(pair.pi, pair.pj, g) : true;
                pair.setUseCriterion4(c);
                if (c) {
                    c = this.criterion3(i, j, g);
                    pair.setUseCriterion3(c);
                }
                ((BitSet)this.red.get(j)).clear(i);
            }
            if (xl.size() == 0) {
                ip.remove();
            }
        }
        ++this.remCount;
        return pair;
    }

    @Override
    public boolean criterion3(int i, int j, ExpVector eij) {
        boolean s = ((BitSet)this.red.get(j)).get(i);
        if (!s) {
            logger.warn((Object)("c3.s false for " + j + " " + i));
            return s;
        }
        s = true;
        RegularRingElem ci = (RegularRingElem)((GenPolynomial)this.P.get(i)).leadingBaseCoefficient();
        RegularRingElem cj = (RegularRingElem)((GenPolynomial)this.P.get(j)).leadingBaseCoefficient();
        RegularRingElem c = ci.multiply(cj);
        for (int k = 0; k < this.P.size(); ++k) {
            GenPolynomial A = (GenPolynomial)this.P.get(k);
            ExpVector ek = A.leadingExpVector();
            boolean m = eij.multipleOf(ek);
            if (m) {
                RegularRingElem ck = (RegularRingElem)A.leadingBaseCoefficient();
                RegularRingElem r = c.multiply(ck);
                m = r.isZERO();
            }
            if (!m) continue;
            if (k < i) {
                boolean bl = s = ((BitSet)this.red.get(i)).get(k) || ((BitSet)this.red.get(j)).get(k);
            }
            if (i < k && k < j) {
                boolean bl = s = ((BitSet)this.red.get(k)).get(i) || ((BitSet)this.red.get(j)).get(k);
            }
            if (j < k) {
                boolean bl = s = ((BitSet)this.red.get(k)).get(i) || ((BitSet)this.red.get(k)).get(j);
            }
            if (s) continue;
            return s;
        }
        return true;
    }
}

