/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gb.ExtendedGB;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionSeq;
import edu.jas.gbmod.ModGroebnerBaseAbstract;
import edu.jas.gbmod.ResPart;
import edu.jas.gbmod.ResPolPart;
import edu.jas.gbmod.Syzygy;
import edu.jas.gbufd.GBFactory;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.ModulElem;
import edu.jas.vector.BasicLinAlg;
import edu.jas.vector.GenVector;
import edu.jas.vector.GenVectorModul;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyzygyAbstract<C extends GcdRingElem<C>>
implements Syzygy<C> {
    private static final Logger logger = Logger.getLogger(SyzygyAbstract.class);
    private final boolean debug = logger.isDebugEnabled();
    protected Reduction<C> red = new ReductionSeq();
    protected BasicLinAlg<GenPolynomial<C>> blas = new BasicLinAlg();

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(List<GenPolynomial<C>> F) {
        return this.zeroRelations(0, F);
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(int modv, List<GenPolynomial<C>> F) {
        ArrayList<List<GenPolynomial<C>>> Z = new ArrayList<List<GenPolynomial<C>>>();
        if (F == null) {
            return Z;
        }
        GenVectorModul mfac = null;
        int i = 0;
        while (mfac == null && i < F.size()) {
            GenPolynomial<C> p = F.get(i);
            if (p == null) continue;
            mfac = new GenVectorModul(p.ring, F.size());
        }
        if (mfac == null) {
            return Z;
        }
        ModulElem v = mfac.fromList(F);
        return this.zeroRelations(modv, (GenVector<GenPolynomial<C>>)v);
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelations(int modv, GenVector<GenPolynomial<C>> v) {
        ArrayList<List<GenPolynomial<C>>> Z = new ArrayList<List<GenPolynomial<C>>>();
        GenVectorModul mfac = v.modul;
        List F = v.val;
        AbelianGroupElem S = mfac.getZERO();
        for (int i = 0; i < F.size(); ++i) {
            GenPolynomial pi = (GenPolynomial)F.get(i);
            for (int j = i + 1; j < F.size(); ++j) {
                GenPolynomial pj = (GenPolynomial)F.get(j);
                if (!this.red.moduleCriterion(modv, pi, pj)) continue;
                List row = ((GenVector)((GenVector)S).copy()).val;
                GenPolynomial<C> s = this.red.SPolynomial(row, i, pi, j, pj);
                if (s.isZERO()) {
                    Z.add(row);
                    continue;
                }
                GenPolynomial<C> h = this.red.normalform(row, F, s);
                if (!h.isZERO()) {
                    throw new RuntimeException("Syzygy no GB");
                }
                if (this.debug) {
                    logger.info((Object)("row = " + row.size()));
                }
                Z.add(row);
            }
        }
        return Z;
    }

    @Override
    public ModuleList<C> zeroRelations(ModuleList<C> M) {
        ModuleList<C> N = M;
        if (M == null || M.list == null) {
            return N;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N;
        }
        AbelianGroupElem zero = M.ring.getZERO();
        PolynomialList<C> F = M.getPolynomialList();
        int modv = M.cols;
        List G = this.zeroRelations(modv, F.list);
        ArrayList Z = new ArrayList();
        for (int i = 0; i < G.size(); ++i) {
            List Gi = G.get(i);
            ArrayList<AbelianGroupElem> Zi = new ArrayList<AbelianGroupElem>();
            for (int j = 0; j < Gi.size(); ++j) {
                GenPolynomial p = Gi.get(j);
                if (p == null) continue;
                Map r = p.contract(M.ring);
                int s = 0;
                for (GenPolynomial vi : r.values()) {
                    Zi.add(vi);
                    ++s;
                }
                if (s == 0) {
                    Zi.add(zero);
                    continue;
                }
                if (s <= true) continue;
                System.out.println("p = " + p);
                System.out.println("map(" + i + "," + j + ") = " + r + ", size = " + r.size());
                throw new RuntimeException("Map.size() > 1 = " + r.size());
            }
            Z.add(Zi);
        }
        N = new ModuleList(M.ring, Z);
        return N;
    }

    @Override
    public boolean isZeroRelation(List<List<GenPolynomial<C>>> Z, List<GenPolynomial<C>> F) {
        for (List<GenPolynomial<C>> row : Z) {
            GenPolynomial<C> p = this.blas.scalarProduct(row, F);
            if (p == null || p.isZERO()) continue;
            logger.info((Object)("is not ZeroRelation = " + p.toString(p.ring.getVars())));
            logger.info((Object)("row = " + row));
            return false;
        }
        return true;
    }

    @Override
    public boolean isZeroRelation(ModuleList<C> Z, ModuleList<C> F) {
        if (Z == null || Z.list == null) {
            return true;
        }
        for (List row : Z.list) {
            List zr = this.blas.leftScalarProduct(row, F.list);
            if (this.blas.isZero(zr)) continue;
            logger.info((Object)("is not ZeroRelation (" + zr.size() + ") = " + zr));
            return false;
        }
        return true;
    }

    @Override
    public List<ResPart<C>> resolution(ModuleList<C> M) {
        ArrayList<ResPart<C>> R = new ArrayList<ResPart<C>>();
        ModuleList<C> MM = M;
        ModGroebnerBaseAbstract<C> mbb = new ModGroebnerBaseAbstract<C>(M.ring.coFac);
        while (true) {
            ModuleList<C> GM = mbb.GB(MM);
            ModuleList<C> Z = this.zeroRelations(GM);
            R.add(new ResPart<C>(MM, GM, Z));
            if (Z == null || Z.list == null || Z.list.size() == 0) break;
            MM = Z;
        }
        return R;
    }

    @Override
    public List resolution(PolynomialList<C> F) {
        GroebnerBaseAbstract gb = GBFactory.getImplementation(F.ring.coFac);
        List G = gb.GB(F.list);
        List Z = this.zeroRelations(G);
        PolynomialList Gl = new PolynomialList(F.ring, G);
        ModuleList Zm = new ModuleList(F.ring, Z);
        List R = this.resolution(Zm);
        R.add(0, new ResPolPart<C>(F, Gl, Zm));
        return R;
    }

    @Override
    public List resolutionArbitrary(PolynomialList<C> F) {
        PolynomialList Gl = null;
        List Z = this.zeroRelationsArbitrary(F.list);
        ModuleList Zm = new ModuleList(F.ring, Z);
        List R = this.resolutionArbitrary(Zm);
        R.add(0, new ResPolPart<C>(F, Gl, Zm));
        return R;
    }

    @Override
    public List<ResPart<C>> resolutionArbitrary(ModuleList<C> M) {
        ArrayList<ResPart<C>> R = new ArrayList<ResPart<C>>();
        ModuleList<C> MM = M;
        ModuleList GM = null;
        while (true) {
            ModuleList<C> Z = this.zeroRelationsArbitrary(MM);
            R.add(new ResPart<C>(MM, GM, Z));
            if (Z == null || Z.list == null || Z.list.size() == 0) break;
            MM = Z;
        }
        return R;
    }

    @Override
    public List<List<GenPolynomial<C>>> zeroRelationsArbitrary(List<GenPolynomial<C>> F) {
        return this.zeroRelationsArbitrary(0, F);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<List<GenPolynomial<C>>> zeroRelationsArbitrary(int modv, List<GenPolynomial<C>> F) {
        if (F == null) {
            return new ArrayList<List<GenPolynomial<C>>>();
        }
        if (F.size() <= 1) {
            return this.zeroRelations(modv, F);
        }
        GroebnerBaseAbstract<C> gb = GBFactory.getImplementation(F.get((int)0).ring.coFac);
        int lenf = F.size();
        ExtendedGB<C> exgb = gb.extGB(F);
        if (this.debug) {
            logger.debug((Object)("exgb = " + exgb));
            if (!gb.isReductionMatrix(exgb)) {
                logger.error((Object)"is reduction matrix ? false");
            }
        }
        List G = exgb.G;
        List G2F = exgb.G2F;
        List F2G = exgb.F2G;
        List sg = this.zeroRelations(modv, G);
        GenPolynomialRing ring = G.get((int)0).ring;
        ModuleList S = new ModuleList(ring, sg);
        if (this.debug) {
            logger.debug((Object)("syz = " + S));
            if (!this.isZeroRelation(sg, G)) {
                logger.error((Object)"is syzygy ? false");
            }
        }
        ArrayList<List<GenPolynomial<C>>> sf = new ArrayList<List<GenPolynomial<C>>>(sg.size());
        for (List r : sg) {
            void var18_21;
            Iterator it = r.iterator();
            Iterator jt = G2F.iterator();
            List rf = new ArrayList<AbelianGroupElem>(lenf);
            boolean bl = false;
            while (var18_21 < lenf) {
                rf.add(ring.getZERO());
                ++var18_21;
            }
            while (it.hasNext() && jt.hasNext()) {
                GenPolynomial genPolynomial = it.next();
                List ai = jt.next();
                if (genPolynomial == null || ai == null) continue;
                List pi = this.blas.scalarProduct(genPolynomial, ai);
                rf = this.blas.vectorAdd(rf, pi);
            }
            if (it.hasNext() || jt.hasNext()) {
                logger.error((Object)"zeroRelationsArbitrary wrong sizes");
            }
            sf.add(rf);
        }
        ArrayList<void> M = new ArrayList<void>(lenf);
        for (List r : F2G) {
            void var18_24;
            Iterator it = r.iterator();
            Iterator jt = G2F.iterator();
            ArrayList<AbelianGroupElem> arrayList = new ArrayList<AbelianGroupElem>(lenf);
            for (int m = 0; m < lenf; ++m) {
                arrayList.add(ring.getZERO());
            }
            while (it.hasNext() && jt.hasNext()) {
                GenPolynomial si = it.next();
                List ai = jt.next();
                if (si == null || ai == null) continue;
                List pi = this.blas.scalarProduct(ai, si);
                List list = this.blas.vectorAdd(var18_24, pi);
            }
            if (it.hasNext() || jt.hasNext()) {
                logger.error((Object)"zeroRelationsArbitrary wrong sizes");
            }
            M.add(var18_24);
        }
        int sflen = sf.size();
        ArrayList M2 = new ArrayList(lenf);
        int i = 0;
        for (List list : M) {
            ArrayList<GenPolynomial<GenPolynomial>> r2i = new ArrayList<GenPolynomial<GenPolynomial>>(list.size());
            int j = 0;
            for (GenPolynomial rij : list) {
                AbelianGroupElem p = null;
                if (i == j) {
                    p = ((GenPolynomial)ring.getONE()).subtract(rij);
                } else if (rij != null) {
                    p = rij.negate();
                }
                r2i.add((GenPolynomial<GenPolynomial>)p);
                ++j;
            }
            M2.add(r2i);
            if (!this.blas.isZero(r2i)) {
                sf.add(r2i);
            }
            ++i;
        }
        if (this.debug) {
            ModuleList M2L = new ModuleList(ring, M2);
            logger.debug((Object)("syz M2L = " + M2L));
            ModuleList moduleList = new ModuleList(ring, sf);
            logger.debug((Object)("syz sf = " + moduleList));
            logger.debug((Object)("#syz " + sflen + ", " + sf.size()));
            if (!this.isZeroRelation(sf, F)) {
                logger.error((Object)"is syz sf ? false");
            }
        }
        return sf;
    }

    @Override
    public ModuleList<C> zeroRelationsArbitrary(ModuleList<C> M) {
        ModuleList<C> N = M;
        if (M == null || M.list == null) {
            return N;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N;
        }
        AbelianGroupElem zero = M.ring.getZERO();
        PolynomialList<C> F = M.getPolynomialList();
        int modv = M.cols;
        List G = this.zeroRelationsArbitrary(modv, F.list);
        ArrayList Z = new ArrayList();
        for (int i = 0; i < G.size(); ++i) {
            List Gi = G.get(i);
            ArrayList<AbelianGroupElem> Zi = new ArrayList<AbelianGroupElem>();
            for (int j = 0; j < Gi.size(); ++j) {
                GenPolynomial p = Gi.get(j);
                if (p == null) continue;
                Map r = p.contract(M.ring);
                int s = 0;
                for (GenPolynomial vi : r.values()) {
                    Zi.add(vi);
                    ++s;
                }
                if (s == 0) {
                    Zi.add(zero);
                    continue;
                }
                if (s <= true) continue;
                System.out.println("p = " + p);
                System.out.println("map(" + i + "," + j + ") = " + r + ", size = " + r.size());
                throw new RuntimeException("Map.size() > 1 = " + r.size());
            }
            Z.add(Zi);
        }
        N = new ModuleList(M.ring, Z);
        return N;
    }
}

