/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbmod;

import edu.jas.gb.SolvableGroebnerBase;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.gbmod.ModSolvableGroebnerBase;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ModSolvableGroebnerBaseAbstract<C extends RingElem<C>>
implements ModSolvableGroebnerBase<C> {
    private static final Logger logger = Logger.getLogger(ModSolvableGroebnerBase.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final SolvableGroebnerBase<C> sbb = new SolvableGroebnerBaseSeq();

    @Override
    public boolean isLeftGB(int modv, List<GenSolvablePolynomial<C>> F) {
        return this.sbb.isLeftGB(modv, F);
    }

    @Override
    public boolean isLeftGB(ModuleList<C> M) {
        if (M == null || M.list == null) {
            return true;
        }
        if (M.rows == 0 || M.cols == 0) {
            return true;
        }
        int modv = M.cols;
        PolynomialList<C> F = M.getPolynomialList();
        return this.sbb.isLeftGB(modv, F.castToSolvableList());
    }

    @Override
    public List<GenSolvablePolynomial<C>> leftGB(int modv, List<GenSolvablePolynomial<C>> F) {
        return this.sbb.leftGB(modv, F);
    }

    @Override
    public ModuleList<C> leftGB(ModuleList<C> M) {
        ModuleList<C> N = M;
        if (M == null || M.list == null) {
            return N;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N;
        }
        PolynomialList<C> F = M.getPolynomialList();
        if (this.debug) {
            logger.info((Object)("F left +++++++++++++++++++ \n" + F));
        }
        GenSolvablePolynomialRing sring = (GenSolvablePolynomialRing)F.ring;
        int modv = M.cols;
        List<GenSolvablePolynomial<C>> G = this.sbb.leftGB(modv, F.castToSolvableList());
        F = new PolynomialList<C>(sring, G);
        if (this.debug) {
            logger.info((Object)("G left +++++++++++++++++++ \n" + F));
        }
        N = F.getModuleList(modv);
        return N;
    }

    @Override
    public boolean isTwosidedGB(int modv, List<GenSolvablePolynomial<C>> F) {
        return this.sbb.isTwosidedGB(modv, F);
    }

    @Override
    public boolean isTwosidedGB(ModuleList<C> M) {
        if (M == null || M.list == null) {
            return true;
        }
        if (M.rows == 0 || M.cols == 0) {
            return true;
        }
        PolynomialList<C> F = M.getPolynomialList();
        int modv = M.cols;
        return this.sbb.isTwosidedGB(modv, F.castToSolvableList());
    }

    @Override
    public List<GenSolvablePolynomial<C>> twosidedGB(int modv, List<GenSolvablePolynomial<C>> F) {
        return this.sbb.twosidedGB(modv, F);
    }

    @Override
    public ModuleList<C> twosidedGB(ModuleList<C> M) {
        ModuleList<C> N = M;
        if (M == null || M.list == null) {
            return N;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N;
        }
        PolynomialList<C> F = M.getPolynomialList();
        GenSolvablePolynomialRing sring = (GenSolvablePolynomialRing)F.ring;
        int modv = M.cols;
        List<GenSolvablePolynomial<C>> G = this.sbb.twosidedGB(modv, F.castToSolvableList());
        F = new PolynomialList<C>(sring, G);
        N = F.getModuleList(modv);
        return N;
    }

    @Override
    public boolean isRightGB(int modv, List<GenSolvablePolynomial<C>> F) {
        return this.sbb.isRightGB(modv, F);
    }

    @Override
    public boolean isRightGB(ModuleList<C> M) {
        if (M == null || M.list == null) {
            return true;
        }
        if (M.rows == 0 || M.cols == 0) {
            return true;
        }
        int modv = M.cols;
        PolynomialList<C> F = M.getPolynomialList();
        return this.sbb.isRightGB(modv, F.castToSolvableList());
    }

    @Override
    public List<GenSolvablePolynomial<C>> rightGB(int modv, List<GenSolvablePolynomial<C>> F) {
        if (modv == 0) {
            return this.sbb.rightGB(modv, F);
        }
        throw new UnsupportedOperationException("modv != 0 not jet implemented");
    }

    @Override
    public ModuleList<C> rightGB(ModuleList<C> M) {
        TermOrder to;
        ModuleList<C> N = M;
        if (M == null || M.list == null) {
            return N;
        }
        if (M.rows == 0 || M.cols == 0) {
            return N;
        }
        if (this.debug) {
            logger.info((Object)("M ====================== \n" + M));
        }
        if ((to = M.ring.tord).getSplit() <= M.ring.nvar) {
            throw new IllegalArgumentException("extended TermOrders not supported for rightGBs: " + to);
        }
        List<List<GenSolvablePolynomial<C>>> mlist = M.castToSolvableList();
        GenPolynomialRing sring = (GenSolvablePolynomialRing)M.ring;
        GenPolynomialRing rring = sring.reverse(true);
        sring = ((GenSolvablePolynomialRing)rring).reverse(true);
        ArrayList<List<GenSolvablePolynomial<Object>>> nlist = new ArrayList(M.rows);
        for (List<GenSolvablePolynomial<C>> row : mlist) {
            ArrayList<GenSolvablePolynomial> nrow = new ArrayList<GenSolvablePolynomial>(row.size());
            for (GenSolvablePolynomial<C> elem : row) {
                GenSolvablePolynomial nelem = (GenSolvablePolynomial)elem.reverse(rring);
                nrow.add(nelem);
            }
            nlist.add(nrow);
        }
        ModuleList rM = new ModuleList(rring, nlist);
        if (this.debug) {
            logger.info((Object)("rM -------------------- \n" + rM));
        }
        ModuleList rMg = this.leftGB(rM);
        if (this.debug) {
            logger.info((Object)("rMg -------------------- \n" + rMg));
            logger.info((Object)("isLeftGB(rMg) ---------- " + this.isLeftGB(rMg)));
        }
        mlist = rMg.castToSolvableList();
        nlist = new ArrayList(rMg.rows);
        for (List<GenSolvablePolynomial<C>> row : mlist) {
            ArrayList<GenSolvablePolynomial> nrow = new ArrayList<GenSolvablePolynomial>(row.size());
            for (GenSolvablePolynomial<C> elem : row) {
                GenSolvablePolynomial nelem = (GenSolvablePolynomial)elem.reverse(sring);
                nrow.add(nelem);
            }
            nlist.add(nrow);
        }
        ModuleList Mg = new ModuleList(sring, nlist);
        if (this.debug) {
            logger.info((Object)("Mg -------------------- \n" + Mg));
            logger.info((Object)("isRightGB(Mg) --------- " + this.isRightGB(Mg)));
        }
        return Mg;
    }
}

